/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.generators;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class StructureComponentGen
extends StructureComponent {
    public StructureBoundingBox field_74887_e;
    @Nullable
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;
    protected int field_74886_g;

    public StructureComponentGen() {
    }

    protected StructureComponentGen(int type) {
        this.field_74886_g = type;
    }

    protected abstract void func_143012_a(NBTTagCompound var1);

    public void func_143009_a(World worldIn, NBTTagCompound tagCompound) {
        int i;
        if (tagCompound.func_74764_b("BB")) {
            this.field_74887_e = new StructureBoundingBox(tagCompound.func_74759_k("BB"));
        }
        this.func_186164_a((i = tagCompound.func_74762_e("O")) == -1 ? null : EnumFacing.func_176731_b((int)i));
        this.field_74886_g = tagCompound.func_74762_e("GD");
        this.func_143011_b(tagCompound, worldIn.func_72860_G().func_186340_h());
    }

    protected abstract void func_143011_b(NBTTagCompound var1, TemplateManager var2);

    public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
    }

    public abstract boolean func_74875_a(World var1, Random var2, StructureBoundingBox var3);

    public StructureBoundingBox func_74874_b() {
        return this.field_74887_e;
    }

    public int func_74877_c() {
        return this.field_74886_g;
    }

    public static StructureComponent findIntersecting(List<StructureComponent> listIn, StructureBoundingBox boundingboxIn) {
        for (StructureComponent structurecomponent : listIn) {
            if (structurecomponent.func_74874_b() == null || !structurecomponent.func_74874_b().func_78884_a(boundingboxIn)) continue;
            return structurecomponent;
        }
        return null;
    }

    protected boolean func_74860_a(World worldIn, StructureBoundingBox boundingboxIn) {
        int i = Math.max(this.field_74887_e.field_78897_a - 1, boundingboxIn.field_78897_a);
        int j = Math.max(this.field_74887_e.field_78895_b - 1, boundingboxIn.field_78895_b);
        int k = Math.max(this.field_74887_e.field_78896_c - 1, boundingboxIn.field_78896_c);
        int l = Math.min(this.field_74887_e.field_78893_d + 1, boundingboxIn.field_78893_d);
        int i1 = Math.min(this.field_74887_e.field_78894_e + 1, boundingboxIn.field_78894_e);
        int j1 = Math.min(this.field_74887_e.field_78892_f + 1, boundingboxIn.field_78892_f);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = k; l1 <= j1; ++l1) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k1, j, l1)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int i2 = i; i2 <= l; ++i2) {
            for (int k2 = j; k2 <= i1; ++k2) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i2, k2, k)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i2, k2, j1)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (int j2 = k; j2 <= j1; ++j2) {
            for (int l2 = j; l2 <= i1; ++l2) {
                if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, l2, j2)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, l2, j2)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected int func_74865_a(int x, int z) {
        EnumFacing enumfacing = this.func_186165_e();
        if (enumfacing == null) {
            return x;
        }
        switch (enumfacing) {
            case NORTH: 
            case SOUTH: {
                return this.field_74887_e.field_78897_a + x;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - z;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int func_74862_a(int y) {
        return this.func_186165_e() == null ? y : y + this.field_74887_e.field_78895_b;
    }

    protected int func_74873_b(int x, int z) {
        EnumFacing enumfacing = this.func_186165_e();
        if (enumfacing == null) {
            return z;
        }
        switch (enumfacing) {
            case NORTH: {
                return this.field_74887_e.field_78892_f - z;
            }
            case SOUTH: {
                return this.field_74887_e.field_78896_c + z;
            }
            case WEST: 
            case EAST: {
                return this.field_74887_e.field_78896_c + x;
            }
        }
        return z;
    }

    protected void func_175811_a(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundingboxIn.func_175898_b((Vec3i)blockpos)) {
            if (this.mirror != Mirror.NONE) {
                blockstateIn = blockstateIn.func_185902_a(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                blockstateIn = blockstateIn.func_185907_a(this.rotation);
            }
            worldIn.func_180501_a(blockpos, blockstateIn, 2);
        }
    }

    protected IBlockState func_175807_a(World worldIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z));
        return !boundingboxIn.func_175898_b((Vec3i)blockpos) ? Blocks.field_150350_a.func_176223_P() : worldIn.func_180495_p(blockpos);
    }

    protected int func_189916_b(World worldIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockpos = new BlockPos(i, j = this.func_74862_a(y + 1), k = this.func_74873_b(x, z));
        return !boundingboxIn.func_175898_b((Vec3i)blockpos) ? EnumSkyBlock.SKY.field_77198_c : worldIn.func_175642_b(EnumSkyBlock.SKY, blockpos);
    }

    protected void func_74878_a(World worldIn, StructureBoundingBox structurebb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), j, i, k, structurebb);
                }
            }
        }
    }

    protected void func_175804_a(World worldIn, StructureBoundingBox boundingboxIn, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockState boundaryBlockState, IBlockState insideBlockState, boolean existingOnly) {
        for (int i = yMin; i <= yMax; ++i) {
            for (int j = xMin; j <= xMax; ++j) {
                for (int k = zMin; k <= zMax; ++k) {
                    if (existingOnly && this.func_175807_a(worldIn, j, i, k, boundingboxIn).func_185904_a() == Material.field_151579_a) continue;
                    if (i != yMin && i != yMax && j != xMin && j != xMax && k != zMin && k != zMax) {
                        this.func_175811_a(worldIn, insideBlockState, j, i, k, boundingboxIn);
                        continue;
                    }
                    this.func_175811_a(worldIn, boundaryBlockState, j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_74882_a(World worldIn, StructureBoundingBox boundingboxIn, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean alwaysReplace, Random rand, StructureComponent.BlockSelector blockselector) {
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    if (alwaysReplace && this.func_175807_a(worldIn, j, i, k, boundingboxIn).func_185904_a() == Material.field_151579_a) continue;
                    blockselector.func_75062_a(rand, j, i, k, i == minY || i == maxY || j == minX || j == maxX || k == minZ || k == maxZ);
                    this.func_175811_a(worldIn, blockselector.func_180780_a(), j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_189914_a(World worldIn, StructureBoundingBox sbb, Random rand, float chance, int x1, int y1, int z1, int x2, int y2, int z2, IBlockState edgeState, IBlockState state, boolean requireNonAir, int requiredSkylight) {
        for (int i = y1; i <= y2; ++i) {
            for (int j = x1; j <= x2; ++j) {
                for (int k = z1; k <= z2; ++k) {
                    if (!(rand.nextFloat() <= chance) || requireNonAir && this.func_175807_a(worldIn, j, i, k, sbb).func_185904_a() == Material.field_151579_a || requiredSkylight > 0 && this.func_189916_b(worldIn, j, i, k, sbb) >= requiredSkylight) continue;
                    if (i != y1 && i != y2 && j != x1 && j != x2 && k != z1 && k != z2) {
                        this.func_175811_a(worldIn, state, j, i, k, sbb);
                        continue;
                    }
                    this.func_175811_a(worldIn, edgeState, j, i, k, sbb);
                }
            }
        }
    }

    protected void func_175809_a(World worldIn, StructureBoundingBox boundingboxIn, Random rand, float chance, int x, int y, int z, IBlockState blockstateIn) {
        if (rand.nextFloat() < chance) {
            this.func_175811_a(worldIn, blockstateIn, x, y, z, boundingboxIn);
        }
    }

    protected void func_180777_a(World worldIn, StructureBoundingBox boundingboxIn, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState blockstateIn, boolean excludeAir) {
        float f = maxX - minX + 1;
        float f1 = maxY - minY + 1;
        float f2 = maxZ - minZ + 1;
        float f3 = (float)minX + f / 2.0f;
        float f4 = (float)minZ + f2 / 2.0f;
        for (int i = minY; i <= maxY; ++i) {
            float f5 = (float)(i - minY) / f1;
            for (int j = minX; j <= maxX; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = minZ; k <= maxZ; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (excludeAir && this.func_175807_a(worldIn, j, i, k, boundingboxIn).func_185904_a() == Material.field_151579_a || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.func_175811_a(worldIn, blockstateIn, j, i, k, boundingboxIn);
                }
            }
        }
    }

    protected void func_74871_b(World worldIn, int x, int y, int z, StructureBoundingBox structurebb) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (structurebb.func_175898_b((Vec3i)blockpos)) {
            while (!worldIn.func_175623_d(blockpos) && blockpos.func_177956_o() < 255) {
                worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
                blockpos = blockpos.func_177984_a();
            }
        }
    }

    protected void func_175808_b(World worldIn, IBlockState blockstateIn, int x, int y, int z, StructureBoundingBox boundingboxIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        if (boundingboxIn.func_175898_b((Vec3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
            while ((worldIn.func_175623_d(new BlockPos(i, j, k)) || worldIn.func_180495_p(new BlockPos(i, j, k)).func_185904_a().func_76224_d()) && j > 1) {
                worldIn.func_180501_a(new BlockPos(i, j, k), blockstateIn, 2);
                --j;
            }
        }
    }

    protected boolean func_186167_a(World worldIn, StructureBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        return this.func_191080_a(worldIn, structurebb, randomIn, blockpos, loot, null);
    }

    protected boolean func_191080_a(World p_191080_1_, StructureBoundingBox p_191080_2_, Random p_191080_3_, BlockPos p_191080_4_, ResourceLocation p_191080_5_, @Nullable IBlockState p_191080_6_) {
        if (p_191080_2_.func_175898_b((Vec3i)p_191080_4_) && p_191080_1_.func_180495_p(p_191080_4_).func_177230_c() != Blocks.field_150486_ae) {
            if (p_191080_6_ == null) {
                p_191080_6_ = Blocks.field_150486_ae.func_176458_f(p_191080_1_, p_191080_4_, Blocks.field_150486_ae.func_176223_P());
            }
            p_191080_1_.func_180501_a(p_191080_4_, p_191080_6_, 2);
            TileEntity tileentity = p_191080_1_.func_175625_s(p_191080_4_);
            if (tileentity instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).func_189404_a(p_191080_5_, p_191080_3_.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean func_189419_a(World worldIn, StructureBoundingBox sbb, Random rand, int x, int y, int z, EnumFacing facing, ResourceLocation lootTableIn) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (sbb.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150367_z) {
            this.func_175811_a(worldIn, Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)facing), x, y, z, sbb);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityDispenser) {
                ((TileEntityDispenser)tileentity).func_189404_a(lootTableIn, rand.nextLong());
            }
            return true;
        }
        return false;
    }

    protected void func_189915_a(World worldIn, StructureBoundingBox sbb, Random rand, int x, int y, int z, EnumFacing facing, BlockDoor door) {
        this.func_175811_a(worldIn, door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing), x, y, z, sbb);
        this.func_175811_a(worldIn, door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)facing).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), x, y + 1, z, sbb);
    }

    public void func_181138_a(int x, int y, int z) {
        this.field_74887_e.func_78886_a(x, y, z);
    }

    @Nullable
    public EnumFacing func_186165_e() {
        return this.coordBaseMode;
    }

    public void func_186164_a(@Nullable EnumFacing facing) {
        this.coordBaseMode = facing;
        if (facing == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public static abstract class BlockSelector {
        protected IBlockState blockstate = Blocks.field_150350_a.func_176223_P();

        public abstract void selectBlocks(Random var1, int var2, int var3, int var4, boolean var5);

        public IBlockState getBlockState() {
            return this.blockstate;
        }
    }
}

