/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.generators.block;

import com.google.common.base.Predicate;
import com.matez.wildnature.blocks.RockBase;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class Fossil {
    private ArrayList<WorldGenerator> fossilGens = new ArrayList();
    private int size;
    private int chance;
    private int minY;
    private int maxY;
    private ArrayList<Block> states;
    private IBlockState fossil;
    private ArrayList<Biome> biomes;
    private boolean waterRequired = false;

    public Fossil(IBlockState fossil, int blockCount, int chance, int minY, int maxY, Block ... whereToSpawn) {
        this.fossil = fossil;
        this.states = new ArrayList<Block>(Arrays.asList(whereToSpawn));
        this.chance = chance;
        this.maxY = maxY;
        this.minY = minY;
        for (int x = 0; x < this.states.size(); ++x) {
            WorldGenMinable gen = new WorldGenMinable(fossil, blockCount, (Predicate)BlockMatcher.func_177642_a((Block)this.states.get(x)));
            this.fossilGens.add((WorldGenerator)gen);
        }
    }

    public Fossil(IBlockState fossil, int blockCount, int chance, Block ... whereToSpawn) {
        this.fossil = fossil;
        this.states = new ArrayList<Block>(Arrays.asList(whereToSpawn));
        this.chance = chance;
        for (int x = 0; x < this.states.size(); ++x) {
            WorldGenMinable gen = new WorldGenMinable(fossil, blockCount, (Predicate)BlockMatcher.func_177642_a((Block)this.states.get(x)));
            this.fossilGens.add((WorldGenerator)gen);
        }
    }

    public void spawnNearWater(boolean bool) {
        this.waterRequired = bool;
    }

    public boolean isWaterRequired() {
        return this.waterRequired;
    }

    public void addAllowedBiomes(Biome ... biomes) {
        this.biomes = new ArrayList<Biome>(Arrays.asList(biomes));
    }

    public boolean canSpawnOnAllBiomes() {
        return this.biomes == null;
    }

    public ArrayList<Biome> getAllowedBiomes() {
        return this.biomes;
    }

    public IBlockState getFossil() {
        return this.fossil;
    }

    public int getChance() {
        return this.chance;
    }

    public int getMaxY(World world) {
        if (this.fossil.func_177230_c() instanceof RockBase) {
            this.maxY = ((RockBase)this.fossil.func_177230_c()).getMaxYByType(world);
        }
        return this.maxY;
    }

    public int getMinY(World world) {
        if (this.fossil.func_177230_c() instanceof RockBase) {
            this.minY = ((RockBase)this.fossil.func_177230_c()).getMinYByType(world);
        }
        return this.minY;
    }

    public ArrayList<WorldGenerator> getFossilGens() {
        return this.fossilGens;
    }

    public int getSize() {
        return this.size;
    }

    public ArrayList<Block> getStates() {
        return this.states;
    }
}

