/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen.generators.block;

import com.matez.wildnature.Main;
import com.matez.wildnature.init.BiomeInit;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.generators.block.Fossil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenBlocks
implements IWorldGenerator {
    private Block[] defaultRocks = new Block[]{Blocks.field_150348_b, ModBlocks.FROZEN_STONE, ModBlocks.HARDENED_SANDSTONE, ModBlocks.RED_HARDENED_SANDSTONE};
    private Block[] defaultGround = new Block[]{Blocks.field_150349_c, ModBlocks.BROWN_GRASS_BLOCK, ModBlocks.DESERT_GRASS_BLOCK, ModBlocks.DRIED_GRASS_BLOCK, ModBlocks.MOLD_GRASS_BLOCK, Blocks.field_150346_d, ModBlocks.ZIEMA_BRUNATNA, ModBlocks.ZIEMA_CZARNOZIEM, ModBlocks.ZIEMA_PUSTYNNA, ModBlocks.ZIEMA_SUCHA};
    private ArrayList<Block> defaultRocksAr = new ArrayList<Block>(Arrays.asList(this.defaultRocks));
    private Fossil BASALT_GEN = new Fossil(ModBlocks.BASALT.func_176223_P(), this.defaultBlockCountForRocks, 60, this.defaultRocks);
    private Fossil CARBONATITE_GEN = new Fossil(ModBlocks.CARBONATITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil CHALK_GEN = new Fossil(ModBlocks.CHALK.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil CONGLOMERATE_GEN = new Fossil(ModBlocks.CONGLOMERATE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil DOLOMITE_GEN = new Fossil(ModBlocks.DOLOMITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil EPIDOSITE_GEN = new Fossil(ModBlocks.EPIDOSITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil GABBRO_GEN = new Fossil(ModBlocks.GABBRO.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil GNEISS_GEN = new Fossil(ModBlocks.GNEISS.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil GYPSUM_GEN = new Fossil(ModBlocks.GYPSUM.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil LIMESTONE_GEN = new Fossil(ModBlocks.LIMESTONE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil MARBLE_GEN = new Fossil(ModBlocks.MARBLE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil MONZONITE_GEN = new Fossil(ModBlocks.MONZONITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil PEGMATITE_GEN = new Fossil(ModBlocks.PEGMATITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil PHYLLITE_GEN = new Fossil(ModBlocks.PHYLLITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil PUMICE_GEN = new Fossil(ModBlocks.PUMICE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil PYROXENITE_GEN = new Fossil(ModBlocks.PYROXENITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil RHYOLLITE_GEN = new Fossil(ModBlocks.RHYOLITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil SLATE_GEN = new Fossil(ModBlocks.SLATE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil SYENITE_GEN = new Fossil(ModBlocks.SYENITE.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil UMBER_GEN = new Fossil(ModBlocks.UMBER.func_176223_P(), this.defaultBlockCountForRocks, 80, this.defaultRocks);
    private Fossil MUD_GEN = new Fossil(ModBlocks.MUD.func_176223_P(), 7, 140, 55, 69, this.defaultGround);
    private Fossil HS_GEN;
    private Fossil RHS_GEN;
    private Fossil ASH_GEN;
    private Fossil DS_GEN;
    private Fossil FS_GEN;
    private int defaultBlockCountForRocks = 5;

    public WorldGenBlocks() {
        this.MUD_GEN.spawnNearWater(true);
        this.MUD_GEN.addAllowedBiomes(Main.getBiomeByName("swampland"), Main.getBiomeByName("mutated_swampland"), BiomeInit.MISTY_SWAMP);
        this.HS_GEN = new Fossil(ModBlocks.HARDENED_SANDSTONE.func_176223_P(), 15, 20, 255, 66, Blocks.field_150348_b);
        this.HS_GEN.addAllowedBiomes(Main.BiomesDESERT.toArray(new Biome[Main.BiomesDESERT.size()]));
        this.RHS_GEN = new Fossil(ModBlocks.RED_HARDENED_SANDSTONE.func_176223_P(), 15, 20, 255, 66, Blocks.field_150348_b);
        this.RHS_GEN.addAllowedBiomes(Main.mesaBiomes.toArray(new Biome[Main.mesaBiomes.size()]));
        this.ASH_GEN = new Fossil(ModBlocks.ASH_BLOCK.func_176223_P(), 15, 70, 20, 255, Blocks.field_150348_b);
        this.ASH_GEN.addAllowedBiomes(Main.volcanoBiomes.toArray(new Biome[Main.volcanoBiomes.size()]));
        this.DS_GEN = new Fossil(ModBlocks.DARK_STONE.func_176223_P(), 15, 70, 20, 255, Blocks.field_150348_b);
        this.DS_GEN.addAllowedBiomes(Main.mistyMountainsBiomes.toArray(new Biome[Main.mistyMountainsBiomes.size()]));
        this.FS_GEN = new Fossil(ModBlocks.FROZEN_STONE.func_176223_P(), 15, 70, 20, 255, Blocks.field_150348_b);
        this.FS_GEN.addAllowedBiomes(Main.BiomesICY.toArray(new Biome[Main.BiomesICY.size()]));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dim = world.field_73011_w.getDimension();
        if (dim == 0) {
            this.runGenerator(this.BASALT_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.CARBONATITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.CHALK_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.CONGLOMERATE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.DOLOMITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.EPIDOSITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.GABBRO_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.GNEISS_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.GYPSUM_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.LIMESTONE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.MARBLE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.MONZONITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.PEGMATITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.PHYLLITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.PUMICE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.PYROXENITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.RHYOLLITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.SLATE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.SYENITE_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.UMBER_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.MUD_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.HS_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.RHS_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.ASH_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.DS_GEN, world, random, chunkX, chunkZ);
            this.runGenerator(this.FS_GEN, world, random, chunkX, chunkZ);
        }
    }

    private void runGenerator(Fossil fossil, World world, Random rand, int chunkX, int chunkZ) {
        int minHeight = fossil.getMinY(world);
        int maxHeight = fossil.getMaxY(world);
        int chance = fossil.getChance();
        int fossilSize = fossil.getSize();
        int maxDistance = 0;
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > world.func_72800_K()) {
            throw new IllegalArgumentException("While generating " + fossil.getFossil().func_177230_c().func_149732_F() + " something went wrong.");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int a;
            if (fossil.isWaterRequired()) {
                maxDistance = Main.generateRandomInt(5, 7, rand);
            }
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            boolean canSpawn = true;
            if (!canSpawn) continue;
            if (fossil.canSpawnOnAllBiomes()) {
                if (fossil.isWaterRequired()) {
                    if (!this.isWaterNear(new BlockPos(x, y, z), world, maxDistance)) continue;
                    for (a = 0; a < fossil.getFossilGens().size(); ++a) {
                        fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    }
                    continue;
                }
                while (a < fossil.getFossilGens().size()) {
                    fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    ++a;
                }
                continue;
            }
            for (int b = 0; b < fossil.getAllowedBiomes().size(); ++b) {
                if (!fossil.getAllowedBiomes().contains(world.func_180494_b(new BlockPos(x, y, z)))) continue;
                if (fossil.isWaterRequired()) {
                    if (!this.isWaterNear(new BlockPos(x, y, z), world, maxDistance)) continue;
                    while (a < fossil.getFossilGens().size()) {
                        fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                        ++a;
                    }
                    continue;
                }
                while (a < fossil.getFossilGens().size()) {
                    fossil.getFossilGens().get(a).func_180709_b(world, rand, new BlockPos(x, y, z));
                    ++a;
                }
            }
        }
    }

    public boolean isWaterNear(BlockPos pos, World world, int maxDistance) {
        boolean near = false;
        for (int x = 1; !near && x < maxDistance; ++x) {
            near = this.checkWater(pos.func_177965_g(x), world);
            if (near || (near = this.checkWater(pos.func_177985_f(x), world)) || (near = this.checkWater(pos.func_177965_g(x), world)) || (near = this.checkWater(pos.func_177964_d(x), world))) continue;
            near = this.checkWater(pos.func_177981_b(x), world);
        }
        return near;
    }

    private boolean checkWater(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j) || world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150358_i);
    }
}

