/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.LeavesBase;
import com.matez.wildnature.blocks.LogBase;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.schematics.leaves.mahogany.leafGen_mahogany;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class treeGen_mahogany
extends WorldGenAbstractTree {
    IBlockState LEAVES = ModBlocks.MAHOGANY_LEAVES.func_176223_P().func_177226_a((IProperty)LeavesBase.field_176236_b, (Comparable)Boolean.valueOf(false));
    IBlockState LOG = ModBlocks.MAHOGANY_LOG.func_176223_P();
    int height = 6;

    public treeGen_mahogany(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int realHeight = Main.generateRandomInt(this.height - 1, this.height + 3);
        if (worldIn.func_180495_p(position.func_177977_b()).func_177230_c().canSustainPlant(worldIn.func_180495_p(position.func_177977_b()), (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
            this.generateLog(realHeight, worldIn, position, rand);
        }
        return true;
    }

    public boolean generateLog(int realHeight, World world, BlockPos pos, Random rand) {
        BlockPos upper = pos;
        for (int x = 0; x < realHeight; ++x) {
            if (x == Integer.parseInt(String.valueOf(Math.round(realHeight / 2)))) {
                upper = upper.func_177972_a(this.randomFacing(false));
            }
            this.setLog(world, upper);
            upper = upper.func_177984_a();
        }
        this.generateBranch(world, upper, rand);
        return true;
    }

    public boolean generateBranch(World world, BlockPos startPos, Random rand) {
        EnumFacing facing = null;
        block0: while (true) {
            if (facing == null) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.NORTH) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH) {
                facing = EnumFacing.WEST;
            } else {
                if (facing != EnumFacing.WEST) break;
                facing = EnumFacing.EAST;
            }
            int x = 0;
            BlockPos pos = null;
            while (x < Main.generateRandomInt(1, 2)) {
                pos = startPos.func_177967_a(facing, ++x);
                this.setBlock(world, pos, this.LOG.func_177226_a((IProperty)LogBase.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
            }
            pos = pos.func_177967_a(facing, 1);
            x = 0;
            while (true) {
                if (x >= Main.generateRandomInt(2, 3)) continue block0;
                this.setLog(world, pos.func_177981_b(++x));
            }
            break;
        }
        this.generateLeaves(startPos.func_177981_b(2), world, rand);
        return true;
    }

    public boolean generateLeaves(BlockPos center, World world, Random rand) {
        leafGen_mahogany leavesGen = new leafGen_mahogany(true, ModBlocks.MAHOGANY_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)));
        leavesGen.func_180709_b(world, rand, center);
        return true;
    }

    private boolean isSuitableLocation(World parWorld, BlockPos parBlockPos, int minHeight) {
        boolean isSuitableLocation = true;
        if (!parWorld.func_180495_p(parBlockPos.func_177977_b()).func_185913_b()) {
            return false;
        }
        for (int checkY = parBlockPos.func_177956_o(); checkY <= parBlockPos.func_177956_o() + 1 + minHeight; ++checkY) {
            int extraSpaceNeeded = 1;
            if (checkY == parBlockPos.func_177956_o()) {
                extraSpaceNeeded = 0;
            }
            if (checkY >= parBlockPos.func_177956_o() + 1 + minHeight - 2) {
                extraSpaceNeeded = 2;
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int checkX = parBlockPos.func_177958_n() - extraSpaceNeeded; checkX <= parBlockPos.func_177958_n() + extraSpaceNeeded && isSuitableLocation; ++checkX) {
                for (int checkZ = parBlockPos.func_177952_p() - extraSpaceNeeded; checkZ <= parBlockPos.func_177952_p() + extraSpaceNeeded && isSuitableLocation; ++checkZ) {
                    isSuitableLocation = this.isReplaceable(parWorld, (BlockPos)blockPos.func_181079_c(checkX, checkY, checkZ));
                }
            }
        }
        return isSuitableLocation;
    }

    public EnumFacing randomFacing(boolean upDown) {
        if (upDown) {
            switch (Main.generateRandomInt(1, 6)) {
                case 1: {
                    return EnumFacing.NORTH;
                }
                case 2: {
                    return EnumFacing.SOUTH;
                }
                case 3: {
                    return EnumFacing.WEST;
                }
                case 4: {
                    return EnumFacing.EAST;
                }
                case 5: {
                    return EnumFacing.UP;
                }
                case 6: {
                    return EnumFacing.DOWN;
                }
            }
        } else {
            switch (Main.generateRandomInt(1, 4)) {
                case 1: {
                    return EnumFacing.NORTH;
                }
                case 2: {
                    return EnumFacing.SOUTH;
                }
                case 3: {
                    return EnumFacing.WEST;
                }
                case 4: {
                    return EnumFacing.EAST;
                }
            }
        }
        return null;
    }

    public void setLeaves(World world, BlockPos pos) {
        world.func_180501_a(pos, this.LEAVES, 2);
    }

    public void setLeaves(World world, BlockPos pos, int chance) {
        if (Main.generateRandomInt(0, 100) <= chance) {
            world.func_180501_a(pos, this.LEAVES, 2);
        }
    }

    public void setLog(World world, BlockPos pos) {
        world.func_180501_a(pos, this.LOG, 2);
    }

    public void setLog(World world, BlockPos pos, int chance) {
        if (Main.generateRandomInt(0, 100) <= chance) {
            world.func_180501_a(pos, this.LOG, 2);
        }
    }

    public void setBlock(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 2);
    }

    public void setBlock(World world, BlockPos pos, IBlockState state, int chance) {
        if (Main.generateRandomInt(0, 100) <= chance) {
            world.func_180501_a(pos, state, 2);
        }
    }
}

