/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.worldgen;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.LeavesBase;
import com.matez.wildnature.init.ModBlocks;
import com.matez.wildnature.worldgen.schematics.leaves.willow.leafGen_willowLeaf;
import com.matez.wildnature.worldgen.schematics.leaves.willow.leafGen_willowLeafBig;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class treeGen_willow
extends WorldGenAbstractTree {
    private static final IBlockState LOG = ModBlocks.WILLOW_LOG.func_176223_P();
    private static final IBlockState LEAVES = ModBlocks.WILLOW_LEAVES.func_176223_P().func_177226_a((IProperty)LeavesBase.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LeavesBase.field_176237_a, (Comparable)Boolean.valueOf(false));
    private int waterSize = 0;

    public treeGen_willow(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (this.canBlockStay(worldIn, position, Blocks.field_150345_g.func_176223_P())) {
            int leafGen = this.generateTrunk(worldIn, position.func_177979_c(this.waterSize), rand);
            BlockPos leafPos = position.func_177981_b(leafGen).func_177979_c(this.waterSize);
            int leafType = Main.generateRandomInt(1, 2, rand);
            if (leafType == 1) {
                leafGen_willowLeaf leaves = new leafGen_willowLeaf(true, LEAVES);
                leaves.func_180709_b(worldIn, rand, leafPos);
            } else {
                leafGen_willowLeafBig leaves = new leafGen_willowLeafBig(true, LEAVES);
                leaves.func_180709_b(worldIn, rand, leafPos);
            }
        } else {
            return false;
        }
        return true;
    }

    public int generateTrunk(World world, BlockPos pos, Random rand) {
        int x;
        int height = Main.generateRandomInt(7, 14, rand);
        for (x = 0; x < height; ++x) {
            this.func_175903_a(world, pos.func_177981_b(x), LOG);
        }
        int chance = Main.generateRandomInt(1, 100);
        for (x = 0; x < 3 && chance > 40; ++x) {
            this.func_175903_a(world, new BlockPos(pos.func_177981_b(x).func_177958_n() + 1, pos.func_177981_b(x).func_177956_o(), pos.func_177981_b(x).func_177952_p()), LOG);
            this.func_175903_a(world, new BlockPos(pos.func_177981_b(x).func_177958_n() - 1, pos.func_177981_b(x).func_177956_o(), pos.func_177981_b(x).func_177952_p()), LOG);
            this.func_175903_a(world, new BlockPos(pos.func_177981_b(x).func_177958_n(), pos.func_177981_b(x).func_177956_o(), pos.func_177981_b(x).func_177952_p() + 1), LOG);
            this.func_175903_a(world, new BlockPos(pos.func_177981_b(x).func_177958_n(), pos.func_177981_b(x).func_177956_o(), pos.func_177981_b(x).func_177952_p() - 1), LOG);
        }
        return height;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150358_i)) {
            if (worldIn.func_180495_p(pos.func_177977_b().func_177977_b()).func_177230_c().equals(Blocks.field_150355_j) || worldIn.func_180495_p(pos.func_177977_b().func_177977_b()).func_177230_c().equals(Blocks.field_150358_i)) {
                if (worldIn.func_180495_p(pos.func_177977_b().func_177977_b().func_177977_b()).func_185913_b()) {
                    this.waterSize = 2;
                    return true;
                }
            } else if (worldIn.func_180495_p(pos.func_177977_b().func_177977_b()).func_185913_b()) {
                this.waterSize = 1;
                return true;
            }
        }
        if (state.func_185913_b()) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_185913_b();
        }
        try {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)state.func_177230_c());
        }
        catch (Exception e) {
            return false;
        }
    }
}

