/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature;

import com.matez.wildnature.blocks.colors.WNBlockColors;
import com.matez.wildnature.blocks.colors.WNItemColors;
import com.matez.wildnature.blocks.config.ConfigSettings;
import com.matez.wildnature.commands.BiomeArgument;
import com.matez.wildnature.commands.WNCommand;
import com.matez.wildnature.compatibility.WNMinecraftCopatibility;
import com.matez.wildnature.compatibility.WNMobSpawnFix;
import com.matez.wildnature.compatibility.WNMobSpawning;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.customizable.WNConfig;
import com.matez.wildnature.entity.EntityRegistry;
import com.matez.wildnature.entity.render.RenderRegistry;
import com.matez.wildnature.event.FogEvent;
import com.matez.wildnature.event.GuiEvent;
import com.matez.wildnature.event.KeyEvent;
import com.matez.wildnature.event.ParticleFactoryEvent;
import com.matez.wildnature.event.PlayerEventHandler;
import com.matez.wildnature.event.RenderCapeHandler;
import com.matez.wildnature.gui.container.PouchContainer;
import com.matez.wildnature.gui.initGuis;
import com.matez.wildnature.gui.tileEntities.CustomPistonTileEntity;
import com.matez.wildnature.gui.tileEntities.DungeonCommanderTileEntity;
import com.matez.wildnature.gui.tileEntities.GravityShroomTileEntity;
import com.matez.wildnature.gui.tileEntities.HydrothermalVentTileEntity;
import com.matez.wildnature.itemGroup.wnItemGroup;
import com.matez.wildnature.itemGroup.wnItemGroupBuilding;
import com.matez.wildnature.itemGroup.wnItemGroupDeco;
import com.matez.wildnature.itemGroup.wnItemGroupUnderground;
import com.matez.wildnature.items.AlcoItem;
import com.matez.wildnature.items.BelladonnaItem;
import com.matez.wildnature.items.CookingItem;
import com.matez.wildnature.items.DeepBowlSoupItem;
import com.matez.wildnature.items.DrinkItem;
import com.matez.wildnature.items.FoodItem;
import com.matez.wildnature.items.GeyserEssenceItem;
import com.matez.wildnature.items.GiftItem;
import com.matez.wildnature.items.JarItem;
import com.matez.wildnature.items.JugItem;
import com.matez.wildnature.items.KnifeItem;
import com.matez.wildnature.items.LavalilyItem;
import com.matez.wildnature.items.MapleSoupItem;
import com.matez.wildnature.items.PotEmptyItem;
import com.matez.wildnature.items.PouchItem;
import com.matez.wildnature.items.WaterJugItem;
import com.matez.wildnature.items.WaterlilyItem;
import com.matez.wildnature.items.WrappingPaperItem;
import com.matez.wildnature.items.recipes.DyeableRecipe;
import com.matez.wildnature.items.recipes.GiftCrafting;
import com.matez.wildnature.items.recipes.KnifeCrafting;
import com.matez.wildnature.items.recipes.PotCrafting;
import com.matez.wildnature.items.recipes.cooking.CookingToolType;
import com.matez.wildnature.items.recipes.cooking.CraftingTweaker;
import com.matez.wildnature.items.recipes.cooking.FillTool;
import com.matez.wildnature.items.recipes.cooking.WNCookingRecipe;
import com.matez.wildnature.items.recipes.cooking.WNCookingRecipeSerializer;
import com.matez.wildnature.items.recipes.cooking.WNCookingSmelting;
import com.matez.wildnature.items.tier.WNItemTier;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.lists.WNItems;
import com.matez.wildnature.packets.WNSSpawnParticlePacket;
import com.matez.wildnature.particles.CrystalSparkParticle;
import com.matez.wildnature.particles.DungeonHeartParticle;
import com.matez.wildnature.particles.DustParticle;
import com.matez.wildnature.particles.FuzzballExplosionParticle;
import com.matez.wildnature.particles.GeyserParticle;
import com.matez.wildnature.particles.PollenParticle;
import com.matez.wildnature.particles.SlimeshroomParticle;
import com.matez.wildnature.particles.SteamParticle;
import com.matez.wildnature.particles.ThermalParticle;
import com.matez.wildnature.proxy.ClientProxy;
import com.matez.wildnature.proxy.IProxy;
import com.matez.wildnature.proxy.ServerProxy;
import com.matez.wildnature.registry.BuildingAddonsRegistry;
import com.matez.wildnature.registry.BuildingRegistry;
import com.matez.wildnature.registry.EngravedRegistry;
import com.matez.wildnature.registry.FlowerRegistry;
import com.matez.wildnature.registry.GemRegistry;
import com.matez.wildnature.registry.GrassRegistry;
import com.matez.wildnature.registry.OreRegistry;
import com.matez.wildnature.registry.OtherRegistry;
import com.matez.wildnature.registry.ParticleRegistry;
import com.matez.wildnature.registry.RockRegistry;
import com.matez.wildnature.registry.SaplingRegistry;
import com.matez.wildnature.registry.SignRegistry;
import com.matez.wildnature.registry.WoodRegistry;
import com.matez.wildnature.sounds.SoundRegistry;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomes;
import com.matez.wildnature.world.gen.chunk.WNChunkGeneratorType;
import com.matez.wildnature.world.gen.feature.RockGen;
import com.matez.wildnature.world.gen.provider.WNBiomeProviderType;
import com.matez.wildnature.world.gen.provider.WNWorldType;
import com.matez.wildnature.world.gen.structures.nature.SchemFeature;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SignItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="wildnature")
public class Main {
    public static Main instance;
    public static final String modid = "wildnature";
    public static final String version = "2.1.7";
    public static final Logger LOGGER;
    public static final wnItemGroup WILDNATURE_GROUP;
    public static final wnItemGroupUnderground WILDNATURE_UNDERGROUND_GROUP;
    public static final wnItemGroupDeco WILDNATURE_DECO_GROUP;
    public static final wnItemGroupBuilding WILDNATURE_BUILDING_GROUP;
    public static final String WildNaturePrefix;
    public static WorldType WNWorldType;
    private static WNChunkGeneratorType chunkGeneratorType;
    private static WNBiomeProviderType biomeProviderType;
    public static ArrayList<SchemFeature> treesList;
    public static IProxy proxy;
    public static boolean gotInfoAboutWorld;
    public static boolean loadedNewVersion;
    public ArrayList<String> supportedLanguages = new ArrayList();
    public static boolean usesFancyGraphics;
    public static StringTextComponent WNPrefix;
    public static boolean canShowAdvancedTooltip;
    public static World runningWorld;

    public Main() {
        LOGGER.info("Initializing WildNature mod");
        instance = this;
        this.addSupportedLanguages();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onServerStarting);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerParticles);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetup);
        File f = new File(FMLPaths.GAMEDIR.get().resolve("wildnature/").toString());
        if (!f.exists()) {
            new File(FMLPaths.GAMEDIR.get().resolve("wildnature/").toString()).mkdirs();
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        WNConfig.register(ModLoadingContext.get());
        ConfigSettings.applyCfgs();
        MinecraftForge.EVENT_BUS.register((Object)this);
        WNPrefix.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "WildNature " + TextFormatting.LIGHT_PURPLE + version)));
        WNPrefix.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://wildnaturemod.com"));
        ProtocolType.PLAY.func_179245_a(PacketDirection.CLIENTBOUND, WNSSpawnParticlePacket.class);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setup...");
        RockGen.setupRocks();
        MinecraftForge.EVENT_BUS.addListener(new ParticleFactoryEvent()::registerParticles);
        ArgumentTypes.func_218136_a((String)"biome_argument", BiomeArgument.class, (IArgumentSerializer)new ArgumentSerializer(BiomeArgument::createArgument));
        LOGGER.info("Using Version " + CommonConfig.currentVersion + " / " + version);
        if (!((String)CommonConfig.currentVersion.get()).equals(version)) {
            loadedNewVersion = true;
            LOGGER.info("Using new version! Current: 2.1.7");
            CommonConfig.currentVersion.set((Object)version);
        }
        CommonConfig.compile();
        WNBiomes.registerAll();
        WNMinecraftCopatibility.init();
        LOGGER.info("Re-registering entity spawns. Found " + EntitySpawnPlacementRegistry.field_209347_a.size());
        WNMobSpawnFix.fixAll();
        WNMobSpawning.registerAll();
        EntityRegistry.registerEntitySpawns();
        WNBiomes.unregisterBlacklisted();
        proxy.init();
        Main.wnInfo("Setup completed");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        LOGGER.info("Client setup...");
        WNBlockColors blockColors = new WNBlockColors();
        WNItemColors itemColors = new WNItemColors();
        MinecraftForge.EVENT_BUS.addListener(new GuiEvent()::guiScreenEvent);
        MinecraftForge.EVENT_BUS.addListener(new KeyEvent()::onKey);
        MinecraftForge.EVENT_BUS.addListener(new FogEvent()::fogEvent);
        MinecraftForge.EVENT_BUS.addListener(new FogEvent()::fogColorEvent);
        MinecraftForge.EVENT_BUS.addListener(new RenderCapeHandler()::onRender);
        RenderRegistry.registryEntityRenders();
        Main.wnInfo("Client setup completed");
    }

    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        proxy.enqueueIMC(event);
    }

    private void addSupportedLanguages() {
        this.supportedLanguages.add("en_us");
        this.supportedLanguages.add("pl_pl");
        this.supportedLanguages.add("ru_ru");
        this.supportedLanguages.add("de_de");
    }

    public ArrayList<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @SubscribeEvent
    public void registerParticles(ParticleFactoryRegisterEvent event) {
        LOGGER.info("Registering particle factories...");
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.DUNGEON_HEART, DungeonHeartParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.CRYSTAL_SPARK, CrystalSparkParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.CRYSTAL, CrystalSparkParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.GEYSER, GeyserParticle.GeyserParticleFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.STEAM, SteamParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.FLOWERING_LEAF_WHITE_DUST, DustParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a(ParticleRegistry.POLLEN, PollenParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.WISTERIA_PINK, DustParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.SLIMESHROOM_GREEN, SlimeshroomParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.SLIMESHROOM_BLUE, SlimeshroomParticle.Factory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.THERMAL_SMOKE, ThermalParticle.ThermalParticleFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ParticleRegistry.FUZZBALL_EXPLOSION, FuzzballExplosionParticle.Factory::new);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent e) {
        LOGGER.debug("Registering commands");
        MinecraftForge.EVENT_BUS.addListener(new PlayerEventHandler()::onPlayerJoin);
        MinecraftForge.EVENT_BUS.addListener(new PlayerEventHandler()::onPlayerExit);
        MinecraftForge.EVENT_BUS.addListener(new CraftingTweaker()::playerCraftedEvent);
        WNCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        Main.wnInfo("Successfully initialized server-side");
    }

    @SubscribeEvent
    public void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        ServerProperties serverProperties = ((DedicatedServer)event.getServerSupplier().get()).func_213221_d_();
        if (((Boolean)CommonConfig.useWNOnServer.get()).booleanValue()) {
            LOGGER.info(String.format("Using WildNature on server. Original value: %s", serverProperties.field_219023_q.func_211888_a()));
            serverProperties.field_73672_b.setProperty("level-type", modid);
            serverProperties.field_219023_q = WNWorldType;
        } else {
            LOGGER.info("WN Server Gen disabled");
        }
    }

    public static Block getBlockByID(String resLoc) {
        return (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(resLoc));
    }

    public static Item getItemByID(String resLoc) {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(resLoc));
    }

    public static Biome getBiomeByID(String resLoc) {
        return (Biome)Registry.field_212624_m.func_82594_a(new ResourceLocation(resLoc));
    }

    public static ParticleType getParticleByID(String resLoc) {
        return (ParticleType)Registry.field_212632_u.func_82594_a(new ResourceLocation(resLoc));
    }

    public static SoundEvent getSoundByID(String resLoc) {
        return (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation(resLoc));
    }

    public static String yesNoReturner(boolean bool) {
        return bool ? "y" : "n";
    }

    public static void sendServerChatMessage(MinecraftServer server, PlayerEntity playerEntity, String message) {
        if (Main.hasEffect((LivingEntity)playerEntity, Effects.field_76441_p)) {
            LOGGER.debug("---> Player is invisible, message won't be send");
            return;
        }
        if (server != null) {
            server.func_145747_a((ITextComponent)new StringTextComponent(message));
            for (PlayerEntity p : server.func_184103_al().func_181057_v()) {
                if (p == playerEntity) continue;
                Main.sendChatMessage(p, message);
            }
        } else {
            LOGGER.debug("---> Cannot send message. Server == null");
        }
    }

    public static void sendServerChatMessage(MinecraftServer server, PlayerEntity playerEntity, ITextComponent message) {
        LOGGER.debug("Sending Message to server");
        if (Main.hasEffect((LivingEntity)playerEntity, Effects.field_76441_p)) {
            LOGGER.debug("---> Player is invisible, message won't be send");
            return;
        }
        if (server != null) {
            server.func_145747_a(message);
            for (PlayerEntity p : server.func_184103_al().func_181057_v()) {
                if (p == playerEntity) continue;
                Main.sendChatMessage(p, message);
            }
        } else {
            LOGGER.debug("---> Cannot send message. Server == null");
        }
    }

    public static void sendChatMessage(PlayerEntity entity, String message) {
        entity.func_145747_a((ITextComponent)new StringTextComponent(message));
    }

    public static void sendChatMessage(PlayerEntity entity, ITextComponent message) {
        entity.func_145747_a(message);
    }

    public static boolean hasEffect(LivingEntity entity, Effect effect) {
        ArrayList<Object> effects = new ArrayList<Object>(Arrays.asList(entity.func_70651_bq().toArray()));
        for (Object e : effects) {
            if (!(e instanceof EffectInstance) || ((EffectInstance)e).func_188419_a() != effect) continue;
            return true;
        }
        return false;
    }

    public static String readFromURL(String sURL) {
        if (!Main.netIsAvailable()) {
            LOGGER.warn("Internet connection unavailable");
            return null;
        }
        try {
            URL url = new URL(sURL);
            URLConnection con = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = in.readLine();
            StringBuilder builder = new StringBuilder();
            do {
                builder.append(line + "\n");
            } while ((line = in.readLine()) != null);
            in.close();
            return builder.toString();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot connect! Is the server unreachable?");
            return null;
        }
    }

    private static boolean netIsAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean is404(String url) {
        LOGGER.debug("Testing " + url + " for 404 exception...");
        if (Main.netIsAvailable()) {
            try {
                URL u = new URL(url);
                HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                huc.setRequestMethod("GET");
                huc.connect();
                int code = huc.getResponseCode();
                LOGGER.debug("Response code: " + code);
                return code == 404;
            }
            catch (Exception e) {
                LOGGER.warn("Exception during 404 test: " + e.getLocalizedMessage());
            }
        } else {
            LOGGER.debug("Internet not available");
        }
        return true;
    }

    public static void wnInfo(String data) {
        LOGGER.info(TextFormatting.AQUA + "---------------------------------");
        LOGGER.info(TextFormatting.GREEN + " WildNature " + version + " // " + ForgeVersion.getVersion());
        LOGGER.info(TextFormatting.GREEN + " https://wildnaturemod.com");
        LOGGER.info(TextFormatting.DARK_AQUA + "---");
        LOGGER.info(TextFormatting.YELLOW + data);
        LOGGER.info(TextFormatting.DARK_AQUA + "---");
        LOGGER.info(TextFormatting.AQUA + "---------------------------------");
    }

    public static void fixResources() {
        ArrayList enabledPacks;
        ArrayList orderedPacks = enabledPacks = new ArrayList(Minecraft.func_71410_x().func_195548_H().func_198980_d());
        int vanillaIndex = 0;
        int modResIndex = 0;
        for (int i = 0; i < enabledPacks.size(); ++i) {
            if (((ClientResourcePackInfo)enabledPacks.get(i)).func_195790_f().equals("vanilla")) {
                vanillaIndex = i;
                orderedPacks.set(0, enabledPacks.get(i));
                continue;
            }
            if (((ClientResourcePackInfo)enabledPacks.get(i)).func_195790_f().equals("mod_resources")) {
                modResIndex = i;
                orderedPacks.set(1, enabledPacks.get(i));
                continue;
            }
            orderedPacks.set(i, enabledPacks.get(i));
        }
        Minecraft.func_71410_x().func_195548_H().func_198985_a(orderedPacks);
    }

    static {
        LOGGER = LogManager.getLogger((String)modid);
        WILDNATURE_GROUP = new wnItemGroup();
        WILDNATURE_UNDERGROUND_GROUP = new wnItemGroupUnderground();
        WILDNATURE_DECO_GROUP = new wnItemGroupDeco();
        WILDNATURE_BUILDING_GROUP = new wnItemGroupBuilding();
        WildNaturePrefix = TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + "[" + TextFormatting.GREEN.toString() + TextFormatting.BOLD.toString() + "WN" + TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + "] " + TextFormatting.AQUA.toString();
        WNWorldType = new WNWorldType(modid).func_205392_a(true);
        chunkGeneratorType = new WNChunkGeneratorType();
        biomeProviderType = new WNBiomeProviderType();
        treesList = new ArrayList();
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
        gotInfoAboutWorld = true;
        loadedNewVersion = false;
        usesFancyGraphics = true;
        WNPrefix = new StringTextComponent(WildNaturePrefix);
        canShowAdvancedTooltip = false;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static RegistryEvent.Register<Item> itemEvent;
        public static RegistryEvent.Register<Block> blockEvent;
        public static RegistryEvent.Register<Biome> biomeEvent;
        public static RockRegistry rockRegistry;
        private static final List<ContainerType<?>> CONTAINER_TYPES;

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            LOGGER.info("Registering items...");
            itemEvent = event;
            for (int ib = 0; ib < WNBlocks.ITEMBLOCKS.size(); ++ib) {
                event.getRegistry().register((IForgeRegistryEntry)WNBlocks.ITEMBLOCKS.get(ib));
            }
            Food smallFruit = new Food.Builder().func_221456_a(2).func_221454_a(0.6f).func_221457_c().func_221453_d();
            Food CHERRY = new Food.Builder().func_221456_a(2).func_221454_a(0.6f).func_221453_d();
            Food PLUM = new Food.Builder().func_221456_a(2).func_221454_a(0.6f).func_221453_d();
            Food CORN = new Food.Builder().func_221456_a(2).func_221454_a(0.3f).func_221453_d();
            Food TOMATO = new Food.Builder().func_221456_a(2).func_221454_a(0.5f).func_221453_d();
            Food TOMATO_SOUP = new Food.Builder().func_221456_a(16).func_221454_a(1.0f).func_221453_d();
            Food CANDY_CANE = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
            Food CANDY = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221453_d();
            Food DONUTS = new Food.Builder().func_221456_a(2).func_221454_a(0.3f).func_221453_d();
            Food CHOCOLATE = new Food.Builder().func_221456_a(5).func_221454_a(0.3f).func_221453_d();
            Food CARAMEL = new Food.Builder().func_221456_a(1).func_221454_a(0.2f).func_221453_d();
            Food DRINK = new Food.Builder().func_221456_a(0).func_221454_a(0.7f).func_221453_d();
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{WNItems.ROSACEAE_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.ROSACEAE_SIGN, WNBlocks.ROSACEAE_WALL_SIGN).setRegistryName(RegistryEvents.location("rosaceae_sign")), WNItems.BAOBAB_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.BAOBAB_SIGN, WNBlocks.BAOBAB_WALL_SIGN).setRegistryName(RegistryEvents.location("baobab_sign")), WNItems.BEECH_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.BEECH_SIGN, WNBlocks.BEECH_WALL_SIGN).setRegistryName(RegistryEvents.location("beech_sign")), WNItems.CEDAR_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.CEDAR_SIGN, WNBlocks.CEDAR_WALL_SIGN).setRegistryName(RegistryEvents.location("cedar_sign")), WNItems.CHERRY_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.CHERRY_SIGN, WNBlocks.CHERRY_WALL_SIGN).setRegistryName(RegistryEvents.location("cherry_sign")), WNItems.EBONY_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.EBONY_SIGN, WNBlocks.EBONY_WALL_SIGN).setRegistryName(RegistryEvents.location("ebony_sign")), WNItems.JACARANDA_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.JACARANDA_SIGN, WNBlocks.JACARANDA_WALL_SIGN).setRegistryName(RegistryEvents.location("jacaranda_sign")), WNItems.LARCH_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.LARCH_SIGN, WNBlocks.LARCH_WALL_SIGN).setRegistryName(RegistryEvents.location("larch_sign")), WNItems.MAHOGANY_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.MAHOGANY_SIGN, WNBlocks.MAHOGANY_WALL_SIGN).setRegistryName(RegistryEvents.location("mahogany_sign")), WNItems.MANGROVE_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.MANGROVE_SIGN, WNBlocks.MANGROVE_WALL_SIGN).setRegistryName(RegistryEvents.location("mangrove_sign")), WNItems.MAPLE_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.MAPLE_SIGN, WNBlocks.MAPLE_WALL_SIGN).setRegistryName(RegistryEvents.location("maple_sign")), WNItems.PALM_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.PALM_SIGN, WNBlocks.PALM_WALL_SIGN).setRegistryName(RegistryEvents.location("palm_sign")), WNItems.PLUM_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.PLUM_SIGN, WNBlocks.PLUM_WALL_SIGN).setRegistryName(RegistryEvents.location("plum_sign")), WNItems.REDWOOD_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.REDWOOD_SIGN, WNBlocks.REDWOOD_WALL_SIGN).setRegistryName(RegistryEvents.location("redwood_sign")), WNItems.WILLOW_SIGN = (Item)new SignItem(new Item.Properties().func_200917_a(16), WNBlocks.WILLOW_SIGN, WNBlocks.WILLOW_WALL_SIGN).setRegistryName(RegistryEvents.location("willow_sign"))});
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{WNItems.GREEN_APPLE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("green_apple")), WNItems.PARADISE_APPLE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("paradise_apple")), WNItems.CHERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CHERRY)).setRegistryName(RegistryEvents.location("cherry")), WNItems.PEAR = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("pear")), WNItems.RASPBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("raspberry")), WNItems.BLUEBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("blueberry")), WNItems.LINGONBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("lingonberry")), WNItems.BLACKBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("blackberry")), WNItems.GOOSEBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("gooseberry")), WNItems.CHOKE_BERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("chokeberry")), WNItems.BLACK_CURRANT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("black_currant")), WNItems.RED_CURRANT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("red_currant")), WNItems.WHITE_CURRANT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("white_currant")), WNItems.HAWTHORN_BERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("hawthorn_berry")), WNItems.KAMCHATKA_BERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("kamchatka_berry")), WNItems.WILD_STRAWBERRY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("wild_strawberry")), WNItems.QUINCE_FRUIT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("quince_fruit")), WNItems.BILBERRIES = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("bilberries")), WNItems.BLACK_LILAC_BERRIES = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("black_lilac_berries")), WNItems.CRANBERRIES = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(smallFruit)).setRegistryName(RegistryEvents.location("cranberries")), WNItems.PLUM = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("plum")), WNItems.MIRABELLE_PLUM = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("mirabelle_plum")), WNItems.ACORN = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("acorn")), WNItems.GREEN_WATERLILY = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:green_waterlily"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("green_waterlily")), WNItems.RED_WATERLILY = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:red_waterlily"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("red_waterlily")), WNItems.DUCKWEED = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:duckweed"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("duckweed")), WNItems.WATER_POPPY = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:water_poppy"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("water_poppy")), WNItems.WATER_LILY_WHITE = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:water_lily_white"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("water_lily_white")), WNItems.WATER_LILY_YELLOW = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:water_lily_yellow"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("water_lily_yellow")), WNItems.LOTUS_PINK = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:lotus_pink"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("lotus_pink")), WNItems.LOTUS_LIGHT_PINK = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:lotus_light_pink"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("lotus_light_pink")), WNItems.LOTUS_WHITE = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:lotus_white"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("lotus_white")), WNItems.WATER_HYACINTH = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:water_hyacinth"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("water_hyacinth")), WNItems.POND_WEED = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:pond_weed"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("pond_weed")), WNItems.PARROTS_FEATHER_PLANT = (Item)new WaterlilyItem(Main.getBlockByID("wildnature:parrots_feather_plant"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("parrots_feather_plant")), WNItems.MAGMA_PAD = (Item)new LavalilyItem(Main.getBlockByID("wildnature:magma_pad"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_UNDERGROUND_GROUP)).setRegistryName(RegistryEvents.location("magma_pad")), WNItems.GRAPES_PURPLE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("grapes_purple")), WNItems.GRAPES_YELLOW = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("grapes_yellow")), WNItems.WILD_ROSE_FRUIT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("wild_rose_fruit")), WNItems.BELLADONNA_FRUIT = (Item)new BelladonnaItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221425_a)).setRegistryName(RegistryEvents.location("belladonna_fruit")), WNItems.LEMON = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("lemon")), WNItems.ORANGE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("orange")), WNItems.GRAPEFRUIT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("grapefruit")), WNItems.BANANA = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("banana")), WNItems.LIME = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("lime")), WNItems.OLIVES = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("olives")), WNItems.PEACH = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("peach")), WNItems.PINEAPPLE = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:pineapple_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("pineapple")), WNItems.POMEGRANATE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("pomegranate")), WNItems.MANGO = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(PLUM)).setRegistryName(RegistryEvents.location("mango")), WNItems.LEMON_WEDGE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("lemon_wedge")), WNItems.BROCCOLI = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:broccoli_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("broccoli")), WNItems.CABBAGE = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:cabbage_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("cabbage")), WNItems.CAULIFLOWER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:cauliflower_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("cauliflower")), WNItems.CELERY = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:celery_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("celery")), WNItems.CHIVES = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:chives_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("chives")), WNItems.CORN = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:corn_bush"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CORN)).setRegistryName(RegistryEvents.location("corn")), WNItems.CUCUMBER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:cucumber_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("cucumber")), WNItems.EGGPLANT = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:eggplant_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("eggplant")), WNItems.GARLIC = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:garlic_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("garlic")), WNItems.GINGER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:ginger_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("ginger")), WNItems.GREEN_BEANS = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:green_bean_bush"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("green_beans")), WNItems.GREEN_PEPPER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:green_pepper_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("green_pepper")), WNItems.HORSE_RADISH = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:horse_radish_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("horse_radish")), WNItems.LEEK = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:leek_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("leek")), WNItems.LETTUCE = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:lettuce_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("lettuce")), WNItems.ONION = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:onion_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("onion")), WNItems.PEANUT = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:peanut_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("peanut")), WNItems.PEAS = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:pea_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("peas")), WNItems.RED_ONION = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:red_onion_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("red_onion")), WNItems.RED_PEPPER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:red_pepper_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("red_pepper")), WNItems.RHUBARB = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:rhubarb_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("rhubarb")), WNItems.RICE = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:rice_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("rice")), WNItems.TOMATO = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("tomato")), WNItems.TOMATO_SEEDS = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:tomato_plant"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("tomato_seeds")), WNItems.TURNIP = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:turnip_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(TOMATO)).setRegistryName(RegistryEvents.location("turnip")), WNItems.COTTON = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:cotton_plant"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("cotton")), WNItems.BASIL = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:basil_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("basil")), WNItems.CHOPPED_CHIVES = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("chopped_chives")), WNItems.CURRY_LEAVES = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:curry_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("curry_leaves")), WNItems.DRIED_MARJORAM = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("dried_marjoram")), WNItems.DRIED_PARSLEY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("dried_parsley")), WNItems.DRIED_SAGE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("dried_sage")), WNItems.FRESH_MARJORAM = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:marjoram_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("fresh_marjoram")), WNItems.FRESH_ROSEMARY = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:rosemary_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("fresh_rosemary")), WNItems.GARLIC_CLOVES = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("garlic_cloves")), WNItems.TURMERIC = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:tumeric_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("turmeric")), WNItems.SALT = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("salt")), WNItems.PEPPER = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:black_pepper_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("pepper")), WNItems.BUTTER = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("butter")), WNItems.DOUGH_BALL = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("dough_ball")), WNItems.BLACK_TEA_LEAVES = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:black_tea_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("black_tea_leaves")), WNItems.GREEN_TEA_LEAVES = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:green_tea_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("green_tea_leaves")), WNItems.MELISSA_TEA_LEAF = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:melissa_tea_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("melissa_tea_leaf")), WNItems.MINT = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:mint_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("mint")), WNItems.WHITE_TEA_LEAVES = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:white_tea_plant"), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("white_tea_leaves")), WNItems.MUSHROOM_MIX = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("mushroom_mix")), WNItems.DRIED_MUSHROOM_MIX = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("dried_mushroom_mix")), WNItems.COFFEE_LEAVES = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("coffee_leaves")), WNItems.COFFEE_BRANCH = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("coffee_branch")), WNItems.COFFEE_BERRY_GREEN = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("coffee_berry_green")), WNItems.COFFEE_BERRY = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("coffee_berry")), WNItems.COFFEE_BEAN = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("coffee_bean")), WNItems.COFFEE_POWDER = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(RegistryEvents.location("coffee_powder")), WNItems.CUP = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("cup")), WNItems.CUP_OF_COFFEE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:cup").setRegistryName(RegistryEvents.location("cup_of_coffee")), WNItems.JUG = (Item)new JugItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("jug")), WNItems.JUG_WATER = (Item)new WaterJugItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1)).setRegistryName(RegistryEvents.location("jug_water")), WNItems.GLASS = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY_CANE)).setRegistryName(RegistryEvents.location("glass")), WNItems.CACAO = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:glass", true).setRegistryName(RegistryEvents.location("cacao")), WNItems.JAR = (Item)new JarItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("jar")), WNItems.JAR_WATER = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h), "wildnature:jar", true).setRegistryName(RegistryEvents.location("jar_water")), WNItems.CARAMEL_JAR = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar", true).setRegistryName(RegistryEvents.location("caramel_jar")), WNItems.GLASS_CUP = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("glass_cup")), WNItems.WINE_BOTTLE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("wine_bottle")), WNItems.WOODEN_MUG = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("wooden_mug")), WNItems.PLATE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("plate")), WNItems.MAPLE_BOWL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("maple_bowl")), WNItems.DEEP_BOWL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("deep_bowl")), WNItems.WOODEN_HAMMER = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName(RegistryEvents.location("wooden_hammer")), WNItems.STONE_HAMMER = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName(RegistryEvents.location("stone_hammer")), WNItems.IRON_HAMMER = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i)).setRegistryName(RegistryEvents.location("iron_hammer")), WNItems.CHEF_KNIFE = (Item)new KnifeItem(WNItemTier.KITCHEN_TOOLS, 1, 5.0f, new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1)).setRegistryName(RegistryEvents.location("chef_knife")), WNItems.FRYING_PAN = (Item)new CookingItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1), CookingToolType.FRYING_PAN).setRegistryName(RegistryEvents.location("frying_pan")), WNItems.POT_EMPTY = (Item)new PotEmptyItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1)).setRegistryName(RegistryEvents.location("pot_empty")), WNItems.POT_WATER = (Item)new CookingItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1), CookingToolType.POT).setRegistryName(RegistryEvents.location("pot_water")), WNItems.CAKE_PAN = (Item)new CookingItem(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1), CookingToolType.CAKE_PAN).setRegistryName(RegistryEvents.location("cake_pan")), WNItems.CABBAGE_LETTUCE_SALAD = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("cabbage_lettuce_salad")), WNItems.CEASAR_SALAD = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("ceasar_salad")), WNItems.GARDEN_SALAD = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("garden_salad")), WNItems.ONION_SALAD = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("onion_salad")), WNItems.RICE_VEGGIE_CURRY_BOWL = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(22).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("rice_veggie_curry_bowl")), WNItems.VEGETABLE_SALAD = (Item)new DeepBowlSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(22).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("vegetable_salad")), WNItems.BIGOS = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(12).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("bigos")), WNItems.BEEF_STEW = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("beef_stew")), WNItems.BORSCHT = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("borscht")), WNItems.CABBAGE_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(16).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("cabbage_soup")), WNItems.CHICKEN_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("chicken_soup")), WNItems.CREAM_OF_BROCCOLI_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(12).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("cream_of_broccoli_soup")), WNItems.CREAM_OF_MUSHROOM_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("cream_of_mushroom_soup")), WNItems.CUCUMBER_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(15).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("cucumber_soup")), WNItems.CURRY_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(11).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("curry_soup")), WNItems.GARLIC_MUSHROOM_GRAVY = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(13).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("garlic_mushroom_gravy")), WNItems.ONION_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(15).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("onion_soup")), WNItems.PEA_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(15).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("pea_soup")), WNItems.RED_WINE_REDUCTION_SAUCE = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(16).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("red_wine_reduction_sauce")), WNItems.SAUERKRAUT_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("sauerkraut_soup")), WNItems.TOMATO_SOUP = (Item)new MapleSoupItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(15).func_221454_a(1.0f).func_221453_d()).func_200917_a(1)).setRegistryName(RegistryEvents.location("tomato_soup")), WNItems.ASIAGO_CHEESE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(4).func_221454_a(0.9f).func_221453_d())).setRegistryName(RegistryEvents.location("asiago_cheese")), WNItems.CHEDDAR_CHEESE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(3).func_221454_a(0.9f).func_221453_d())).setRegistryName(RegistryEvents.location("cheddar_cheese")), WNItems.SWISS_CHEESE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.9f).func_221453_d())).setRegistryName(RegistryEvents.location("swiss_cheese")), WNItems.BAGEL_POPPY_SEED = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(6).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("bagel_poppy_seed")), WNItems.BANANA_BREAD = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(6).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("banana_bread")), WNItems.SLICED_BREAD = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(1).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("sliced_bread")), WNItems.GARLIC_BREAD = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("garlic_bread")), WNItems.TOAST = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("toast")), WNItems.FRENCH_TOAST = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.4f).func_221453_d())).setRegistryName(RegistryEvents.location("french_toast")), WNItems.RAW_BACON = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(4).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("raw_bacon")), WNItems.COOKED_BACON = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("cooked_bacon")), WNItems.BACON_BITS = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("bacon_bits")), WNItems.FRIED_EGG = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(4).func_221454_a(0.6f).func_221453_d())).setRegistryName(RegistryEvents.location("fried_egg")), WNItems.GRAHAM_CRACKER = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("graham_cracker")), WNItems.GRILLED_CAULIFLOWER = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.3f).func_221453_d())).setRegistryName(RegistryEvents.location("grilled_cauliflower")), WNItems.SAUERKRAUT = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(1.0f).func_221453_d()), FillTool.PLATE).setRegistryName(RegistryEvents.location("sauerkraut")), WNItems.SMORE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(7).func_221454_a(0.2f).func_221453_d())).setRegistryName(RegistryEvents.location("smore")), WNItems.SUSHI = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(6).func_221454_a(1.0f).func_221453_d())).setRegistryName(RegistryEvents.location("sushi")), WNItems.CHEESE_PIZZA = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(22).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("cheese_pizza")), WNItems.HAWAIIAN_PIZZA = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(22).func_221454_a(0.7f).func_221453_d())).setRegistryName(RegistryEvents.location("hawaiian_pizza")), WNItems.PEPPERONI_PIZZA = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(22).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("pepperoni_pizza")), WNItems.CEBULARZ = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(0.7f).func_221453_d())).setRegistryName(RegistryEvents.location("cebularz")), WNItems.TORTILLA = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(4).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("tortilla")), WNItems.BEEF_AND_PEPPER_BURRITO = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("beef_and_pepper_burrito")), WNItems.CHICKEN_AND_CORN_BURRITO = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("chicken_and_corn_burrito")), WNItems.PORK_AND_GREEN_BEAN_BURRITO = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("pork_and_green_bean_burrito")), WNItems.VEGETABLE_AND_CHEESE_BURRITO = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(0.5f).func_221453_d())).setRegistryName(RegistryEvents.location("vegetable_and_cheese_burrito")), WNItems.BEEF_SANDWICH = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(0.6f).func_221453_d())).setRegistryName(RegistryEvents.location("beef_sandwich")), WNItems.BEEF_SANDWICH_WITH_CHEDDAR = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(18).func_221454_a(0.8f).func_221453_d())).setRegistryName(RegistryEvents.location("beef_sandwich_with_cheddar")), WNItems.CHICKEN_SANDWICH = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(0.6f).func_221453_d())).setRegistryName(RegistryEvents.location("chicken_sandwich")), WNItems.PORK_SANDWICH = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(0.6f).func_221453_d())).setRegistryName(RegistryEvents.location("pork_sandwich")), WNItems.BREAKFAST_MEAL = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(12).func_221454_a(0.6f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("breakfast_meal")), WNItems.BROCCOLI_AND_CHEESE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(0.8f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("broccoli_and_cheese")), WNItems.MUTTON_DINNER_WITH_REDWINE_SAUCE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(16).func_221454_a(0.7f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("mutton_dinner_with_redwine_sauce")), WNItems.OMELET_BREAKFAST = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(11).func_221454_a(0.5f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("omelet_breakfast")), WNItems.PANCAKES = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(12).func_221454_a(0.4f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("pancakes")), WNItems.PIEROGIES = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(0.5f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("pierogies")), WNItems.ROAST_CHICKEN_DINNER = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(14).func_221454_a(0.5f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("roast_chicken_dinner")), WNItems.ROASTED_VEGGIES = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(8).func_221454_a(0.6f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("roasted_veggies")), WNItems.SAUTEED_VEGGIES_WITH_GRAVY = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(12).func_221454_a(0.8f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("sauteed_veggies_with_gravy")), WNItems.STEAK_DINNER_WITH_GRAVY = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(15).func_221454_a(0.8f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("steak_dinner_with_gravy")), WNItems.STEAK_DINNER_WITH_REDWINE_SAUCE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(19).func_221454_a(0.9f).func_221453_d()).func_200917_a(1), FillTool.PLATE).setRegistryName(RegistryEvents.location("steak_dinner_with_redwine_sauce")), WNItems.LEMON_MERINGUE_PIE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(0.4f).func_221453_d())).setRegistryName(RegistryEvents.location("lemon_meringue_pie")), WNItems.STRAWBERRY_RHUBARB_PIE = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(0.4f).func_221453_d())).setRegistryName(RegistryEvents.location("strawberry_rhubarb_pie")), WNItems.BREAD_ROLL = (Item)new FoodItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221430_f)).setRegistryName(RegistryEvents.location("bread_roll")), WNItems.CANDY_1 = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY)).setRegistryName(RegistryEvents.location("candy_1")), WNItems.CANDY_2 = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY)).setRegistryName(RegistryEvents.location("candy_2")), WNItems.CANDY_3 = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY)).setRegistryName(RegistryEvents.location("candy_3")), WNItems.CANDY_CANE_1 = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY_CANE)).setRegistryName(RegistryEvents.location("candy_cane_1")), WNItems.CANDY_CANE_2 = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY_CANE)).setRegistryName(RegistryEvents.location("candy_cane_2")), WNItems.CARAMEL_CANDY = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221430_f)).setRegistryName(RegistryEvents.location("caramel_candy")), WNItems.CREAM_CARAMEL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221430_f)).setRegistryName(RegistryEvents.location("cream_caramel")), WNItems.EMPTY_BAG = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(RegistryEvents.location("empty_bag")), WNItems.MARSHMALLOW = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(Foods.field_221430_f)).setRegistryName(RegistryEvents.location("marshmallow")), WNItems.CHOCOLATE_DARK = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CHOCOLATE)).setRegistryName(RegistryEvents.location("chocolate_dark")), WNItems.CHOCOLATE_MILK = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CHOCOLATE)).setRegistryName(RegistryEvents.location("chocolate_milk")), WNItems.CHOCOLATE_WHITE = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CHOCOLATE)).setRegistryName(RegistryEvents.location("chocolate_white")), WNItems.CHOCOLATE_CARAMEL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CHOCOLATE)).setRegistryName(RegistryEvents.location("chocolate_caramel")), WNItems.CARAMEL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(CANDY)).setRegistryName(RegistryEvents.location("caramel")), WNItems.FLOUR = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("flour")), WNItems.POPPY_SEED = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("poppy_seed")), WNItems.RICE_BAG = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("rice_bag")), WNItems.YEAST = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)).setRegistryName(RegistryEvents.location("yeast")), WNItems.GIFT_1 = (Item)new GiftItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.CYAN_RED).setRegistryName(RegistryEvents.location("gift_1")), WNItems.GIFT_2 = (Item)new GiftItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.RED_YELLOW).setRegistryName(RegistryEvents.location("gift_2")), WNItems.GIFT_3 = (Item)new GiftItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.BLUE_PINK).setRegistryName(RegistryEvents.location("gift_3")), WNItems.XMAS_PAPER_1 = (Item)new WrappingPaperItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.CYAN_RED).setRegistryName(RegistryEvents.location("xmas_paper_1")), WNItems.XMAS_PAPER_2 = (Item)new WrappingPaperItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.RED_YELLOW).setRegistryName(RegistryEvents.location("xmas_paper_2")), WNItems.XMAS_PAPER_3 = (Item)new WrappingPaperItem(new Item.Properties().func_200916_a(ItemGroup.field_78031_c), GiftItem.GiftColor.BLUE_PINK).setRegistryName(RegistryEvents.location("xmas_paper_3")), WNItems.XMAS_SOCK = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(RegistryEvents.location("xmas_sock")), WNItems.POUCH = (Item)new PouchItem(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(1)).setRegistryName(RegistryEvents.location("pouch")), WNItems.BEER = (Item)new AlcoItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:wooden_mug").setRegistryName(RegistryEvents.location("beer")), WNItems.RED_WINE = (Item)new AlcoItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:wine_bottle").setRegistryName(RegistryEvents.location("red_wine")), WNItems.WHITE_WINE = (Item)new AlcoItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:wine_bottle").setRegistryName(RegistryEvents.location("white_wine")), WNItems.COMPOT_APPLE_PEAR = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_apple_pear")), WNItems.COMPOT_APPLE_RASPBERRY_CURRANT = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_apple_raspberry_currant")), WNItems.COMPOT_BLACK_CURRANT = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_black_currant")), WNItems.COMPOT_BLACKBERRY_GOOSEBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_blackberry_gooseberry")), WNItems.COMPOT_CHERRY_BLUEBERRY_RASPBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_cherry_blueberry_raspberry")), WNItems.COMPOT_CHOKEBERRY_BLACKBERRY_LINGONBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_chokeberry_blackberry_lingonberry")), WNItems.COMPOT_CRANBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_cranberry")), WNItems.COMPOT_PLUM_APPLE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_plum_apple")), WNItems.COMPOT_WHITE_CURRANT = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:jug").setRegistryName(RegistryEvents.location("compot_white_currant")), WNItems.JUICE_APPLE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_apple")), WNItems.JUICE_GRAPE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_grape")), WNItems.JUICE_GRAPEFRUIT = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_grapefruit")), WNItems.JUICE_LEMON = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_lemon")), WNItems.JUICE_MANGO_PINEAPPLE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_mango_pineapple")), WNItems.JUICE_ORANGE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_orange")), WNItems.JUICE_PEACH = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_peach")), WNItems.JUICE_PINEAPPLE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("juice_pineapple")), WNItems.LEMONADE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass_cup").setRegistryName(RegistryEvents.location("lemonade")), WNItems.TEA_BLACK = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_black")), WNItems.TEA_BLACK_LEMON = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_black_lemon")), WNItems.TEA_GREEN = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_green")), WNItems.TEA_GREEN_CHERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_green_cherry")), WNItems.TEA_GREEN_QUINCE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_green_quince")), WNItems.TEA_MELISSA_PEACH = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_melissa_peach")), WNItems.TEA_MINT = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_mint")), WNItems.TEA_MINT_LEMON = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_mint_lemon")), WNItems.TEA_WHITE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_white")), WNItems.TEA_WHITE_ORANGE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(DRINK).func_200917_a(1), "wildnature:glass").setRegistryName(RegistryEvents.location("tea_white_orange")), WNItems.JAM_BLACKBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_blackberry")), WNItems.JAM_BLUEBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_blueberry")), WNItems.JAM_CHOKE_BERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_choke_berry")), WNItems.JAM_GOOSEBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_gooseberry")), WNItems.JAM_HAWTHORN_BERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_hawthorn_berry")), WNItems.JAM_KAMCHATKA_BERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_kamchatka_berry")), WNItems.JAM_ORANGE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_orange")), WNItems.JAM_PEACH = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_peach")), WNItems.JAM_QUINCE = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_quince")), WNItems.JAM_RASPBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_raspberry")), WNItems.JAM_WILD_STRAWBERRY = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("jam_wild_strawberry")), WNItems.MAPLE_SYRUP = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jug", true).setRegistryName(RegistryEvents.location("maple_syrup")), WNItems.PEANUT_BUTTER = (Item)new DrinkItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1), "wildnature:jar").setRegistryName(RegistryEvents.location("peanut_butter")), WNItems.CHISEL = (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1)).setRegistryName(RegistryEvents.location("chisel"))});
            GemRegistry gems = new GemRegistry();
            event.getRegistry().registerAll((IForgeRegistryEntry[])gems.getItem());
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{WNItems.DUNGEON_TORCH = (Item)new WallOrFloorItem(Main.getBlockByID("wildnature:dungeon_torch"), Main.getBlockByID("wildnature:dungeon_torch_wall"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_DECO_GROUP)).setRegistryName("wildnature:dungeon_torch"), WNItems.CRYSTAL_TORCH = (Item)new WallOrFloorItem(Main.getBlockByID("wildnature:crystal_torch"), Main.getBlockByID("wildnature:crystal_torch_wall"), new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_DECO_GROUP)).setRegistryName("wildnature:crystal_torch"), WNItems.DUNGEON_REDSTONE_TORCH = (Item)new WallOrFloorItem(Main.getBlockByID("wildnature:dungeon_redstone_torch"), Main.getBlockByID("wildnature:dungeon_redstone_torch_wall"), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)).setRegistryName("wildnature:dungeon_redstone_torch"), WNItems.RS_PISTON1 = (Item)new BlockNamedItem(Main.getBlockByID("wildnature:rs_piston1"), new Item.Properties().func_200916_a(ItemGroup.field_78028_d)).setRegistryName(RegistryEvents.location("rs_piston1")), WNItems.GEYSER_ESSENCE = (Item)new GeyserEssenceItem(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP)).setRegistryName(RegistryEvents.location("geyser_essence")), WNItems.JELLY_BALL_BLUE = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(16)).setRegistryName(RegistryEvents.location("jelly_ball_blue")), WNItems.JELLY_BALL_ORANGE = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(16)).setRegistryName(RegistryEvents.location("jelly_ball_orange")), WNItems.JELLY_BALL_PINK = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(16)).setRegistryName(RegistryEvents.location("jelly_ball_pink")), WNItems.JELLY_BALL_RED = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(16)).setRegistryName(RegistryEvents.location("jelly_ball_red")), WNItems.JELLY_BALL_WHITE = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_GROUP).func_200917_a(16)).setRegistryName(RegistryEvents.location("jelly_ball_white")), WNItems.GLOWSHROOM_DUST = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_UNDERGROUND_GROUP)).setRegistryName(RegistryEvents.location("glowshroom_dust")), WNItems.ICESHROOM_DUST = (Item)new Item(new Item.Properties().func_200916_a((ItemGroup)WILDNATURE_UNDERGROUND_GROUP)).setRegistryName(RegistryEvents.location("iceshroom_dust"))});
            EntityRegistry.registerSpawningEggs(event);
        }

        @SubscribeEvent
        public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            LOGGER.info("Registering recipe serializers...");
            event.getRegistry().register(new SpecialRecipeSerializer(GiftCrafting::new).setRegistryName("wildnature:gift_crafting"));
            event.getRegistry().register(new SpecialRecipeSerializer(DyeableRecipe::new).setRegistryName("wildnature:dyeable_recipe"));
            event.getRegistry().register(new SpecialRecipeSerializer(PotCrafting::new).setRegistryName("wildnature:pot_crafting"));
            event.getRegistry().register(new SpecialRecipeSerializer(KnifeCrafting::new).setRegistryName("wildnature:knife_chopping"));
            event.getRegistry().register(new WNCookingRecipeSerializer<WNCookingRecipe>(WNCookingRecipe::new, 200).setRegistryName("wildnature:cooking"));
            event.getRegistry().register(new SpecialRecipeSerializer(WNCookingSmelting::new).setRegistryName("wildnature:furnace_cooking"));
            event.getRegistry().register(new SpecialRecipeSerializer(WNCookingSmelting::new).setRegistryName("wildnature:smoker_cooking"));
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            LOGGER.info("Registering entities...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{EntityRegistry.SEAT, EntityRegistry.GOBLIN, EntityRegistry.DRAKE, EntityRegistry.DUCK, EntityRegistry.DUCKLING, EntityRegistry.BOAR, EntityRegistry.PIRANHA, EntityRegistry.DRAGONFLY, EntityRegistry.SPARROW_MALE, EntityRegistry.BUCK, EntityRegistry.DOE, EntityRegistry.FAWN});
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            LOGGER.info("Registering blocks...");
            blockEvent = event;
            WoodRegistry woodRegistry = new WoodRegistry();
            FlowerRegistry flowerRegistry = new FlowerRegistry();
            SaplingRegistry saplingRegistry = new SaplingRegistry();
            BuildingRegistry rockAddonRegistry = new BuildingRegistry();
            BuildingAddonsRegistry buildingAddonRegistry = new BuildingAddonsRegistry();
            EngravedRegistry engravedRegistry = new EngravedRegistry();
            SignRegistry signRegistry = new SignRegistry();
            GrassRegistry grassRegistry = new GrassRegistry();
            OtherRegistry otherRegistry = new OtherRegistry();
            OreRegistry oreRegistry = new OreRegistry();
            event.getRegistry().registerAll((IForgeRegistryEntry[])woodRegistry.getWoods());
            event.getRegistry().registerAll((IForgeRegistryEntry[])signRegistry.getSign());
            event.getRegistry().registerAll((IForgeRegistryEntry[])saplingRegistry.getSaplings());
            event.getRegistry().registerAll((IForgeRegistryEntry[])rockRegistry.getRocks());
            event.getRegistry().registerAll((IForgeRegistryEntry[])oreRegistry.getOres());
            event.getRegistry().registerAll((IForgeRegistryEntry[])rockAddonRegistry.getRocks());
            event.getRegistry().registerAll((IForgeRegistryEntry[])buildingAddonRegistry.getBlock());
            event.getRegistry().registerAll((IForgeRegistryEntry[])engravedRegistry.getEngraved());
            event.getRegistry().registerAll((IForgeRegistryEntry[])flowerRegistry.getFlowers());
            event.getRegistry().registerAll((IForgeRegistryEntry[])grassRegistry.getGrass());
            event.getRegistry().registerAll((IForgeRegistryEntry[])otherRegistry.getBlock());
        }

        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            LOGGER.info("Registering biomes...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{WNBiomes.River, WNBiomes.FrozenRiver, WNBiomes.AmazonRiver, WNBiomes.NileRiver, WNBiomes.CanyonRiver, WNBiomes.IcelandRiver, WNBiomes.DaintreeRiver, WNBiomes.TatraStream});
            for (int x = 0; x < WNBiomes.registerBiomes.size(); ++x) {
                Biome b = WNBiomes.registerBiomes.get(x);
                event.getRegistry().register((IForgeRegistryEntry)b);
            }
            WNBiomes.registerBiomes();
        }

        @SubscribeEvent
        public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
            LOGGER.info("Registering particles...");
            BasicParticleType type = ParticleRegistry.DUNGEON_HEART;
            type = ParticleRegistry.CRYSTAL_SPARK;
            type = ParticleRegistry.GEYSER;
            type = ParticleRegistry.STEAM;
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> evt) {
            LOGGER.info("Registering tileEntities...");
            TileEntityType piston_type = TileEntityType.Builder.func_223042_a(CustomPistonTileEntity::new, (Block[])new Block[]{WNBlocks.RS_PISTON1_MOVING}).func_206865_a(null);
            piston_type.setRegistryName(Main.modid, "rs_piston1");
            evt.getRegistry().register((IForgeRegistryEntry)piston_type);
            initGuis.PISTON_TYPE = piston_type;
            TileEntityType dungeonCommander = TileEntityType.Builder.func_223042_a(DungeonCommanderTileEntity::new, (Block[])new Block[]{WNBlocks.DUNGEON_COMMANDER}).func_206865_a(null);
            dungeonCommander.setRegistryName(Main.modid, "dungeon_commander");
            evt.getRegistry().register((IForgeRegistryEntry)dungeonCommander);
            initGuis.DUNGEON_COMMANDER = dungeonCommander;
            TileEntityType hydrothermalVent = TileEntityType.Builder.func_223042_a(HydrothermalVentTileEntity::new, (Block[])new Block[]{WNBlocks.HYDROTHERMAL_VENT}).func_206865_a(null);
            hydrothermalVent.setRegistryName(Main.modid, "hydrothermal_vent");
            evt.getRegistry().register((IForgeRegistryEntry)hydrothermalVent);
            initGuis.HYDROTHERMAL_VENT_TILE_ENTITY = hydrothermalVent;
            TileEntityType gravityShroom = TileEntityType.Builder.func_223042_a(GravityShroomTileEntity::new, (Block[])new Block[]{WNBlocks.GRAVITYSHROOM}).func_206865_a(null);
            gravityShroom.setRegistryName(Main.modid, "gravityshroom");
            evt.getRegistry().register((IForgeRegistryEntry)gravityShroom);
            initGuis.GRAVITY_SHROOM_TILE_ENTITY = gravityShroom;
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            LOGGER.info("Registering containers...");
            RegistryEvents.registerContainer("wildnature:pouch", PouchContainer::new);
            CONTAINER_TYPES.forEach(container_type -> event.getRegistry().register((IForgeRegistryEntry)container_type));
        }

        private static <T extends Container> void registerContainer(String name, IContainerFactory<T> container) {
            ContainerType type = IForgeContainerType.create(container);
            type.setRegistryName(name);
            CONTAINER_TYPES.add(type);
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            LOGGER.info("Registering sounds...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])SoundRegistry.register());
        }

        public static ResourceLocation location(String name) {
            return new ResourceLocation(Main.modid, name);
        }

        static {
            rockRegistry = new RockRegistry();
            CONTAINER_TYPES = new ArrayList();
        }
    }
}

