/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.CurrantPlant;
import com.matez.wildnature.blocks.QuincePlant;
import com.matez.wildnature.blocks.WildStrawberryPlant;
import com.matez.wildnature.compatibility.WNLoot;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.other.Utilities;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class AlgaeBlock
extends GrassBlock {
    private Item item;
    private String dirt;

    public AlgaeBlock(Block.Properties properties, Item.Properties builder, ResourceLocation regName, String dirt) {
        super(properties);
        this.dirt = dirt;
        this.setRegistryName(regName);
        this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.item);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196382_a});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? Block.func_199601_a((BlockState)this.func_176223_P(), (BlockState)((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(this.dirt))).func_176223_P(), (World)context.func_195991_k(), (BlockPos)context.func_195995_a()) : super.func_196258_a(context);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        try {
            if (plant.func_177230_c() instanceof BushBlock && Utilities.isValidGroundFor(plant, Blocks.field_196658_i.func_176223_P(), world, pos)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this.getBlock() == Blocks.field_150434_aF || this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_196611_F;
        }
        if (plant.func_177230_c() == Blocks.field_196608_cF && this == Blocks.field_196608_cF) {
            return true;
        }
        if (plantable instanceof BushBlock && (!(plantable instanceof CropsBlock) || plantable instanceof QuincePlant || plantable instanceof WildStrawberryPlant || plantable instanceof CurrantPlant)) {
            return true;
        }
        switch (type) {
            case Desert: {
                return this.getBlock() == Blocks.field_150354_m || this.getBlock() == Blocks.field_150405_ch || this.getBlock() instanceof GlazedTerracottaBlock;
            }
            case Nether: {
                return this.getBlock() == Blocks.field_150425_aM;
            }
            case Crop: {
                return this.getBlock() == Blocks.field_150458_ak;
            }
            case Cave: {
                return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
            }
            case Plains: {
                return this.getBlock() == Blocks.field_196658_i || Block.func_196245_f((Block)this) || this.getBlock() == Blocks.field_150458_ak;
            }
            case Water: {
                return state.func_185904_a() == Material.field_151586_h;
            }
            case Beach: {
                boolean isBeach = this.getBlock() == Blocks.field_196658_i || Block.func_196245_f((Block)this) || this.getBlock() == Blocks.field_150354_m;
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() == Fluids.field_204546_a || worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() == Fluids.field_207212_b;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        int chance = Utilities.rint(0, 15);
        BlockState blockstate = Blocks.field_150349_c.func_176223_P();
        blockstate = chance <= 7 ? Main.getBlockByID("minecraft:grass").func_176223_P() : (chance > 7 && chance < 12 ? Main.getBlockByID("wildnature:medium_grass").func_176223_P() : Main.getBlockByID("wildnature:small_grass").func_176223_P());
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState blockstate1;
                    BlockState blockstate2 = worldIn.func_180495_p(blockpos1);
                    if (blockstate2.func_177230_c() == blockstate.func_177230_c() && rand.nextInt(10) == 0 && blockstate.func_177230_c() instanceof IGrowable) {
                        ((IGrowable)blockstate.func_177230_c()).func_176474_b(worldIn, rand, blockpos1, blockstate2);
                    }
                    if (worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() != Fluids.field_204546_a && worldIn.func_180495_p(pos.func_177984_a()).func_204520_s().func_206886_c() != Fluids.field_207212_b) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List list = worldIn.func_180494_b(blockpos1).func_201853_g();
                        if (list.isEmpty()) continue block0;
                        blockstate1 = ((FlowersFeature)((DecoratedFeatureConfig)((ConfiguredFeature)list.get((int)0)).field_222738_b).field_214689_a.field_222737_a).func_202355_a(rand, blockpos1);
                    } else {
                        blockstate1 = blockstate;
                    }
                    if (!blockstate1.func_196955_c((IWorldReader)worldIn, blockpos1)) continue block0;
                    worldIn.func_180501_a(blockpos1, blockstate1, 3);
                    continue block0;
                }
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || worldIn.func_180495_p(blockpos1).func_224756_o((IBlockReader)worldIn, blockpos1)) continue block0;
                ++j;
            }
        }
    }

    public boolean func_200124_e(BlockState state) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && !silkTouch) {
            if (WNLoot.isSilkTouch(builder)) {
                list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)this), 1));
            } else {
                list.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)Main.getBlockByID(this.dirt)), 1));
            }
        }
        return list;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }
}

