/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.blocks.HorizontalBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class BasicBench
extends HorizontalBase {
    public static final EnumProperty<ConnectingFurnitureType> PART = EnumProperty.func_177709_a((String)"part", ConnectingFurnitureType.class);

    public BasicBench(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties, builder, regName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.MIDDLE)));
    }

    public BasicBench(Block.Properties properties, Item.Properties builder, String drop, int min, int max, int exp, ResourceLocation regName) {
        super(properties, builder, drop, min, max, exp, regName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.MIDDLE)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BasicBench.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return this.getBenchState(state, (IWorld)context.func_195991_k(), context.func_195995_a(), (Direction)state.func_177229_b((IProperty)FACING));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getBenchState(state, world, pos, (Direction)state.func_177229_b((IProperty)FACING));
    }

    private BlockState getBenchState(BlockState state, IWorld world, BlockPos pos, Direction dir) {
        boolean left = this.isBench(world, pos, dir.func_176746_e(), dir);
        boolean right = this.isBench(world, pos, dir.func_176735_f(), dir);
        if (left && right) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.MIDDLE));
        }
        if (left) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.LEFT));
        }
        return right ? (BlockState)state.func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.RIGHT)) : (BlockState)state.func_206870_a(PART, (Comparable)((Object)ConnectingFurnitureType.MIDDLE));
    }

    private boolean isBench(IWorld world, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = world.func_180495_p(source.func_177972_a(direction));
        if (state.func_177230_c() == this) {
            Direction sofaDirection = (Direction)state.func_177229_b((IProperty)FACING);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, PART});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum ConnectingFurnitureType implements IStringSerializable
    {
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right");

        private final String name;

        private ConnectingFurnitureType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

