/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.blocks.BushBase;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.lists.WNItems;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class CaveBush
extends BushBase {
    private boolean reversed = false;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHAPER = Block.func_208617_a((double)2.0, (double)16.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    public CaveBush(Block.Properties properties, Item.Properties builder, ResourceLocation regName, boolean reversed) {
        super(properties, builder, regName);
        this.reversed = reversed;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (this.reversed && state.func_177230_c() == WNBlocks.STALACTITE && Utilities.rint(0, 8, random) == 0) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, (double)pos.func_177958_n() + 0.5 + Utilities.rdoub(-0.3, 0.3), (double)pos.func_177956_o() + 0.6 + Utilities.rdoub(0.0, 0.1), (double)pos.func_177952_p() + 0.5 + Utilities.rdoub(-0.3, 0.3), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.reversed) {
            return SHAPER;
        }
        return SHAPE;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (this.reversed) {
            BlockPos blockpos = pos.func_177984_a();
            return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
        }
        BlockPos blockpos = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    @Override
    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return (BlockTags.func_199896_a().func_199915_b(new ResourceLocation("forge", "stone")).func_199685_a_((Object)block) || block == Blocks.field_150351_n || block == Blocks.field_150403_cj) && ((IWorldReader)worldIn).func_201669_a(pos, 0) <= 10;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        if (state.func_177230_c() == WNBlocks.ROOTS || state.func_177230_c() == WNBlocks.LARGE_ROOT) {
            l.add(new ItemStack((IItemProvider)Items.field_151055_y, Utilities.rint(1, 3)));
            return l;
        }
        if (state.func_177230_c() == WNBlocks.GLOW_SHROOM || state.func_177230_c() == WNBlocks.LARGE_GLOWSHROOM) {
            l.add(new ItemStack((IItemProvider)WNItems.GLOWSHROOM_DUST, Utilities.rint(0, 2)));
            return l;
        }
        if (state.func_177230_c() == WNBlocks.ICE_SHROOM) {
            l.add(new ItemStack((IItemProvider)WNItems.ICESHROOM_DUST, Utilities.rint(0, 1)));
            return l;
        }
        if (state.func_177230_c() == WNBlocks.MAGMA_SHROOM) {
            l.add(new ItemStack((IItemProvider)Items.field_151059_bz, Utilities.rint(0, 3) == 0 ? 1 : 0));
            return l;
        }
        if (state.func_177230_c() == WNBlocks.STONE_GRASS || state.func_177230_c() == WNBlocks.ICE_GRASS || state.func_177230_c() == WNBlocks.STALACTITE || state.func_177230_c() == WNBlocks.STALAGMITE || state.func_177230_c() == WNBlocks.LARGE_STALAGMITE || state.func_177230_c() == WNBlocks.LARGE_STALACTITE || state.func_177230_c() == WNBlocks.ICYCLE || state.func_177230_c() == WNBlocks.LARGE_ICYCLE) {
            if (Utilities.rint(0, 7) == 0) {
                l.add(new ItemStack((IItemProvider)Item.func_150898_a((Block)state.func_177230_c()), 1));
            }
            return l;
        }
        return super.func_220076_a(state, builder);
    }
}

