/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.lists.WNBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DoorBase
extends DoorBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private Item item;

    public DoorBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties);
        this.setRegistryName(regName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.item = (Item)new BlockItem((Block)this, builder).setRegistryName(regName);
        WNBlocks.BLOCKS.add((Block)this);
        WNBlocks.ITEMBLOCKS.add(this.item);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a((IProperty)FACING, facingState.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)OPEN, facingState.func_177229_b((IProperty)OPEN))).func_206870_a(HINGE, facingState.func_177229_b(HINGE))).func_206870_a((IProperty)POWERED, facingState.func_177229_b((IProperty)POWERED)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            ItemStack itemstack = player.func_184614_ca();
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                Block.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
                Block.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext p_208073_1_) {
        boolean flag1;
        World iblockreader = p_208073_1_.func_195991_k();
        BlockPos blockpos = p_208073_1_.func_195995_a();
        Direction direction = p_208073_1_.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        Direction direction1 = direction.func_176735_f();
        BlockPos blockpos2 = blockpos.func_177972_a(direction1);
        BlockState blockstate = iblockreader.func_180495_p(blockpos2);
        BlockPos blockpos3 = blockpos1.func_177972_a(direction1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos3);
        Direction direction2 = direction.func_176746_e();
        BlockPos blockpos4 = blockpos.func_177972_a(direction2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos4);
        BlockPos blockpos5 = blockpos1.func_177972_a(direction2);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos5);
        int i = (blockstate.func_224756_o((IBlockReader)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.func_224756_o((IBlockReader)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.func_224756_o((IBlockReader)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.func_224756_o((IBlockReader)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.func_177230_c() == this && blockstate2.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vec3d vec3d = p_208073_1_.func_221532_j();
                double d0 = vec3d.field_72450_a - (double)blockpos.func_177958_n();
                double d1 = vec3d.field_72449_c - (double)blockpos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return false;
        }
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        worldIn.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    public void func_176512_a(World worldIn, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        if (blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)blockstate.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(worldIn, pos, open);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177972_a(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (blockIn != this && flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                this.playSound(worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
        }
        return blockstate.func_177230_c() == this;
    }

    private void playSound(World p_196426_1_, BlockPos p_196426_2_, boolean p_196426_3_) {
        p_196426_1_.func_217378_a((PlayerEntity)null, p_196426_3_ ? this.getOpenSound() : this.getCloseSound(), p_196426_2_, 0);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List list = super.func_220076_a(state, builder);
        if (list.isEmpty() && state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            list.add(new ItemStack((IItemProvider)this.item, 1));
        }
        return list;
    }
}

