/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.LeavesBase;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class FruitableLeaves
extends LeavesBase {
    public static IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)6);
    private final ArrayList<StageFruit> stageFruits;
    private boolean hasFlowers = false;

    public FruitableLeaves(Block.Properties properties, Item.Properties builder, ResourceLocation regName, ArrayList<StageFruit> stageFruits) {
        super(properties, builder, regName);
        this.stageFruits = stageFruits;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)this.getStage(), (Comparable)Integer.valueOf(0)));
    }

    public FruitableLeaves(Block.Properties properties, Item.Properties builder, ResourceLocation regName, ArrayList<StageFruit> stageFruits, boolean hasFlowers) {
        super(properties, builder, regName);
        this.stageFruits = stageFruits;
        this.hasFlowers = hasFlowers;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)this.getStage(), (Comparable)Integer.valueOf(0)));
    }

    public int getMaxStages() {
        return 6;
    }

    public IntegerProperty getStage() {
        return STAGE;
    }

    public int getCurrentStage(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getStage());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public boolean func_149653_t(BlockState state) {
        int stage = (Integer)state.func_177229_b((IProperty)this.getStage());
        if (this.hasFlowers) {
            return stage == 0 || stage == 1;
        }
        return stage == 0;
    }

    public void func_196265_a(BlockState state, World worldIn, BlockPos pos, Random random) {
        super.func_196265_a(state, worldIn, pos, random);
        if (Utilities.rint(0, (Integer)CommonConfig.leafFruitChance.get()) == 0) {
            this.updateFruit(state, worldIn, pos);
        }
    }

    private void updateFruit(BlockState state, World world, BlockPos pos) {
        int c = this.getCurrentStage(state);
        if (this.hasFlowers && c == 0) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)this.getStage(), (Comparable)Integer.valueOf(1)));
            return;
        }
        if (c == 0 || this.hasFlowers && c == 1) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)this.getStage(), (Comparable)Integer.valueOf(Utilities.rint(0, this.getMaxStages()))));
        }
    }

    public boolean func_220051_a(BlockState p_220051_1_, World p_220051_2_, BlockPos p_220051_3_, PlayerEntity p_220051_4_, Hand p_220051_5_, BlockRayTraceResult p_220051_6_) {
        int c = this.getCurrentStage(p_220051_1_);
        ItemPortion p = this.getFruitFromStage(c);
        if (p != null && Main.getItemByID(p.item.toString()) != Items.field_190931_a) {
            p_220051_2_.func_175656_a(p_220051_3_, (BlockState)p_220051_1_.func_206870_a((IProperty)this.getStage(), (Comparable)Integer.valueOf(0)));
            FruitableLeaves.func_180635_a((World)p_220051_2_, (BlockPos)p_220051_3_, (ItemStack)new ItemStack((IItemProvider)Main.getItemByID(p.item.toString()), Utilities.rint(p.min, p.max)));
            p_220051_2_.func_184133_a((PlayerEntity)null, p_220051_3_, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + p_220051_2_.field_73012_v.nextFloat() * 0.4f);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List<ItemStack> list = super.func_220076_a(state, builder);
        int c = this.getCurrentStage(state);
        ItemPortion p = this.getFruitFromStage(c);
        if (p != null && Main.getItemByID(p.item.toString()) != Items.field_190931_a) {
            list.add(new ItemStack((IItemProvider)Main.getItemByID(p.item.toString()), Utilities.rint(p.min, p.max)));
        }
        return list;
    }

    private ItemPortion getFruitFromStage(int stage) {
        for (int x = 0; x < this.stageFruits.size(); ++x) {
            if (this.stageFruits.get((int)x).stage != stage) continue;
            return this.stageFruits.get((int)x).portion;
        }
        return null;
    }

    public static class ItemPortion {
        public final ResourceLocation item;
        public final int max;
        public final int min;

        public ItemPortion(String item, int min, int max) {
            this.item = new ResourceLocation(item);
            this.min = min;
            this.max = max;
        }
    }

    public static class StageFruit {
        public final int stage;
        public final ItemPortion portion;

        public StageFruit(int stage, ItemPortion portion) {
            this.stage = stage;
            this.portion = portion;
        }
    }
}

