/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.BlockBase;
import com.matez.wildnature.customizable.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;

public class RockBase
extends BlockBase {
    private int type;
    private int size = (Integer)CommonConfig.rockChance.get();
    private int count = (Integer)CommonConfig.rockSize.get();
    private ResourceLocation regName;

    private static Block.Properties Properties(Block.Properties properties, int type) {
        properties.func_200947_a(SoundType.field_185851_d);
        if (type == 0) {
            properties.func_200948_a(1.5f, 6.0f);
        } else if (type == 1) {
            properties.func_200948_a(1.2f, 3.0f);
        } else if (type == 2) {
            properties.func_200948_a(1.6f, 7.0f);
        } else if (type == 3) {
            properties.func_200948_a(2.0f, 9.0f);
        }
        return properties;
    }

    public RockBase(Block.Properties properties, Item.Properties builder, ResourceLocation regName, int type) {
        super(RockBase.Properties(properties, type), builder, regName);
        this.regName = regName;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }

    public int getMinYByType(int seaLevel) {
        int defaultMinY = Math.round(seaLevel / 3);
        if (this.type == 0) {
            return 0;
        }
        if (this.type == 1) {
            return defaultMinY + defaultMinY + 5;
        }
        if (this.type == 2) {
            return defaultMinY + 5;
        }
        if (this.type == 3) {
            return 5;
        }
        return 0;
    }

    public int getMaxYByType(int seaLevel, int worldHeight) {
        int defaultMaxY = Math.round(seaLevel / 3);
        if (this.type == 0) {
            return worldHeight;
        }
        if (this.type == 1) {
            return seaLevel;
        }
        if (this.type == 2) {
            return defaultMaxY + defaultMaxY + 5;
        }
        if (this.type == 3) {
            return defaultMaxY + 5;
        }
        return 0;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        boolean silkTouch = false;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        String rock = this.regName.func_110623_a().toString();
        list.add(new ItemStack((IItemProvider)Main.getBlockByID("wildnature:" + rock + "_cobble"), 1));
        return list;
    }
}

