/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.blocks.BlockBase;
import com.matez.wildnature.lists.WNItems;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.ToolType;

public class SaltOreBlock
extends BlockBase {
    public static final EnumProperty<SaltVariant> SALT_VARIANT = EnumProperty.func_177709_a((String)"type", SaltVariant.class);

    public SaltOreBlock(Block.Properties properties, Item.Properties builder, ResourceLocation regName) {
        super(properties, builder, regName);
    }

    public SaltOreBlock(Block.Properties properties, Item.Properties builder, String drop, int min, int max, int exp, ResourceLocation regName) {
        super(properties, builder, drop, min, max, exp, regName);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new IProperty[]{SALT_VARIANT});
    }

    public int getHarvestLevel(BlockState state) {
        if (state.func_177229_b(SALT_VARIANT) == SaltVariant.STONE) {
            return 1;
        }
        return 0;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        if (state.func_177229_b(SALT_VARIANT) == SaltVariant.STONE) {
            return ToolType.PICKAXE;
        }
        return ToolType.SHOVEL;
    }

    public float func_176195_g(BlockState state, IBlockReader p_176195_2_, BlockPos p_176195_3_) {
        if (state.func_177229_b(SALT_VARIANT) == SaltVariant.STONE) {
            return 1.5f;
        }
        return 0.5f;
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (state.func_177229_b(SALT_VARIANT) == SaltVariant.STONE) {
            return 1.5f;
        }
        return 0.5f;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((IItemProvider)WNItems.SALT, Utilities.rint(2, 5)));
        return list;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        if (state.func_177229_b(SALT_VARIANT) == SaltVariant.STONE) {
            return SoundType.field_185851_d;
        }
        return SoundType.field_185855_h;
    }

    public static enum SaltVariant implements IStringSerializable
    {
        STONE("stone"),
        SAND("sand");

        private final String name;

        private SaltVariant(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

