/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks;

import com.matez.wildnature.entity.type.animal.duck.AbstractDuckEntity;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WaterLilyBase
extends LilyPadBlock {
    protected static final VoxelShape LILY_PAD_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);

    public WaterLilyBase(Block.Properties properties, ResourceLocation regName) {
        super(properties.func_200947_a(SoundType.field_185850_c));
        this.setRegistryName(regName);
        WNBlocks.BLOCKS.add((Block)this);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof BoatEntity) {
            worldIn.func_175655_b(new BlockPos((Vec3i)pos), true);
        } else if (!(entityIn instanceof AbstractDuckEntity)) {
            // empty if block
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return LILY_PAD_AABB;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a || state.func_185904_a() == Material.field_151588_w;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        if (Utilities.rint(0, 4) == 0) {
            l.add(new ItemStack((IItemProvider)this.func_199767_j(), 1));
        }
        return l;
    }
}

