/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.blocks.colors;

import com.matez.wildnature.Main;
import com.matez.wildnature.other.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.Region;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WNBiomeColors {
    private static final IColorResolver GRASS_COLOR = (biome, pos, seed) -> biome.func_180627_b(pos);
    private static final IColorResolver FOLIAGE_COLOR = (biome, pos, seed) -> biome.func_180625_c(pos);
    private static final IColorResolver WATER_COLOR = (biome, pos, seed) -> {
        if (pos.func_177956_o() > 20) {
            return biome.func_185361_o();
        }
        return 0;
    };
    private static final IColorResolver WATER_FOG_COLOR = (biome, pos, seed) -> {
        if (pos.func_177956_o() > 20) {
            return biome.func_185361_o();
        }
        return 0;
    };

    private static int getColor(IEnviromentBlockReader reader, BlockPos pos, IColorResolver resolver) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        if (Utilities.rint(0, 10) == 0) {
            Main.LOGGER.info((reader instanceof World) + " " + (reader instanceof Region) + " " + (reader instanceof ChunkRenderCache) + " " + (reader instanceof WorldGenRegion));
        }
        if (l == 0) {
            return resolver.getColor(reader.func_180494_b(pos), pos, 0L);
        }
        int i1 = (l * 2 + 1) * (l * 2 + 1);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(pos.func_177958_n() - l, pos.func_177956_o(), pos.func_177952_p() - l, pos.func_177958_n() + l, pos.func_177956_o(), pos.func_177952_p() + l);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        while (cubecoordinateiterator.func_218301_a()) {
            blockpos$mutableblockpos.func_181079_c(cubecoordinateiterator.func_218304_b(), cubecoordinateiterator.func_218302_c(), cubecoordinateiterator.func_218303_d());
            int j1 = resolver.getColor(reader.func_180494_b((BlockPos)blockpos$mutableblockpos), (BlockPos)blockpos$mutableblockpos, 0L);
            i += (j1 & 0xFF0000) >> 16;
            j += (j1 & 0xFF00) >> 8;
            k += j1 & 0xFF;
        }
        return (i / i1 & 0xFF) << 16 | (j / i1 & 0xFF) << 8 | k / i1 & 0xFF;
    }

    public static int getGrassColor(IEnviromentBlockReader reader, BlockPos pos) {
        return WNBiomeColors.getColor(reader, pos, GRASS_COLOR);
    }

    public static int getFoliageColor(IEnviromentBlockReader reader, BlockPos pos) {
        return WNBiomeColors.getColor(reader, pos, FOLIAGE_COLOR);
    }

    public static int getWaterColor(IEnviromentBlockReader reader, BlockPos pos) {
        return WNBiomeColors.getColor(reader, pos, WATER_COLOR);
    }

    @OnlyIn(value=Dist.CLIENT)
    static interface IColorResolver {
        public int getColor(Biome var1, BlockPos var2, long var3);
    }
}

