/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.commands;

import com.matez.wildnature.Main;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.other.Utilities;
import com.matez.wildnature.world.gen.biomes.undergroundBiomes.setup.URBiome;
import com.matez.wildnature.world.gen.biomes.undergroundBiomes.setup.URBiomeManager;
import com.matez.wildnature.world.gen.chunk.WNNoiseChunkGenerator;
import com.matez.wildnature.world.gen.noise.sponge.module.source.RidgedMulti;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class CaveBiomeArgument
implements ArgumentType<URBiome> {
    private static int radius = -1;
    private static int quality = 10;
    private static int maxRadius = 10000;
    private static boolean speedSearch = false;
    public static final DynamicCommandExceptionType INVALID_URBIOME_EXCEPTION = new DynamicCommandExceptionType(URBiome2 -> new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "This biome is invalid.")));
    private static ArrayList<ResourceLocation> urURBiomeNames = new ArrayList();

    public static CaveBiomeArgument createArgument() {
        return new CaveBiomeArgument();
    }

    public URBiome parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.func_195826_a((StringReader)reader);
        for (URBiome object : URBiomeManager.riverBiomes.getObjects()) {
            if (!location.func_110623_a().equals(object.getName())) continue;
            return object;
        }
        throw INVALID_URBIOME_EXCEPTION.create((Object)location);
    }

    public static URBiome getValue(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return (URBiome)context.getArgument(name, URBiome.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        if (urURBiomeNames.isEmpty()) {
            for (URBiome object : URBiomeManager.riverBiomes.getObjects()) {
                urURBiomeNames.add(new ResourceLocation("wildnature", object.name));
            }
        }
        return ISuggestionProvider.func_197014_a(urURBiomeNames, (SuggestionsBuilder)suggestionsBuilder);
    }

    public static int findTeleportURBiome(CommandSource cs, final ServerPlayerEntity player, final URBiome ... URBiome2) {
        final ArrayList<URBiome> URBiomes = new ArrayList<URBiome>(Arrays.asList(URBiome2));
        StringTextComponent s2 = URBiomes.size() == 1 ? new StringTextComponent(TextFormatting.AQUA + "Trying to find " + TextFormatting.GOLD + "wildnature:" + URBiome2[0].getName() + TextFormatting.AQUA + " biome...") : new StringTextComponent(TextFormatting.AQUA + "Trying to find one of " + TextFormatting.GOLD + URBiomes.size() + TextFormatting.AQUA + " biomes...");
        Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s2));
        StringTextComponent sx = new StringTextComponent(TextFormatting.AQUA + "This will take a moment.");
        Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)sx));
        final World world = player.field_70170_p;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StringTextComponent s3;
                RidgedMulti multi = WNNoiseChunkGenerator.getCaveNoise();
                URBiomePos URBiomePos2 = null;
                if (multi == null) {
                    s3 = new StringTextComponent(TextFormatting.RED + "No biomes are generated on this world! Please use WildNature world type.");
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to find biome"), true);
                    s3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Operation Failed :/")));
                    Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s3));
                } else {
                    URBiomePos2 = CaveBiomeArgument.lookForURBiome(multi, world, (int)player.field_70165_t, (int)player.field_70161_v, (PlayerEntity)player, URBiome2);
                }
                if (URBiomePos2 != null && URBiomePos2.URBiome != null && URBiomePos2.pos != null) {
                    BlockPos closestURBiomePos = URBiomePos2.pos;
                    double x = closestURBiomePos.func_177958_n();
                    double y = 13.0;
                    double z = closestURBiomePos.func_177952_p();
                    if (!world.func_201675_m().func_76569_d()) {
                        y = CaveBiomeArgument.getY(world, closestURBiomePos).func_177956_o();
                    }
                    Main.LOGGER.info("Found " + URBiomePos2.URBiome.getName() + " urbiome at " + x + " " + y + " " + z + ". This taken " + radius + " attempts.");
                    StringTextComponent s32 = new StringTextComponent(TextFormatting.AQUA + "Found " + TextFormatting.LIGHT_PURPLE + new TranslationTextComponent(URBiomePos2.URBiome.getName(), new Object[0]).func_150254_d() + TextFormatting.AQUA + " biome at ");
                    StringTextComponent s4 = new StringTextComponent(TextFormatting.YELLOW + "" + x + " " + y + " " + z);
                    StringTextComponent s42 = new StringTextComponent(TextFormatting.AQUA + " - " + TextFormatting.GOLD + (int)Utilities.getDistance(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), new BlockPos(x, y, z)) + TextFormatting.AQUA + " blocks away.");
                    s4.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Click to copy to the command prompt")));
                    s4.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "" + x + " " + y + " " + z));
                    Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s32).func_150257_a((ITextComponent)s4).func_150257_a((ITextComponent)s42));
                    StringTextComponent s5 = new StringTextComponent(TextFormatting.GREEN + "Click to teleport");
                    s5.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Click here")));
                    s5.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + player.func_200200_C_().getString() + " " + x + " " + y + " " + z));
                    Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s5));
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Found biome " + TextFormatting.AQUA + (int)Utilities.getDistance(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), new BlockPos(x, y, z)) + TextFormatting.GREEN + " blocks away"), true);
                } else if (URBiomes.size() == 1) {
                    s3 = new StringTextComponent(TextFormatting.RED + "Unable to find " + TextFormatting.LIGHT_PURPLE + ((URBiome)URBiomes.get(0)).getName() + TextFormatting.RED + " biome.");
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to find biome"), true);
                    s3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Operation Failed :/")));
                    Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s3));
                } else {
                    s3 = new StringTextComponent(TextFormatting.RED + "Unable to find any of " + TextFormatting.LIGHT_PURPLE + URBiomes.size() + TextFormatting.RED + " biomes.");
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Unable to find biomes"), true);
                    s3.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Operation Failed :/")));
                    Main.sendChatMessage((PlayerEntity)player, new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s3));
                }
            }
        });
        t.start();
        return 1;
    }

    public static BlockPos getY(World world, BlockPos pos) {
        BlockPos blockpos2;
        IChunk chunk = world.func_217349_x(pos);
        BlockPos blockpos = blockpos2 = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState state = chunk.func_180495_p(blockpos1);
            if (!state.func_185904_a().func_76230_c() && !world.func_175623_d(blockpos1.func_177977_b()) && state.func_185904_a() != Material.field_151584_j) {
                return blockpos1;
            }
            blockpos = blockpos1;
        }
        return blockpos2;
    }

    public static BlockPos getTopBlock(IWorld world, int x, int z) {
        IChunk chunk = world.func_217348_a(x >> 4, z >> 4, ChunkStatus.field_222617_m);
        return new BlockPos(x, chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, x & 0xF, z & 0xF), z);
    }

    public static URBiomePos lookForURBiome(RidgedMulti noise, World world, int startX, int startZ, PlayerEntity player, URBiome ... URBiomeToFind) {
        ArrayList<URBiome> URBiomes = new ArrayList<URBiome>(Arrays.asList(URBiomeToFind));
        speedSearch = true;
        Main.LOGGER.info("Starting searching for " + URBiomes.size() + " URBiomes");
        int maxDistance = (Integer)CommonConfig.maxSearchRadius.get();
        for (int currDist = 0; currDist < maxDistance; currDist += quality) {
            ArrayList<BlockPos> pos = CaveBiomeArgument.drawCircle(startX, startZ, currDist);
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Searching in radius " + TextFormatting.GOLD + currDist + TextFormatting.YELLOW + "/" + TextFormatting.GOLD + maxDistance), true);
            int x = 0;
            for (BlockPos vec : pos) {
                ++x;
                double vnoise = noise.getValue(vec.func_177958_n(), 1.0, vec.func_177952_p());
                if (!(vnoise >= 0.6) || !(vnoise <= 2.0)) continue;
                for (URBiome URBiome2 : URBiomes) {
                    if (URBiomeManager.getBiomeAt(world.func_217349_x(new BlockPos(vec.func_177958_n(), 1, vec.func_177952_p())), new BlockPos(vec.func_177958_n(), 1, vec.func_177952_p()), world.func_72905_C()) != URBiome2) continue;
                    radius = currDist;
                    return new URBiomePos(new BlockPos(vec.func_177958_n(), 0, vec.func_177952_p()), URBiome2);
                }
            }
        }
        URBiome b = URBiomes.get(Utilities.rint(0, URBiomes.size() - 1));
        Main.LOGGER.info("Finding URBiome on the world, ignoring distance | " + b);
        return CaveBiomeArgument.lookForURBiomeAsap(world, b, startX, startZ, player);
    }

    public static URBiomePos lookForURBiomeAsap(World world, URBiome URBiomeToFind, int startX, int startZ, PlayerEntity player) {
        return null;
    }

    private static ArrayList<BlockPos> drawCircle(int x, int y, int r) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        double PI = Math.PI;
        for (double i = 0.0; i < 360.0; i += 1.0) {
            double angle = i;
            double x1 = (double)r * Math.cos(angle * PI / 180.0);
            double y1 = (double)r * Math.sin(angle * PI / 180.0);
            int ElX = (int)Math.round((double)x + x1);
            int ElY = (int)Math.round((double)y + y1);
            pos.add(new BlockPos(ElX, 0, ElY));
        }
        return pos;
    }

    public static class URBiomePos {
        public BlockPos pos;
        public URBiome URBiome;

        public URBiomePos(BlockPos pos, URBiome URBiome2) {
            this.pos = pos;
            this.URBiome = URBiome2;
        }
    }
}

