/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.commands;

import com.matez.wildnature.Main;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;

public class ExportToFile {
    public int export(CommandContext<CommandSource> source, MutableBoundingBox area, String name, BlockStateInput centerTo, boolean fullJava, boolean tileEntitySave) throws CommandSyntaxException {
        StringTextComponent s4;
        StringTextComponent s42;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        ServerWorld serverworld = ((CommandSource)source.getSource()).func_197023_e();
        BlockPos centerBlockPos = null;
        for (BlockPos blockpos : BlockPos.func_191531_b((int)area.field_78897_a, (int)area.field_78895_b, (int)area.field_78896_c, (int)area.field_78893_d, (int)area.field_78894_e, (int)area.field_78892_f)) {
            if (serverworld.func_180495_p(blockpos).func_177230_c() == Blocks.field_150350_a) continue;
            list.add(blockpos.func_185334_h());
        }
        StringTextComponent s3 = new StringTextComponent(TextFormatting.AQUA + "Exporting " + TextFormatting.GOLD + list.size() + TextFormatting.AQUA + " blocks to " + TextFormatting.GOLD + name + ".java" + TextFormatting.AQUA + "...");
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s3));
        boolean invalid = false;
        for (BlockPos blockpos1 : list) {
            if (serverworld.func_180495_p(blockpos1) != centerTo.func_197231_a()) continue;
            if (centerBlockPos != null) {
                invalid = true;
                break;
            }
            centerBlockPos = blockpos1;
        }
        if (invalid) {
            s42 = new StringTextComponent(TextFormatting.RED + "Cannot export " + TextFormatting.GOLD + name + ".java" + TextFormatting.RED + " - There are more than one " + TextFormatting.GOLD + centerTo.func_197231_a().func_177230_c().getRegistryName() + TextFormatting.RED + ".");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s42));
            return 0;
        }
        if (centerBlockPos == null) {
            s42 = new StringTextComponent(TextFormatting.RED + "Cannot export " + TextFormatting.GOLD + name + ".java" + TextFormatting.RED + " - Cannot find " + TextFormatting.GOLD + centerTo.func_197231_a().func_177230_c().getRegistryName() + TextFormatting.RED + ".");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s42));
            return 0;
        }
        String start = "";
        String export = "";
        String signature = "\n\n//   wildnature mod\n//           created by matez \n//         all rights reserved   \n//     https://wildnaturemod.com\n";
        String end = "";
        if (fullJava) {
            start = "import com.matez.wildnature.Main;\nimport com.matez.wildnature.world.gen.structures.nature.SchemFeature;\nimport com.mojang.datafixers.Dynamic;\nimport net.minecraft.util.math.BlockPos;\nimport net.minecraft.block.BlockState;\nimport net.minecraft.world.gen.feature.NoFeatureConfig;\n\nimport java.util.Set;\nimport java.util.function.Function;\n\npublic class %s% extends SchemFeature {\n    public %s%(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace) {\n        super(config, doBlockNofityOnPlace);\n        Main.treesList.add(this);\n    }\n\n    public %s%(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace, BlockState log, BlockState leaves) {\n        super(config, doBlockNofityOnPlace);\n        Main.treesList.add(this);\n        LOG = log;\n        LEAVES =leaves;\n    }\n\n    @Override\n    public Set<BlockPos> setBlocks() {\n".replace("%s%", name);
            end = "return super.setBlocks();\n    }\n}";
        }
        for (BlockPos blockPos : list) {
            if (blockPos == centerBlockPos) continue;
            BlockPos centered = this.centerBlockPos(blockPos, centerBlockPos);
            export = export + "\nBlock(" + centered.func_177958_n() + "," + centered.func_177956_o() + "," + centered.func_177952_p() + ",\"" + this.parseBlock(serverworld, blockPos, tileEntitySave) + "\");";
        }
        File f = new File(FMLPaths.GAMEDIR.get().resolve("wildnature/export/" + name + ".java").toString());
        if (f.exists()) {
            s4 = new StringTextComponent(TextFormatting.RED + "Cannot export " + TextFormatting.GOLD + name + ".java" + TextFormatting.RED + " - File already exist.");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s4));
            return 0;
        }
        try {
            new File(FMLPaths.GAMEDIR.get().resolve("wildnature/export/").toString()).mkdirs();
            f.createNewFile();
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(FMLPaths.GAMEDIR.get().resolve("wildnature/export/" + name + ".java").toString());
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(start);
            printWriter.print(export);
            printWriter.print(signature);
            printWriter.print(end);
            printWriter.close();
        }
        catch (IOException e) {
            StringTextComponent s43 = new StringTextComponent(TextFormatting.RED + "Cannot export " + TextFormatting.GOLD + name + ".java" + TextFormatting.RED + " - " + e.getLocalizedMessage());
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s43));
            return 0;
        }
        s4 = new StringTextComponent(TextFormatting.AQUA + "Successfully exported " + TextFormatting.GOLD + list.size() + TextFormatting.AQUA + " blocks to " + TextFormatting.GOLD + name + ".java" + TextFormatting.AQUA + ".");
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s4));
        StringTextComponent s5 = new StringTextComponent(TextFormatting.GREEN + "Click to open file");
        s5.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Click here")));
        s5.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getPath()));
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s5));
        return 1;
    }

    public BlockPos centerBlockPos(BlockPos pos, BlockPos zeroPos) {
        int x = this.center$1(Math.abs(zeroPos.func_177958_n() - pos.func_177958_n()), pos.func_177958_n(), zeroPos.func_177958_n());
        int y = this.center$1(Math.abs(zeroPos.func_177956_o() - pos.func_177956_o()), pos.func_177956_o(), zeroPos.func_177956_o());
        int z = this.center$1(Math.abs(zeroPos.func_177952_p() - pos.func_177952_p()), pos.func_177952_p(), zeroPos.func_177952_p());
        return new BlockPos(x, y, z);
    }

    private int center$1(int value, int pos, int zeroPos) {
        if (zeroPos <= pos) {
            return value;
        }
        return -value;
    }

    private String parseBlock(ServerWorld world, BlockPos pos, boolean saveTileEntity) {
        TileEntity e;
        BlockState state = world.func_180495_p(pos);
        String s = BlockStateParser.func_197247_a((BlockState)state);
        if (saveTileEntity && (e = world.func_175625_s(pos)) != null) {
            CompoundNBT nbt = e.func_189515_b(new CompoundNBT());
            s = s + nbt.toString().replace("\"", "\\\"");
        }
        return s;
    }
}

