/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.commands;

import com.matez.wildnature.Main;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;

public class ImportFromFile {
    private int brokenParts = 0;

    public int iimport(CommandContext<CommandSource> source, String file, BlockPos coords) throws CommandSyntaxException {
        StringTextComponent s4;
        ServerWorld world = ((CommandSource)source.getSource()).func_197023_e();
        this.brokenParts = 0;
        String name = file;
        if (!file.contains(".")) {
            name = name + ".java";
        }
        StringTextComponent s3 = new StringTextComponent(TextFormatting.AQUA + "Importing " + TextFormatting.GOLD + name + TextFormatting.AQUA + "...");
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s3));
        ArrayList<BlockStatePos> list = new ArrayList<BlockStatePos>();
        File f = new File(FMLPaths.GAMEDIR.get().resolve("wildnature/export/" + name).toString());
        if (!f.exists()) {
            StringTextComponent s42 = new StringTextComponent(TextFormatting.RED + "Unable to find " + TextFormatting.GOLD + name + TextFormatting.RED + ".");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s42));
            return 0;
        }
        try {
            Scanner s = new Scanner(f);
            while (s.hasNextLine()) {
                String line = s.nextLine();
                Object linex = line;
                if (!line.contains("Block(")) continue;
                try {
                    String x = ((String)linex).substring(((String)linex).indexOf("(") + 1, ((String)linex).indexOf(","));
                    linex = ((String)linex).replaceFirst(x + ",", "");
                    String y = ((String)linex).substring(((String)linex).indexOf("(") + 1, ((String)linex).indexOf(","));
                    linex = ((String)linex).replaceFirst(y + ",", "");
                    String z = ((String)linex).substring(((String)linex).indexOf("(") + 1, ((String)linex).indexOf(","));
                    linex = ((String)linex).replaceFirst(z + ",", "");
                    String blockstate = ((String)linex).substring(((String)linex).indexOf("(") + 1, ((String)linex).indexOf(")"));
                    blockstate = blockstate.substring(1, blockstate.length() - 1).replace("\\", "");
                    Main.LOGGER.info("Block: " + blockstate);
                    list.add(new BlockStatePos(this.parse(new StringReader(blockstate)), new BlockPos(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(z))));
                }
                catch (Exception e) {
                    ++this.brokenParts;
                }
            }
        }
        catch (FileNotFoundException e) {
            ++this.brokenParts;
        }
        if (list.isEmpty()) {
            s4 = new StringTextComponent(TextFormatting.RED + "Unable to decode file.");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s4));
            return 0;
        }
        if (this.brokenParts > 0) {
            s4 = new StringTextComponent(TextFormatting.RED + "Found " + TextFormatting.GOLD + this.brokenParts + TextFormatting.RED + " broken parts in this file.");
            Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s4));
        }
        StringTextComponent s6 = new StringTextComponent(TextFormatting.AQUA + "Generating " + TextFormatting.GOLD + list.size() + TextFormatting.AQUA + " blocks at ");
        StringTextComponent s7 = new StringTextComponent(TextFormatting.YELLOW + "" + coords.func_177958_n() + " " + coords.func_177956_o() + " " + coords.func_177952_p());
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s6).func_150257_a((ITextComponent)s7));
        for (BlockStatePos statePos : list) {
            try {
                BlockPos pos = new BlockPos(coords.func_177958_n() + statePos.getPos().func_177958_n(), coords.func_177956_o() + statePos.getPos().func_177956_o(), coords.func_177952_p() + statePos.getPos().func_177952_p());
                statePos.getState().func_197230_a(world, pos, 2);
            }
            catch (Exception e) {
                Main.LOGGER.warn((Object)e);
            }
        }
        StringTextComponent s43 = new StringTextComponent(TextFormatting.GREEN + "Operation succeed.");
        Main.sendChatMessage((PlayerEntity)((CommandSource)source.getSource()).func_197035_h(), new StringTextComponent("").func_150257_a((ITextComponent)Main.WNPrefix).func_150257_a((ITextComponent)s43));
        return 1;
    }

    public BlockStateInput parse(StringReader p_parse_1_) {
        try {
            BlockStateParser blockstateparser = new BlockStateParser(p_parse_1_, true).func_197243_a(true);
            return new BlockStateInput(blockstateparser.func_197249_b(), blockstateparser.func_197254_a().keySet(), blockstateparser.func_197241_c());
        }
        catch (Exception e) {
            ++this.brokenParts;
            return null;
        }
    }

    private static class BlockStatePos {
        private BlockStateInput state;
        private BlockPos pos;

        public BlockStatePos(BlockStateInput state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }

        public BlockStateInput getState() {
            return this.state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setPos(BlockPos pos) {
            this.pos = pos;
        }

        public void setState(BlockStateInput state) {
            this.state = state;
        }
    }
}

