/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.compatibility;

import com.google.common.collect.Maps;
import com.matez.wildnature.Main;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.lists.WNItems;
import com.matez.wildnature.registry.WoodRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class WNMinecraftCopatibility {
    public static void init() {
        Block[] b;
        for (String logType : WoodRegistry.logTypes) {
            b = (Block[])Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log"));
            Block s = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stripped_log"));
            Block bw = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_wood"));
            Block sw = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stripped_wood"));
            if (b == Blocks.field_150350_a) continue;
            WNMinecraftCopatibility.registerStrippable((Block)b, s);
            WNMinecraftCopatibility.registerStrippable(bw, sw);
        }
        for (String logType : WoodRegistry.logTypes) {
            for (Block block2 : b = new Block[]{(Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stripped_log")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_wood")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stripped_wood")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_branch")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_fence")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log_fence")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_planks")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_parquet")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_slab_planks")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_slab_parquet")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stairs_planks")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_stairs_parquet")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_fence_gate")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log_fence_gate")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_door")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_trapdoor")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_pressure_plate")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_button")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log_pressure_plate")), (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation("wildnature", logType + "_log_button"))}) {
                WNMinecraftCopatibility.registerFlammable(block2, 30, 60);
            }
        }
        WNMinecraftCopatibility.registerGrassPath(WNBlocks.BROWN_GRASS_BLOCK, WNBlocks.BROWN_GRASS_PATH);
        WNMinecraftCopatibility.registerGrassPath(WNBlocks.MOLD_GRASS_BLOCK, WNBlocks.MOLD_GRASS_PATH);
        WNMinecraftCopatibility.registerGrassPath(WNBlocks.DESERT_GRASS_BLOCK, WNBlocks.DESERT_GRASS_PATH);
        WNMinecraftCopatibility.registerGrassPath(WNBlocks.DRIED_GRASS_BLOCK, WNBlocks.DRIED_GRASS_PATH);
        WNMinecraftCopatibility.registerGrassPath(WNBlocks.TROPICAL_GRASS_BLOCK, WNBlocks.TROPICAL_GRASS_PATH);
        WNMinecraftCopatibility.registerFarmland("brown", WNBlocks.BROWN_FARMLAND);
        WNMinecraftCopatibility.registerFarmland("mold", WNBlocks.MOLD_FARMLAND);
        WNMinecraftCopatibility.registerFarmland("desert", WNBlocks.DESERT_FARMLAND);
        WNMinecraftCopatibility.registerFarmland("dried", WNBlocks.DRIED_FARMLAND);
        WNMinecraftCopatibility.registerFarmland("tropical", WNBlocks.TROPICAL_FARMLAND);
        WNBlocks.LEAVES.forEach(block -> WNMinecraftCopatibility.registerFlammable(block, 5, 5));
        WNBlocks.PLANTS.forEach(block -> WNMinecraftCopatibility.registerCompostable(0.65f, (IItemProvider)block));
        WNBlocks.SAPLINGS.forEach(block -> WNMinecraftCopatibility.registerCompostable(0.3f, (IItemProvider)block));
        WNBlocks.MUSHROOMS.forEach(block -> WNMinecraftCopatibility.registerCompostable(0.8f, (IItemProvider)block));
        WNItems.FOOD.forEach(block -> WNMinecraftCopatibility.registerCompostable(0.65f, (IItemProvider)block));
        WNBlocks.CROPS.forEach(block -> WNMinecraftCopatibility.registerCompostable(0.65f, (IItemProvider)block));
    }

    public static void registerStrippable(Block log, Block stripped_log) {
        if (log == Blocks.field_150350_a) {
            return;
        }
        AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
        AxeItem.field_203176_a.put(log, stripped_log);
    }

    public static void registerGrassPath(Block grass, Block path) {
        if (grass == Blocks.field_150350_a) {
            return;
        }
        ShovelItem.field_195955_e = Maps.newHashMap((Map)ShovelItem.field_195955_e);
        ShovelItem.field_195955_e.put(grass, path.func_176223_P());
    }

    public static void registerFarmland(String dirt, Block farmland) {
        if (farmland == Blocks.field_150350_a) {
            return;
        }
        Block db = Main.getBlockByID("wildnature:" + dirt + "_dirt");
        Block dp = Main.getBlockByID("wildnature:" + dirt + "_grass_path");
        Block dg = Main.getBlockByID("wildnature:" + dirt + "_grass_block");
        HoeItem.field_195973_b = Maps.newHashMap((Map)HoeItem.field_195973_b);
        HoeItem.field_195973_b.put(db, farmland.func_176223_P());
        HoeItem.field_195973_b = Maps.newHashMap((Map)HoeItem.field_195973_b);
        HoeItem.field_195973_b.put(dp, farmland.func_176223_P());
        HoeItem.field_195973_b = Maps.newHashMap((Map)HoeItem.field_195973_b);
        HoeItem.field_195973_b.put(dg, farmland.func_176223_P());
    }

    public static void registerCompostable(float chance, IItemProvider itemIn) {
        if (itemIn.func_199767_j() != Items.field_190931_a) {
            ComposterBlock.field_220299_b.put((Object)itemIn.func_199767_j(), chance);
        }
    }

    public static void registerFlammable(Block blockIn, int encouragement, int flammability) {
        if (blockIn == Blocks.field_150350_a) {
            return;
        }
        FireBlock fireblock = (FireBlock)Blocks.field_150480_ab;
        fireblock.func_180686_a(blockIn, encouragement, flammability);
    }
}

