/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.customizable;

import com.matez.wildnature.Main;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static CommonConfig instance;
    public final ForgeConfigSpec.Builder builder;
    public static ForgeConfigSpec.ConfigValue<String> currentVersion;
    public static ForgeConfigSpec.BooleanValue changePanorama;
    public static ForgeConfigSpec.BooleanValue newLoadingWorldScreen;
    public static ForgeConfigSpec.BooleanValue generateOnlyWildNature;
    public static ForgeConfigSpec.BooleanValue useWNOnServer;
    public static ForgeConfigSpec.DoubleValue riverDepth;
    public static ForgeConfigSpec.BooleanValue messageOnJoin;
    public static ForgeConfigSpec.BooleanValue effectOnJoin;
    public static ForgeConfigSpec.BooleanValue renderCapes;
    public static ForgeConfigSpec.BooleanValue playAmbientSounds;
    public static ForgeConfigSpec.BooleanValue replaceDefaultTrees;
    public static ForgeConfigSpec.BooleanValue generateUndergroundPlants;
    public static ForgeConfigSpec.BooleanValue generateRiverCanes;
    public static ForgeConfigSpec.BooleanValue generatePoisonIves;
    public static ForgeConfigSpec.BooleanValue generateCrystals;
    public static ForgeConfigSpec.BooleanValue generateStalagmites;
    public static ForgeConfigSpec.BooleanValue generatePebbles;
    public static ForgeConfigSpec.BooleanValue generateCobweb;
    public static ForgeConfigSpec.BooleanValue generateRockFormations;
    public static ForgeConfigSpec.BooleanValue generateFruitBushes;
    public static ForgeConfigSpec.BooleanValue generateVegeCrops;
    public static ForgeConfigSpec.BooleanValue generateVines;
    public static ForgeConfigSpec.BooleanValue generateSmallCacti;
    public static ForgeConfigSpec.BooleanValue generateShells;
    public static ForgeConfigSpec.BooleanValue generateMoss;
    public static ForgeConfigSpec.BooleanValue generateFallenTrees;
    public static ForgeConfigSpec.DoubleValue ambientSoundsVolume;
    public static ForgeConfigSpec.BooleanValue waterLakeGeneration;
    public static ForgeConfigSpec.BooleanValue lavaLakeGeneration;
    public static ForgeConfigSpec.BooleanValue waterSpringGeneration;
    public static ForgeConfigSpec.BooleanValue lavaSpringGeneration;
    public static ForgeConfigSpec.BooleanValue generateGlowingCaveOaks;
    public static ForgeConfigSpec.BooleanValue generateBigGlowshrooms;
    public static ForgeConfigSpec.IntValue biomeSize;
    public static ForgeConfigSpec.IntValue riverSize;
    public static ForgeConfigSpec.IntValue maxSearchRadius;
    public static ForgeConfigSpec.IntValue biomeGroupSpawningSize;
    public static ForgeConfigSpec.IntValue biomeGroupChance;
    public static ForgeConfigSpec.IntValue rockFormationChance;
    public static ForgeConfigSpec.BooleanValue generateOres;
    public static ForgeConfigSpec.BooleanValue generateRocks;
    public static ForgeConfigSpec.BooleanValue genBasalt;
    public static ForgeConfigSpec.BooleanValue genConglomerate;
    public static ForgeConfigSpec.BooleanValue genGneiss;
    public static ForgeConfigSpec.BooleanValue genLimestone;
    public static ForgeConfigSpec.BooleanValue genMarble;
    public static ForgeConfigSpec.BooleanValue genPegmatite;
    public static ForgeConfigSpec.BooleanValue genSlate;
    public static ForgeConfigSpec.IntValue rockChance;
    public static ForgeConfigSpec.IntValue rockSize;
    public static ForgeConfigSpec.DoubleValue steamMaxAge;
    public static ForgeConfigSpec.ConfigValue<String> blacklistBiome;
    public static ForgeConfigSpec.BooleanValue generateBiomes;
    public static ForgeConfigSpec.BooleanValue flowerDisappearsOnWalk;
    public static ForgeConfigSpec.BooleanValue poisonIvyHurts;
    public static ForgeConfigSpec.BooleanValue poisonIvyPoisons;
    public static ForgeConfigSpec.DoubleValue poisonIvyDamage;
    public static ForgeConfigSpec.IntValue leafFruitChance;
    public static ForgeConfigSpec.IntValue flowerBloomChance;
    public static ForgeConfigSpec.IntValue flowerDropChance;
    public static ForgeConfigSpec.IntValue fruitBushRarity;
    public static ForgeConfigSpec.IntValue vegeCropRarity;
    public static ForgeConfigSpec.IntValue mossRarity;
    public static ForgeConfigSpec.IntValue mossRarityDense;
    public static ForgeConfigSpec.IntValue riverCaneRarity;
    public static ForgeConfigSpec.IntValue smallCactiRarity;
    public static ForgeConfigSpec.IntValue poisonIvyRarity;
    public static ForgeConfigSpec.IntValue riverCaneDensity;
    public static ForgeConfigSpec.IntValue shellRarity;
    public static ForgeConfigSpec.IntValue tinRarity;
    public static ForgeConfigSpec.IntValue copperRarity;
    public static ForgeConfigSpec.IntValue amethystRarity;
    public static ForgeConfigSpec.IntValue sapphireRarity;
    public static ForgeConfigSpec.IntValue malachiteRarity;
    public static ForgeConfigSpec.IntValue silverRarity;
    public static ForgeConfigSpec.IntValue amberRarity;
    public static ForgeConfigSpec.IntValue rubyRarity;
    public static ForgeConfigSpec.IntValue saltSandRarity;
    public static ForgeConfigSpec.IntValue saltStoneRarity;
    public static ForgeConfigSpec.BooleanValue vegeFarmFence;
    public static ForgeConfigSpec.BooleanValue generatePaths;
    public static ForgeConfigSpec.BooleanValue generateUndergroundRivers;
    public static ForgeConfigSpec.DoubleValue pathFrequency;
    public static ForgeConfigSpec.IntValue tinOreHarvestLevel;
    public static ForgeConfigSpec.IntValue copperOreHarvestLevel;
    public static ForgeConfigSpec.IntValue amethystOreHarvestLevel;
    public static ForgeConfigSpec.IntValue sapphireOreHarvestLevel;
    public static ForgeConfigSpec.IntValue malachiteOreHarvestLevel;
    public static ForgeConfigSpec.IntValue silverOreHarvestLevel;
    public static ForgeConfigSpec.IntValue amberOreHarvestLevel;
    public static ForgeConfigSpec.IntValue rubyOreHarvestLevel;
    public static ForgeConfigSpec.BooleanValue vegeGrassSpawn;
    public static ForgeConfigSpec.IntValue vegeCropChance;
    public static ForgeConfigSpec.IntValue fruitBushChance;
    public static ArrayList<Biome> blacklistedBiomes;
    public static ForgeConfigSpec.ConfigValue<String> generatorType;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        instance = this;
        this.builder = builder;
        builder.comment("WildNature configuration file");
        this.general();
        this.generator();
        this.sound();
        this.block();
    }

    public static CommonConfig get() {
        return instance;
    }

    private void general() {
        this.builder.push("general");
        currentVersion = this.builder.comment("Installed mod version. Please do not change this.").define("system.version", (Object)"");
        maxSearchRadius = this.builder.comment("Max *nearest* biome search radius. After exceeding this number, WildNature will search for biome ignoring radius.\nDefault: 15000").defineInRange("system.max_search_radius", 15000, 10, 100000000);
        useWNOnServer = this.builder.comment("Always use WN World Generator on server?\nDefault:true").define("system.wn_server_gen", true);
        messageOnJoin = this.builder.comment("Send messages to users on join?\nDefault:true").define("system.message_on_join", true);
        effectOnJoin = this.builder.comment("Special effects on join?\nDefault:true").define("system.effect_on_join", true);
        renderCapes = this.builder.comment("Should render capes?\nDefault:true").define("system.render_capes", true);
        changePanorama = this.builder.comment("Should change main menu panorama?\nDefault:true").define("system.panorama", true);
        newLoadingWorldScreen = this.builder.comment("Use new world loading screen?\nDefault:true").define("system.worldLoadScreen", true);
        this.builder.pop();
    }

    private void generator() {
        this.builder.push("generator");
        generatorType = this.builder.comment("Generator version. \nAccepted Values: wildnature | wildnature-simplex").define("generatorType", (Object)"wildnature");
        biomeSize = this.builder.comment("Biome Size\nDefault: 5").defineInRange("biomeSize", 5, 1, 20);
        riverSize = this.builder.comment("River Size\nDefault: 4").defineInRange("riverSize", 4, 1, 20);
        generateOres = this.builder.comment("Generate Ores?\nDefault: true").define("ores.all", true);
        generateRocks = this.builder.comment("Generate Rocks?\nDefault: true").define("rocks.all", true);
        genBasalt = this.builder.comment("Generate Basalt?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.basalt", true);
        genConglomerate = this.builder.comment("Generate Conglomerate?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.conglomerate", true);
        genGneiss = this.builder.comment("Generate Gneiss?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.gneiss", true);
        genLimestone = this.builder.comment("Generate Limestone?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.limestone", true);
        genMarble = this.builder.comment("Generate Marble?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.marble", true);
        genPegmatite = this.builder.comment("Generate Pegmatite?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.pegmatite", true);
        genSlate = this.builder.comment("Generate Slate?\nIf you set generator.rocks.all to FALSE, changing this has no sense\nDefault: true").define("rocks.define.slate", true);
        rockChance = this.builder.comment("Chance of rock generation\nDefault: 33").defineInRange("rocks.chance", 33, 0, 100);
        rockSize = this.builder.comment("Rock deposit size\nDefault: 10").defineInRange("rocks.size", 10, 0, 100);
        riverDepth = this.builder.comment("Depth of all of rivers\nDefault: -1.0").defineInRange("biome.river.depth", -1.0, -10.0, 10.0);
        biomeGroupSpawningSize = this.builder.comment("Size of sub-biomes\nbigger sub-biomes = lower number\nDefault: 3").defineInRange("biome.group.size", 3, 1, 100);
        biomeGroupChance = this.builder.comment("Chance of sub-biome spawn\nDefault: 5").defineInRange("biome.group.chance", 5, 0, 10);
        rockFormationChance = this.builder.comment("Rock formation chance\nSmaller = more common\nDefault: 7").defineInRange("rocks.formation_chance", 7, 0, 10000);
        tinRarity = this.builder.comment("Tin ore rarity\nSmaller = more rare\nDefault: 8").defineInRange("ores.tin_rarity", 8, 0, 500);
        copperRarity = this.builder.comment("Copper ore rarity\nSmaller = more rare\nDefault: 8").defineInRange("ores.copper_rarity", 8, 0, 500);
        amethystRarity = this.builder.comment("Amethyst ore rarity\nSmaller = more rare\nDefault: 4").defineInRange("ores.amethyst_rarity", 4, 0, 500);
        sapphireRarity = this.builder.comment("Sapphire ore rarity\nSmaller = more rare\nDefault: 3").defineInRange("ores.sapphire_rarity", 3, 0, 500);
        malachiteRarity = this.builder.comment("Malachite ore rarity\nSmaller = more rare\nDefault: 2").defineInRange("ores.malachite_rarity", 2, 0, 500);
        silverRarity = this.builder.comment("Silver ore rarity\nSmaller = more rare\nDefault: 1").defineInRange("ores.silver_rarity", 1, 0, 500);
        amberRarity = this.builder.comment("Amber ore rarity. Ambers generates on beaches only!!!\nSmaller = more rare\nDefault: 3").defineInRange("ores.amber_rarity", 3, 0, 500);
        rubyRarity = this.builder.comment("Ruby ore rarity\nWarning - rubies are rare because they're generated only under oceans.\nSmaller = more rare\nDefault: 2").defineInRange("ores.ruby_rarity", 2, 0, 500);
        saltStoneRarity = this.builder.comment("Stone salt ore rarity\nSmaller = more rare\nDefault: 7").defineInRange("ores.salt_stone_rarity", 7, 0, 500);
        saltSandRarity = this.builder.comment("Sandy salt ore rarity\nSmaller = more rare\nDefault: 6").defineInRange("ores.salt_sand_rarity", 6, 0, 500);
        generateBiomes = this.builder.comment("Generate Biomes?\nDefault: true").define("biome.generate", true);
        generateOnlyWildNature = this.builder.comment("Generate only WildNature biomes?\nDefault: false").define("biome.generate_only_wildnature", false);
        blacklistBiome = this.builder.comment("Insert biome ids that shouldn't generate naturally. Example - wildnature:grasslands,wildnature:bog").define("biome.blacklist", (Object)"");
        replaceDefaultTrees = this.builder.comment("Replace vanilla trees with WildNature ones?\nDefault: true").define("biome.feature.replaceDefaultTrees", true);
        generateUndergroundPlants = this.builder.comment("Should generate cave plants like glowing mushrooms\nDefault: true").define("biome.feature.cavePlants", true);
        generateCrystals = this.builder.comment("Should generate crystals?\nDefault: true").define("biome.feature.crystals", true);
        generateStalagmites = this.builder.comment("Should generate stalagmites?\nDefault: true").define("biome.feature.stalagmites", true);
        generatePebbles = this.builder.comment("Should generate pebbles?\nDefault: true").define("biome.feature.pebbles", true);
        generateCobweb = this.builder.comment("Should generate cobweb?\nDefault: true").define("biome.feature.cobweb", true);
        generateRockFormations = this.builder.comment("Should generate rock formations?\nDefault: true").define("biome.feature.rock_formations", true);
        generateGlowingCaveOaks = this.builder.comment("Should generate glowing cave oaks?\nDefault: true").define("biome.feature.glowingCaveOaks", true);
        generateBigGlowshrooms = this.builder.comment("Should generate big glowshrooms?\nDefault: true").define("biome.feature.bigGlowshrooms", true);
        generatePoisonIves = this.builder.comment("Should generate poison ives & spidergrass?\nDefault: true").define("biome.feature.special_plants", true);
        generateFruitBushes = this.builder.comment("Should generate fruit bushes?\nDefault: true").define("biome.feature.fruit_bushes", true);
        generateVegeCrops = this.builder.comment("Should generate vege crops?\nDefault: true").define("biome.feature.vege_crops", true);
        generateVines = this.builder.comment("Should generate vines?\nDefault: true").define("biome.feature.vines", true);
        generateRiverCanes = this.builder.comment("Should generate river cane?\nDefault: true").define("biome.feature.river_cane", true);
        generateSmallCacti = this.builder.comment("Should generate small cacti?\nDefault: true").define("biome.feature.small_cacti", true);
        generateShells = this.builder.comment("Should generate shells?\nDefault: true").define("biome.feature.shells", true);
        generateMoss = this.builder.comment("Should generate moss?\nDefault: true").define("biome.feature.moss", true);
        generateFallenTrees = this.builder.comment("Should generate fallen trees?\nDefault: true").define("biome.feature.fallenTrees", true);
        vegeFarmFence = this.builder.comment("Should generate fences near wild farms?\nDefault: true").define("biome.feature.vege_farm_fence", true);
        fruitBushRarity = this.builder.comment("Fruit bushes spawn rarity\nSmaller = more rare\nDefault: 3").defineInRange("biome.feature.fruit_bushes_rarity", 3, 0, 500);
        vegeCropRarity = this.builder.comment("Vegetable crops spawn rarity\nSmaller = more rare\nDefault: 2").defineInRange("biome.feature.vege_crops_rarity", 2, 0, 500);
        fruitBushChance = this.builder.comment("Fruit bush spawn chance. Spawns if random from 0 and <number> equals 0\nSmaller = more common\nDefault: 2").defineInRange("biome.feature.fruit_bushes_chance", 2, 0, 500);
        vegeCropChance = this.builder.comment("Vege Crop spawn chance. Spawns if random from 0 and <number> equals 0\nSmaller = more common\nDefault: 1").defineInRange("biome.feature.fruit_bushes_chance", 1, 0, 500);
        poisonIvyRarity = this.builder.comment("Posion ivy & spidergrass & thistle & nettle rarity\nSmaller = more rare\nDefault: 2").defineInRange("biome.feature.ivy_rarity", 2, 0, 500);
        riverCaneRarity = this.builder.comment("River cane rarity\nSmaller = more rare\nDefault: 50").defineInRange("biome.feature.river_cane_rarity", 50, 0, 500);
        riverCaneDensity = this.builder.comment("River cane density\nSmaller = less\nDefault: 50").defineInRange("biome.feature.river_cane_density", 64, 0, 500);
        smallCactiRarity = this.builder.comment("Small cacti rarity\nSmaller = more rare\nDefault: 5").defineInRange("biome.feature.small_cacti_rarity", 5, 0, 500);
        shellRarity = this.builder.comment("Shell generation rarity\nSmaller = more rare\nDefault: 6").defineInRange("biome.feature.shell_rarity", 6, 0, 500);
        mossRarity = this.builder.comment("Moss spawn rarity in forests\nSmaller = more rare\nDefault: 4").defineInRange("biome.feature.moss_rarity", 4, 0, 500);
        mossRarityDense = this.builder.comment("Moss spawn rarity in dense forests\nSmaller = more rare\nDefault: 8").defineInRange("biome.feature.moss_rarity_dense", 8, 0, 500);
        generatePaths = this.builder.comment("Should generate pathways?\nDefault: true").define("biome.feature.pathways", true);
        generateUndergroundRivers = this.builder.comment("Generate underground rivers?\nDefault: true").define("biome.feature.undergroundRivers", true);
        pathFrequency = this.builder.comment("Pathway noise frequency\nDefault: 0.005").defineInRange("biome.feature.pathway_frequency", 0.005, 1.0E-5, 100.0);
        waterLakeGeneration = this.builder.comment("Should generate water lakes?\nDefault: true").define("biome.feature.waterLakeGeneration", true);
        lavaLakeGeneration = this.builder.comment("Should generate lava lakes?\nDefault: true").define("biome.feature.lavaLakeGeneration", true);
        waterSpringGeneration = this.builder.comment("Should generate water springs?\nDefault: true").define("biome.feature.waterSpringGeneration", true);
        lavaSpringGeneration = this.builder.comment("Should generate lava springs?\nDefault: true").define("biome.feature.lavaSpringGeneration", true);
        this.builder.pop();
    }

    private void sound() {
        this.builder.push("sound");
        playAmbientSounds = this.builder.comment("[W.I.P] Play ambient sounds on biomes?").define("play_ambient", true);
        ambientSoundsVolume = this.builder.comment("[W.I.P] Ambient sounds volume").defineInRange("volume_ambient", 1.0, 0.1, 1.0);
        this.builder.pop();
    }

    private void block() {
        this.builder.push("block");
        steamMaxAge = this.builder.comment("Steam Particle max age multiplier - how long does steam live\nDefault: 10.0").defineInRange("steam_max_age", 10.0, 1.0, 100.0);
        flowerDisappearsOnWalk = this.builder.comment("Flower disappears on walk?\nDefault: true").define("flowerDisappears", true);
        poisonIvyHurts = this.builder.comment("Poison ivy hurts on walk?\nDefault: true").define("poisonIvyHurts", true);
        poisonIvyPoisons = this.builder.comment("Poison ivy poisons on walk?\nDefault: true").define("poisonIvyPoison", true);
        poisonIvyDamage = this.builder.comment("Poison ivy damage?\nDefault: 0.5").defineInRange("poisonIvyDamage", 0.5, 0.0, 1000.0);
        leafFruitChance = this.builder.comment("Leaf fruit chance\nDefault: 10").defineInRange("leafFruitChance", 10, 0, 1000);
        flowerBloomChance = this.builder.comment("Flower bloom chance (Bone meal)\nDefault: 10").defineInRange("flowerBloomChance", 10, 0, 1000);
        flowerDropChance = this.builder.comment("Flower drop chance\nDefault: 2").defineInRange("flowerDropChance", 2, 0, 1000);
        tinOreHarvestLevel = this.builder.comment("Tin ore harvest level\nDefault: 1").defineInRange("ore.tinOreHarvestLevel", 1, 0, 100);
        copperOreHarvestLevel = this.builder.comment("Copper ore harvest level\nDefault: 1").defineInRange("ore.copperOreHarvestLevel", 1, 0, 100);
        amethystOreHarvestLevel = this.builder.comment("Amethyst ore harvest level\nDefault: 2").defineInRange("ore.amethystOreHarvestLevel", 2, 0, 100);
        sapphireOreHarvestLevel = this.builder.comment("Sapphire ore harvest level\nDefault: 3").defineInRange("ore.sapphireOreHarvestLevel", 3, 0, 100);
        malachiteOreHarvestLevel = this.builder.comment("Malachite ore harvest level\nDefault: 3").defineInRange("ore.malachiteOreHarvestLevel", 3, 0, 100);
        silverOreHarvestLevel = this.builder.comment("Silver ore harvest level\nDefault: 3").defineInRange("ore.silverOreHarvestLevel", 3, 0, 100);
        amberOreHarvestLevel = this.builder.comment("Amber ore harvest level\nDefault: 3").defineInRange("ore.amberOreHarvestLevel", 3, 0, 100);
        rubyOreHarvestLevel = this.builder.comment("Ruby ore harvest level\nDefault: 4").defineInRange("ore.rubyOreHarvestLevel", 4, 0, 100);
        vegeGrassSpawn = this.builder.comment("Can all veggies normally spawn on normal grass?\nDefault: false").define("vegeGrassSpawn", false);
        this.builder.pop();
    }

    public static void compile() {
        ArrayList<String> strings = new ArrayList<String>(Arrays.asList(((String)blacklistBiome.get()).replace(" ", "").split(",")));
        Main.LOGGER.debug("Initializing biome blacklist module...\nValues: " + strings.toString() + "\nRaw values: " + (String)blacklistBiome.get());
        for (String s : strings) {
            try {
                s = s + "";
                Main.LOGGER.debug("Blacklisting " + s + "...");
                Biome b = Main.getBiomeByID(s);
                if (b != Biomes.field_180279_ad) {
                    Main.LOGGER.debug("Blacklisted Biome: " + b.getRegistryName());
                    blacklistedBiomes.add(b);
                    continue;
                }
                Main.LOGGER.debug("Invalid Blacklisted Biome: " + b.getRegistryName());
            }
            catch (Exception e) {
                Main.LOGGER.debug("Invalid Blacklisted Biome: " + s + "");
            }
        }
    }

    static {
        blacklistedBiomes = new ArrayList();
    }
}

