/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity.AI;

import com.matez.wildnature.Main;
import com.matez.wildnature.entity.type.animal.IFamily;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.Stats;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class FamilyBreedGoal
extends Goal {
    private static final EntityPredicate predicate = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c();
    protected final AnimalEntity animal;
    private final Class<? extends AnimalEntity> mateClass;
    protected final World world;
    protected AnimalEntity mateWithEntity;
    private int spawnBabyDelay;
    private final double moveSpeed;
    private final IFamily.Gender gender;

    public FamilyBreedGoal(AnimalEntity animal, double speedIn, IFamily.Gender gender) {
        this(animal, speedIn, animal.getClass(), gender);
    }

    public FamilyBreedGoal(AnimalEntity entity, double moveSpeed, Class<? extends AnimalEntity> clazz, IFamily.Gender gender) {
        this.animal = entity;
        this.world = entity.field_70170_p;
        this.mateClass = clazz;
        this.moveSpeed = moveSpeed;
        this.gender = gender;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70880_s()) {
            return false;
        }
        this.mateWithEntity = this.getNearbyMate();
        return this.mateWithEntity != null;
    }

    public boolean func_75253_b() {
        return this.mateWithEntity.func_70089_S() && this.mateWithEntity.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.mateWithEntity = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.animal.func_70671_ap().func_75651_a((Entity)this.mateWithEntity, 10.0f, (float)this.animal.func_70646_bf());
        this.animal.func_70661_as().func_75497_a((Entity)this.mateWithEntity, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.animal.func_70068_e((Entity)this.mateWithEntity) < 9.0) {
            this.spawnBaby();
        }
    }

    @Nullable
    private AnimalEntity getNearbyMate() {
        List list = this.world.func_217374_a(this.mateClass, predicate, (LivingEntity)this.animal, this.animal.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        AnimalEntity animalentity = null;
        for (AnimalEntity animalentity1 : list) {
            if (!this.animal.func_70878_b(animalentity1) || !(this.animal.func_70068_e((Entity)animalentity1) < d0)) continue;
            animalentity = animalentity1;
            d0 = this.animal.func_70068_e((Entity)animalentity1);
        }
        return animalentity;
    }

    protected void spawnBaby() {
        Main.LOGGER.debug("Spawning babe");
        AgeableEntity ageableentity = this.animal.func_90011_a((AgeableEntity)this.mateWithEntity);
        AnimalEntity mother = null;
        AnimalEntity father = null;
        if (((IFamily)this.animal).getGender() == IFamily.Gender.MALE) {
            mother = this.mateWithEntity;
            father = this.animal;
        } else {
            mother = this.animal;
            father = this.mateWithEntity;
        }
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)mother, (MobEntity)father, ageableentity);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        ageableentity = event.getChild();
        if (cancelled) {
            this.animal.func_70873_a(6000);
            this.mateWithEntity.func_70873_a(6000);
            this.animal.func_70875_t();
            this.mateWithEntity.func_70875_t();
            return;
        }
        if (ageableentity != null) {
            Main.LOGGER.debug("Spawning babe2");
            ServerPlayerEntity serverplayerentity = this.animal.func_191993_do();
            if (serverplayerentity == null && this.mateWithEntity.func_191993_do() != null) {
                serverplayerentity = this.mateWithEntity.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, mother, father, ageableentity);
            }
            this.animal.func_70873_a(6000);
            this.mateWithEntity.func_70873_a(6000);
            this.animal.func_70875_t();
            this.mateWithEntity.func_70875_t();
            ageableentity.func_70873_a(-24000);
            ageableentity.func_70012_b(mother.field_70165_t, mother.field_70163_u, mother.field_70161_v, 0.0f, 0.0f);
            this.world.func_217376_c((Entity)ageableentity);
            this.world.func_72960_a((Entity)mother, (byte)18);
            if (this.world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.world.func_217376_c((Entity)new ExperienceOrbEntity(this.world, this.animal.field_70165_t, this.animal.field_70163_u, this.animal.field_70161_v, mother.func_70681_au().nextInt(7) + 1));
            }
            Main.LOGGER.debug("Spawned");
        }
    }
}

