/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity;

import com.matez.wildnature.entity.type.animal.bird.SparrowEntity;
import com.matez.wildnature.entity.type.animal.boar.BoarEntity;
import com.matez.wildnature.entity.type.animal.deer.AbstractDeerEntity;
import com.matez.wildnature.entity.type.animal.deer.BuckEntity;
import com.matez.wildnature.entity.type.animal.deer.DoeEntity;
import com.matez.wildnature.entity.type.animal.deer.FawnEntity;
import com.matez.wildnature.entity.type.animal.duck.AbstractDuckEntity;
import com.matez.wildnature.entity.type.animal.duck.DrakeEntity;
import com.matez.wildnature.entity.type.animal.duck.DuckEntity;
import com.matez.wildnature.entity.type.animal.duck.DucklingEntity;
import com.matez.wildnature.entity.type.animal.fish.PiranhaEntity;
import com.matez.wildnature.entity.type.animal.insect.DragonflyEntity;
import com.matez.wildnature.entity.type.monster.GoblinEntity;
import com.matez.wildnature.gui.tileEntities.seat.SeatEntity;
import com.matez.wildnature.lists.WNItems;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityRegistry {
    public static EntityType<GoblinEntity> GOBLIN = (EntityType)EntityType.Builder.func_220322_a(GoblinEntity::new, (EntityClassification)EntityClassification.MONSTER).func_206830_a("wildnature:goblin").setRegistryName("wildnature:goblin");
    public static EntityType<AbstractDuckEntity> DRAKE = (EntityType)EntityType.Builder.func_220322_a(DrakeEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_206830_a("wildnature:drake").setRegistryName("wildnature:drake");
    public static EntityType<AbstractDuckEntity> DUCK = (EntityType)EntityType.Builder.func_220322_a(DuckEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_206830_a("wildnature:duck").setRegistryName("wildnature:duck");
    public static EntityType<AbstractDuckEntity> DUCKLING = (EntityType)EntityType.Builder.func_220322_a(DucklingEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.2f, 0.3f).func_206830_a("wildnature:duckling").setRegistryName("wildnature:duckling");
    public static EntityType<AbstractDeerEntity> BUCK = (EntityType)EntityType.Builder.func_220322_a(BuckEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 2.2f).func_206830_a("wildnature:buck").setRegistryName("wildnature:buck");
    public static EntityType<AbstractDeerEntity> DOE = (EntityType)EntityType.Builder.func_220322_a(DoeEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 2.2f).func_206830_a("wildnature:doe").setRegistryName("wildnature:doe");
    public static EntityType<AbstractDeerEntity> FAWN = (EntityType)EntityType.Builder.func_220322_a(FawnEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 1.7f).func_206830_a("wildnature:fawn").setRegistryName("wildnature:fawn");
    public static EntityType<BoarEntity> BOAR = (EntityType)EntityType.Builder.func_220322_a(BoarEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 1.0f).func_206830_a("wildnature:boar").setRegistryName("wildnature:boar");
    public static EntityType<PiranhaEntity> PIRANHA = (EntityType)EntityType.Builder.func_220322_a(PiranhaEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.9f).func_206830_a("wildnature:piranha").setRegistryName("wildnature:piranha");
    public static EntityType<DragonflyEntity> DRAGONFLY = (EntityType)EntityType.Builder.func_220322_a(DragonflyEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.2f, 0.3f).func_206830_a("wildnature:dragonfly").setRegistryName("wildnature:dragonfly");
    public static EntityType<SparrowEntity> SPARROW_MALE = (EntityType)EntityType.Builder.func_220322_a(SparrowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.3f, 0.4f).func_206830_a("wildnature:sparrow_male").setRegistryName("wildnature:sparrow_female");
    public static EntityType<SeatEntity> SEAT = (EntityType)EntityType.Builder.func_220322_a(SeatEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.3f, 0.4f).func_206830_a("wildnature:seat").setRegistryName("wildnature:seat");

    public static void registerSpawningEggs(RegistryEvent.Register<Item> register) {
        WNItems.GOBLIN_EGG = EntityRegistry.registerSpawningEggs(GOBLIN, 7105879, 6508854, "goblin_egg");
        WNItems.DRAKE_EGG = EntityRegistry.registerSpawningEggs(DRAKE, 2778149, 4337451, "drake_egg");
        WNItems.DUCK_EGG = EntityRegistry.registerSpawningEggs(DUCK, 0x636363, 0x515151, "duck_egg");
        register.getRegistry().registerAll((IForgeRegistryEntry[])EntityRegistry.registerSpawningEggs());
    }

    public static Item[] registerSpawningEggs() {
        return new Item[0];
    }

    public static Item registerSpawningEggs(EntityType<?> type, int color1, int color2, String name) {
        SpawnEggItem item = new SpawnEggItem(type, color1, color2, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        item.setRegistryName(name);
        return item;
    }

    public static void registerEntitySpawns() {
        ArrayList biomes = new ArrayList();
        Registry.field_212624_m.forEach(biomes::add);
    }

    public static void registerEntitySpawns(EntityType<?> type, int weight, int max, int min, EntityClassification e, Biome ... biomes) {
        Arrays.asList(biomes).forEach(biome -> {
            if (biome != null) {
                biome.func_76747_a(e).add(new Biome.SpawnListEntry(type, weight, min, max));
            }
        });
    }
}

