/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity.render.animal;

import com.matez.wildnature.Main;
import com.matez.wildnature.entity.model.animal.DragonflyModel;
import com.matez.wildnature.entity.type.animal.insect.DragonflyEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class DragonflyRender
extends MobRenderer<DragonflyEntity, DragonflyModel> {
    public DragonflyRender(EntityRendererManager manager) {
        super(manager, (EntityModel)new DragonflyModel(), 0.2f);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(DragonflyEntity entity) {
        if (entity.getVariant() == null) {
            return Main.RegistryEvents.location("textures/entity/" + DragonflyEntity.DragonFlyVariant.BLUE.getPath());
        }
        return Main.RegistryEvents.location("textures/entity/" + entity.getVariant().getPath());
    }

    public static class RenderFactory
    implements IRenderFactory<DragonflyEntity> {
        public EntityRenderer<? super DragonflyEntity> createRenderFor(EntityRendererManager manager) {
            return new DragonflyRender(manager);
        }
    }
}

