/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.entity.type.animal.insect;

import com.matez.wildnature.entity.AI.BushFlyingGoal;
import com.matez.wildnature.entity.AI.Movement.InsectFlyingMovementController;
import com.matez.wildnature.entity.EntityRegistry;
import com.matez.wildnature.other.Utilities;
import com.matez.wildnature.sounds.SoundRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class DragonflyEntity
extends AnimalEntity
implements IFlyingAnimal {
    public Predicate<LivingEntity> predicate = new Predicate<LivingEntity>(){

        @Override
        public boolean test(LivingEntity entity) {
            return true;
        }
    };
    private boolean canMove = true;
    private DragonFlyVariant variant = null;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;

    public DragonflyEntity(EntityType<? extends DragonflyEntity> boar, World world) {
        super(boar, world);
        this.field_70765_h = new InsectFlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.randomVariant();
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public DragonFlyVariant getVariant() {
        return this.variant;
    }

    public DragonflyEntity(World worldIn) {
        super(EntityRegistry.DRAGONFLY, worldIn);
        this.field_70765_h = new InsectFlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BushFlyingGoal((CreatureEntity)this, 2.4, 26, 1, 10));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a((double)1.4f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(26.0);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }

            public void func_75501_e() {
                if (DragonflyEntity.this.canMove) {
                    super.func_75501_e();
                }
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.5f : sizeIn.field_220316_b * 0.5f;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.field_70122_E && !this.func_184218_aH() ? 4 : -1) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.calculateFlapping();
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public void func_180430_e(float p_180430_1_, float p_180430_2_) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_180466_bG(Tag<Fluid> fluidTag) {
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundRegistry.DRAGONFLY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.DRAGONFLY_HURT;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected float func_191954_d(float volume) {
        this.func_184185_a(SoundRegistry.DRAGONFLY_FLAP, 0.15f, 1.0f);
        return volume + this.flapSpeed / 2.0f;
    }

    public void randomVariant() {
        int variant = Utilities.rint(0, 4);
        this.variant = DragonFlyVariant.values()[variant];
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("variant", this.variant.func_176610_l());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("variant")) {
            this.variant = DragonFlyVariant.valueOf(nbt.func_74779_i("variant").toUpperCase());
        } else if (this.variant == null) {
            this.randomVariant();
        }
    }

    public static enum DragonFlyVariant implements IStringSerializable
    {
        BLUE("blue", "dragon_fly_blue.png"),
        GREEN("green", "dragon_fly_green.png"),
        RED("red", "dragon_fly_red.png"),
        BROWN("brown", "dragon_fly_brown.png"),
        YELLOW("yellow", "dragon_fly_yellow.png");

        private String name;
        private String path;

        private DragonFlyVariant(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }
    }
}

