/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.gui.screen;

import com.google.common.collect.Lists;
import com.matez.wildnature.commands.DungeonCommanderLogic;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractDungeonCommanderScreen
extends Screen {
    protected TextFieldWidget commandTextField;
    protected TextFieldWidget resultTextField;
    protected Button doneButton;
    protected Button cancelButton;
    protected Button trackOutputButton;
    protected boolean field_195238_s;
    protected final List<String> field_209111_t = Lists.newArrayList();
    protected int field_209112_u;
    protected int field_209113_v;
    protected ParseResults<ISuggestionProvider> field_209114_w;
    protected CompletableFuture<Suggestions> field_209115_x;
    protected SuggestionsList suggestionList;
    private boolean field_212342_z;

    public AbstractDungeonCommanderScreen() {
        super(NarratorChatListener.field_216868_a);
    }

    public void tick() {
        this.commandTextField.func_146178_a();
    }

    public abstract DungeonCommanderLogic getLogic();

    public abstract int func_195236_i();

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.doneButton = (Button)this.addButton((Widget)new Button(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), p_214187_1_ -> this.func_195234_k()));
        this.cancelButton = (Button)this.addButton((Widget)new Button(this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), p_214186_1_ -> this.onClose()));
        this.trackOutputButton = (Button)this.addButton((Widget)new Button(this.width / 2 + 150 - 20, this.func_195236_i(), 20, 20, "O", p_214184_1_ -> {
            DungeonCommanderLogic commandblocklogic;
            commandblocklogic.func_175573_a(!(commandblocklogic = this.getLogic()).func_175571_m());
            this.updateTrackOutput();
        }));
        this.commandTextField = new TextFieldWidget(this.font, this.width / 2 - 150, 50, 300, 20, I18n.func_135052_a((String)"advMode.command", (Object[])new Object[0]));
        this.commandTextField.func_146203_f(32500);
        this.commandTextField.func_195607_a(this::formatCommand);
        this.commandTextField.func_212954_a(this::func_214185_b);
        this.children.add(this.commandTextField);
        this.resultTextField = new TextFieldWidget(this.font, this.width / 2 - 150, this.func_195236_i(), 276, 20, I18n.func_135052_a((String)"advMode.previousOutput", (Object[])new Object[0]));
        this.resultTextField.func_146203_f(32500);
        this.resultTextField.func_146184_c(false);
        this.resultTextField.func_146180_a("-");
        this.children.add(this.resultTextField);
        this.func_212928_a((IGuiEventListener)this.commandTextField);
        this.commandTextField.func_146195_b(true);
        this.computeSuggestions();
    }

    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String s = this.commandTextField.func_146179_b();
        this.init(p_resize_1_, p_resize_2_, p_resize_3_);
        this.setCommand(s);
        this.computeSuggestions();
    }

    protected void updateTrackOutput() {
        if (this.getLogic().func_175571_m()) {
            this.trackOutputButton.setMessage("O");
            this.resultTextField.func_146180_a(this.getLogic().func_145749_h().getString());
        } else {
            this.trackOutputButton.setMessage("X");
            this.resultTextField.func_146180_a("-");
        }
    }

    protected void func_195234_k() {
        DungeonCommanderLogic commandblocklogic = this.getLogic();
        this.func_195235_a(commandblocklogic);
        if (!commandblocklogic.func_175571_m()) {
            commandblocklogic.func_145750_b(null);
        }
        this.minecraft.func_147108_a((Screen)null);
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    protected abstract void func_195235_a(CommandBlockLogic var1);

    public void onClose() {
        this.getLogic().func_175573_a(this.field_195238_s);
        this.minecraft.func_147108_a((Screen)null);
    }

    private void func_214185_b(String p_214185_1_) {
        this.computeSuggestions();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.suggestionList != null && this.suggestionList.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (this.getFocused() == this.commandTextField && p_keyPressed_1_ == 258) {
            this.func_209109_s();
            return true;
        }
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            if (p_keyPressed_1_ == 258 && this.getFocused() == this.commandTextField) {
                this.func_209109_s();
            }
            return false;
        }
        this.func_195234_k();
        return true;
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.suggestionList != null && this.suggestionList.mouseScrolled(MathHelper.func_151237_a((double)p_mouseScrolled_5_, (double)-1.0, (double)1.0)) ? true : super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return this.suggestionList != null && this.suggestionList.mouseClicked((int)p_mouseClicked_1_, (int)p_mouseClicked_3_, p_mouseClicked_5_) ? true : super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    protected void computeSuggestions() {
        int j;
        String s = this.commandTextField.func_146179_b();
        if (this.field_209114_w != null && !this.field_209114_w.getReader().getString().equals(s)) {
            this.field_209114_w = null;
        }
        if (!this.field_212342_z) {
            this.commandTextField.func_195612_c((String)null);
            this.suggestionList = null;
        }
        this.field_209111_t.clear();
        CommandDispatcher commanddispatcher = this.minecraft.field_71439_g.field_71174_a.func_195515_i();
        StringReader stringreader = new StringReader(s);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        int i = stringreader.getCursor();
        if (this.field_209114_w == null) {
            this.field_209114_w = commanddispatcher.parse(stringreader, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
        }
        if (!((j = this.commandTextField.func_146198_h()) < i || this.suggestionList != null && this.field_212342_z)) {
            this.field_209115_x = commanddispatcher.getCompletionSuggestions(this.field_209114_w, j);
            this.field_209115_x.thenRun(() -> {
                if (this.field_209115_x.isDone()) {
                    this.func_209107_u();
                }
            });
        }
    }

    private void func_209107_u() {
        if (this.field_209115_x.join().isEmpty() && !this.field_209114_w.getExceptions().isEmpty() && this.commandTextField.func_146198_h() == this.commandTextField.func_146179_b().length()) {
            int i = 0;
            for (Map.Entry entry : this.field_209114_w.getExceptions().entrySet()) {
                CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)((Object)entry.getValue());
                if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                    ++i;
                    continue;
                }
                this.field_209111_t.add(commandsyntaxexception.getMessage());
            }
            if (i > 0) {
                this.field_209111_t.add(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create().getMessage());
            }
        }
        this.field_209112_u = 0;
        this.field_209113_v = this.width;
        if (this.field_209111_t.isEmpty()) {
            this.func_209108_a(TextFormatting.GRAY);
        }
        this.suggestionList = null;
        if (this.minecraft.field_71474_y.field_198018_T) {
            this.func_209109_s();
        }
    }

    private String formatCommand(String p_209104_1_, int p_209104_2_) {
        return this.field_209114_w != null ? ChatScreen.func_212336_a(this.field_209114_w, (String)p_209104_1_, (int)p_209104_2_) : p_209104_1_;
    }

    private void func_209108_a(TextFormatting p_209108_1_) {
        CommandContextBuilder commandcontextbuilder = this.field_209114_w.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.commandTextField.func_146198_h());
        Map map = this.minecraft.field_71439_g.field_71174_a.func_195515_i().getSmartUsage(suggestioncontext.parent, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(p_209108_1_ + (String)entry.getValue());
            i = Math.max(i, this.font.func_78256_a((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.field_209111_t.addAll(list);
            this.field_209112_u = MathHelper.func_76125_a((int)this.commandTextField.func_195611_j(suggestioncontext.startPos), (int)0, (int)(this.commandTextField.func_195611_j(0) + this.commandTextField.func_146200_o() - i));
            this.field_209113_v = i;
        }
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        try {
            this.renderBackground();
        }
        catch (NullPointerException e) {
            System.out.println("Cannot render DungeonCommander!");
        }
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"advMode.setCommand", (Object[])new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.font, I18n.func_135052_a((String)"advMode.command", (Object[])new Object[0]), this.width / 2 - 150, 40, 0xA0A0A0);
        this.commandTextField.render(p_render_1_, p_render_2_, p_render_3_);
        int i = 75;
        if (!this.resultTextField.func_146179_b().isEmpty()) {
            this.drawString(this.font, I18n.func_135052_a((String)"advMode.previousOutput", (Object[])new Object[0]), this.width / 2 - 150, (i += 46 + this.func_195236_i() - 135) + 4, 0xA0A0A0);
            this.resultTextField.render(p_render_1_, p_render_2_, p_render_3_);
        }
        super.render(p_render_1_, p_render_2_, p_render_3_);
        if (this.suggestionList != null) {
            this.suggestionList.render(p_render_1_, p_render_2_);
        } else {
            i = 0;
            for (String s : this.field_209111_t) {
                AbstractDungeonCommanderScreen.fill((int)(this.field_209112_u - 1), (int)(72 + 12 * i), (int)(this.field_209112_u + this.field_209113_v + 1), (int)(84 + 12 * i), (int)Integer.MIN_VALUE);
                this.font.func_175063_a(s, (float)this.field_209112_u, (float)(74 + 12 * i), -1);
                ++i;
            }
        }
    }

    public void func_209109_s() {
        Suggestions suggestions;
        if (this.field_209115_x != null && this.field_209115_x.isDone() && !(suggestions = this.field_209115_x.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.func_78256_a(suggestion.getText()));
            }
            int j = MathHelper.func_76125_a((int)this.commandTextField.func_195611_j(suggestions.getRange().getStart()), (int)0, (int)(this.commandTextField.func_195611_j(0) + this.commandTextField.func_146200_o() - i));
            this.suggestionList = new SuggestionsList(j, 72, i, suggestions);
        }
    }

    protected void setCommand(String p_209102_1_) {
        this.commandTextField.func_146180_a(p_209102_1_);
    }

    @Nullable
    private static String func_212339_b(String p_212339_0_, String p_212339_1_) {
        return p_212339_1_.startsWith(p_212339_0_) ? p_212339_1_.substring(p_212339_0_.length()) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    class SuggestionsList {
        private final Rectangle2d bounds;
        private final Suggestions suggestions;
        private final String field_212467_d;
        private int scrollAmount;
        private int selectedSuggestion;
        private Vec2f lastMousePosition = Vec2f.field_189974_a;
        private boolean field_209141_h;

        private SuggestionsList(int p_i49843_2_, int p_i49843_3_, int p_i49843_4_, Suggestions p_i49843_5_) {
            this.bounds = new Rectangle2d(p_i49843_2_ - 1, p_i49843_3_, p_i49843_4_ + 1, Math.min(p_i49843_5_.getList().size(), 7) * 12);
            this.suggestions = p_i49843_5_;
            this.field_212467_d = AbstractDungeonCommanderScreen.this.commandTextField.func_146179_b();
            this.suggest(0);
        }

        public void render(int mouseX, int mouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestions.getList().size(), 7);
            int j = Integer.MIN_VALUE;
            int k = -5592406;
            boolean flag = this.scrollAmount > 0;
            boolean flag1 = this.suggestions.getList().size() > this.scrollAmount + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMousePosition.field_189982_i != (float)mouseX || this.lastMousePosition.field_189983_j != (float)mouseY;
            if (flag3) {
                this.lastMousePosition = new Vec2f((float)mouseX, (float)mouseY);
            }
            if (flag2) {
                AbstractGui.fill((int)this.bounds.func_199318_a(), (int)(this.bounds.func_199319_b() - 1), (int)(this.bounds.func_199318_a() + this.bounds.func_199316_c()), (int)this.bounds.func_199319_b(), (int)Integer.MIN_VALUE);
                AbstractGui.fill((int)this.bounds.func_199318_a(), (int)(this.bounds.func_199319_b() + this.bounds.func_199317_d()), (int)(this.bounds.func_199318_a() + this.bounds.func_199316_c()), (int)(this.bounds.func_199319_b() + this.bounds.func_199317_d() + 1), (int)Integer.MIN_VALUE);
                if (flag) {
                    for (int l = 0; l < this.bounds.func_199316_c(); ++l) {
                        if (l % 2 != 0) continue;
                        AbstractGui.fill((int)(this.bounds.func_199318_a() + l), (int)(this.bounds.func_199319_b() - 1), (int)(this.bounds.func_199318_a() + l + 1), (int)this.bounds.func_199319_b(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int j1 = 0; j1 < this.bounds.func_199316_c(); ++j1) {
                        if (j1 % 2 != 0) continue;
                        AbstractGui.fill((int)(this.bounds.func_199318_a() + j1), (int)(this.bounds.func_199319_b() + this.bounds.func_199317_d()), (int)(this.bounds.func_199318_a() + j1 + 1), (int)(this.bounds.func_199319_b() + this.bounds.func_199317_d() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int i1 = 0; i1 < i; ++i1) {
                Suggestion suggestion = (Suggestion)this.suggestions.getList().get(i1 + this.scrollAmount);
                AbstractGui.fill((int)this.bounds.func_199318_a(), (int)(this.bounds.func_199319_b() + 12 * i1), (int)(this.bounds.func_199318_a() + this.bounds.func_199316_c()), (int)(this.bounds.func_199319_b() + 12 * i1 + 12), (int)Integer.MIN_VALUE);
                if (mouseX > this.bounds.func_199318_a() && mouseX < this.bounds.func_199318_a() + this.bounds.func_199316_c() && mouseY > this.bounds.func_199319_b() + 12 * i1 && mouseY < this.bounds.func_199319_b() + 12 * i1 + 12) {
                    if (flag3) {
                        this.suggest(i1 + this.scrollAmount);
                    }
                    flag4 = true;
                }
                AbstractDungeonCommanderScreen.this.font.func_175063_a(suggestion.getText(), (float)(this.bounds.func_199318_a() + 1), (float)(this.bounds.func_199319_b() + 2 + 12 * i1), i1 + this.scrollAmount == this.selectedSuggestion ? -256 : -5592406);
            }
            if (flag4 && (message = ((Suggestion)this.suggestions.getList().get(this.selectedSuggestion)).getTooltip()) != null) {
                AbstractDungeonCommanderScreen.this.renderTooltip(TextComponentUtils.func_202465_a((Message)message).func_150254_d(), mouseX, mouseY);
            }
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (!this.bounds.func_199315_b(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.bounds.func_199319_b()) / 12 + this.scrollAmount;
            if (i >= 0 && i < this.suggestions.getList().size()) {
                this.suggest(i);
                this.applySuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(double amount) {
            int j;
            int i = (int)(((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_71417_B.func_198024_e() * (double)((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_195558_d.func_198107_o() / (double)((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_195558_d.func_198105_m());
            if (this.bounds.func_199315_b(i, j = (int)(((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_71417_B.func_198026_f() * (double)((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_195558_d.func_198087_p() / (double)((AbstractDungeonCommanderScreen)AbstractDungeonCommanderScreen.this).minecraft.field_195558_d.func_198083_n()))) {
                this.scrollAmount = MathHelper.func_76125_a((int)((int)((double)this.scrollAmount - amount)), (int)0, (int)Math.max(this.suggestions.getList().size() - 7, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int p_209133_1_, int p_209133_2_, int p_209133_3_) {
            if (p_209133_1_ == 265) {
                this.func_209128_a(-1);
                this.field_209141_h = false;
                return true;
            }
            if (p_209133_1_ == 264) {
                this.func_209128_a(1);
                this.field_209141_h = false;
                return true;
            }
            if (p_209133_1_ == 258) {
                if (this.field_209141_h) {
                    this.func_209128_a(Screen.hasShiftDown() ? -1 : 1);
                }
                this.applySuggestion();
                return true;
            }
            if (p_209133_1_ == 256) {
                this.func_209132_b();
                return true;
            }
            return false;
        }

        public void func_209128_a(int p_209128_1_) {
            this.suggest(this.selectedSuggestion + p_209128_1_);
            int i = this.scrollAmount;
            int j = this.scrollAmount + 7 - 1;
            if (this.selectedSuggestion < i) {
                this.scrollAmount = MathHelper.func_76125_a((int)this.selectedSuggestion, (int)0, (int)Math.max(this.suggestions.getList().size() - 7, 0));
            } else if (this.selectedSuggestion > j) {
                this.scrollAmount = MathHelper.func_76125_a((int)(this.selectedSuggestion - 7), (int)0, (int)Math.max(this.suggestions.getList().size() - 7, 0));
            }
        }

        public void suggest(int suggestionIndex) {
            this.selectedSuggestion = suggestionIndex;
            if (this.selectedSuggestion < 0) {
                this.selectedSuggestion += this.suggestions.getList().size();
            }
            if (this.selectedSuggestion >= this.suggestions.getList().size()) {
                this.selectedSuggestion -= this.suggestions.getList().size();
            }
            Suggestion suggestion = (Suggestion)this.suggestions.getList().get(this.selectedSuggestion);
            AbstractDungeonCommanderScreen.this.commandTextField.func_195612_c(AbstractDungeonCommanderScreen.func_212339_b(AbstractDungeonCommanderScreen.this.commandTextField.func_146179_b(), suggestion.apply(this.field_212467_d)));
        }

        public void applySuggestion() {
            Suggestion suggestion = (Suggestion)this.suggestions.getList().get(this.selectedSuggestion);
            AbstractDungeonCommanderScreen.this.field_212342_z = true;
            AbstractDungeonCommanderScreen.this.setCommand(suggestion.apply(this.field_212467_d));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            AbstractDungeonCommanderScreen.this.commandTextField.func_212422_f(i);
            AbstractDungeonCommanderScreen.this.commandTextField.func_146199_i(i);
            this.suggest(this.selectedSuggestion);
            AbstractDungeonCommanderScreen.this.field_212342_z = false;
            this.field_209141_h = true;
        }

        public void func_209132_b() {
            AbstractDungeonCommanderScreen.this.suggestionList = null;
        }
    }
}

