/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.gui.tileEntities;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.CustomPistonBlock;
import com.matez.wildnature.blocks.CustomPistonHeadBlock;
import com.matez.wildnature.gui.initGuis;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomPistonTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockState pistonState;
    private Block head;
    private Block moving;
    private Direction pistonFacing;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    private static final ThreadLocal<Direction> MOVING_ENTITY = new ThreadLocal<Direction>(){

        @Override
        protected Direction initialValue() {
            return null;
        }
    };
    private float progress;
    private float lastProgress;
    private long lastTicked;

    public CustomPistonTileEntity() {
        super(initGuis.PISTON_TYPE);
    }

    public CustomPistonTileEntity(BlockState pistonStateIn, Direction pistonFacingIn, boolean extendingIn, boolean shouldHeadBeRenderedIn) {
        this();
        this.pistonState = pistonStateIn;
        this.pistonFacing = pistonFacingIn;
        this.extending = extendingIn;
        this.shouldHeadBeRendered = shouldHeadBeRenderedIn;
        this.head = Main.getBlockByID("wildnature:rs_piston1_head");
        this.moving = Main.getBlockByID("wildnature:rs_piston1_moving");
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getFacing() {
        return this.pistonFacing;
    }

    public boolean shouldPistonHeadBeRendered() {
        return this.shouldHeadBeRendered;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return MathHelper.func_219799_g((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetX(float ticks) {
        return (float)this.pistonFacing.func_82601_c() * this.getExtendedProgress(this.getProgress(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetY(float ticks) {
        return (float)this.pistonFacing.func_96559_d() * this.getExtendedProgress(this.getProgress(ticks));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOffsetZ(float ticks) {
        return (float)this.pistonFacing.func_82599_e() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float p_184320_1_) {
        return this.extending ? p_184320_1_ - 1.0f : 1.0f - p_184320_1_;
    }

    private BlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.shouldPistonHeadBeRendered() && this.pistonState.func_177230_c() instanceof CustomPistonBlock ? (BlockState)((BlockState)this.head.func_176223_P().func_206870_a(CustomPistonHeadBlock.TYPE, (Comparable)PistonType.STICKY)).func_206870_a((IProperty)CustomPistonHeadBlock.field_176387_N, this.pistonState.func_177229_b((IProperty)CustomPistonBlock.field_176387_N)) : this.pistonState;
    }

    private void moveCollidedEntities(float p_184322_1_) {
        List list;
        AxisAlignedBB axisalignedbb;
        List list1;
        Direction direction = this.getMotionDirection();
        double d0 = p_184322_1_ - this.progress;
        VoxelShape voxelshape = this.getCollisionRelatedBlockState().func_196952_d((IBlockReader)this.field_145850_b, this.func_174877_v());
        if (!voxelshape.func_197766_b() && !(list1 = this.field_145850_b.func_72839_b((Entity)null, this.getMovementArea(axisalignedbb = this.moveByPositionAndProgress(this.getMinMaxPiecesAABB(list = voxelshape.func_197756_d())), direction, d0).func_111270_a(axisalignedbb))).isEmpty()) {
            boolean flag = this.pistonState.func_177230_c().isStickyBlock(this.pistonState);
            for (int i = 0; i < list1.size(); ++i) {
                AxisAlignedBB axisalignedbb1;
                AxisAlignedBB axisalignedbb2;
                Entity entity = (Entity)list1.get(i);
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                if (flag) {
                    Vec3d vec3d = entity.func_213322_ci();
                    double d1 = vec3d.field_72450_a;
                    double d2 = vec3d.field_72448_b;
                    double d3 = vec3d.field_72449_c;
                    switch (direction.func_176740_k()) {
                        case X: {
                            d1 = direction.func_82601_c();
                            break;
                        }
                        case Y: {
                            d2 = direction.func_96559_d();
                            break;
                        }
                        case Z: {
                            d3 = direction.func_82599_e();
                        }
                    }
                    entity.func_213293_j(d1, d2, d3);
                }
                double d4 = 0.0;
                for (int j = 0; !(j >= list.size() || (axisalignedbb2 = this.getMovementArea(this.moveByPositionAndProgress((AxisAlignedBB)list.get(j)), direction, d0)).func_72326_a(axisalignedbb1 = entity.func_174813_aQ()) && (d4 = Math.max(d4, this.getMovement(axisalignedbb2, direction, axisalignedbb1))) >= d0); ++j) {
                }
                if (d4 <= 0.0) continue;
                d4 = Math.min(d4, d0) + 0.01;
                MOVING_ENTITY.set(direction);
                entity.func_213315_a(MoverType.PISTON, new Vec3d(d4 * (double)direction.func_82601_c(), d4 * (double)direction.func_96559_d(), d4 * (double)direction.func_82599_e()));
                MOVING_ENTITY.set(null);
                if (this.extending || !this.shouldHeadBeRendered) continue;
                this.fixEntityWithinPistonBase(entity, direction, d0);
            }
        }
    }

    public Direction getMotionDirection() {
        return this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d();
    }

    private AxisAlignedBB getMinMaxPiecesAABB(List<AxisAlignedBB> p_191515_1_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        for (AxisAlignedBB axisalignedbb : p_191515_1_) {
            d0 = Math.min(axisalignedbb.field_72340_a, d0);
            d1 = Math.min(axisalignedbb.field_72338_b, d1);
            d2 = Math.min(axisalignedbb.field_72339_c, d2);
            d3 = Math.max(axisalignedbb.field_72336_d, d3);
            d4 = Math.max(axisalignedbb.field_72337_e, d4);
            d5 = Math.max(axisalignedbb.field_72334_f, d5);
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    private double getMovement(AxisAlignedBB p_190612_1_, Direction facing, AxisAlignedBB p_190612_3_) {
        switch (facing.func_176740_k()) {
            case X: {
                return CustomPistonTileEntity.getDeltaX(p_190612_1_, facing, p_190612_3_);
            }
            default: {
                return CustomPistonTileEntity.getDeltaY(p_190612_1_, facing, p_190612_3_);
            }
            case Z: 
        }
        return CustomPistonTileEntity.getDeltaZ(p_190612_1_, facing, p_190612_3_);
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB p_190607_1_) {
        double d0 = this.getExtendedProgress(this.progress);
        return p_190607_1_.func_72317_d((double)this.field_174879_c.func_177958_n() + d0 * (double)this.pistonFacing.func_82601_c(), (double)this.field_174879_c.func_177956_o() + d0 * (double)this.pistonFacing.func_96559_d(), (double)this.field_174879_c.func_177952_p() + d0 * (double)this.pistonFacing.func_82599_e());
    }

    private AxisAlignedBB getMovementArea(AxisAlignedBB p_190610_1_, Direction p_190610_2_, double p_190610_3_) {
        double d0 = p_190610_3_ * (double)p_190610_2_.func_176743_c().func_179524_a();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        switch (p_190610_2_) {
            case WEST: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a + d1, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c, p_190610_1_.field_72340_a + d2, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(p_190610_1_.field_72336_d + d1, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d + d2, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f);
            }
            case DOWN: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b + d1, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d, p_190610_1_.field_72338_b + d2, p_190610_1_.field_72334_f);
            }
            default: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72337_e + d1, p_190610_1_.field_72339_c, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e + d2, p_190610_1_.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b, p_190610_1_.field_72339_c + d1, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e, p_190610_1_.field_72339_c + d2);
            }
            case SOUTH: 
        }
        return new AxisAlignedBB(p_190610_1_.field_72340_a, p_190610_1_.field_72338_b, p_190610_1_.field_72334_f + d1, p_190610_1_.field_72336_d, p_190610_1_.field_72337_e, p_190610_1_.field_72334_f + d2);
    }

    private void fixEntityWithinPistonBase(Entity p_190605_1_, Direction p_190605_2_, double p_190605_3_) {
        double d1;
        Direction direction;
        double d0;
        AxisAlignedBB axisalignedbb1;
        AxisAlignedBB axisalignedbb = p_190605_1_.func_174813_aQ();
        if (axisalignedbb.func_72326_a(axisalignedbb1 = VoxelShapes.func_197868_b().func_197752_a().func_186670_a(this.field_174879_c)) && Math.abs((d0 = this.getMovement(axisalignedbb1, direction = p_190605_2_.func_176734_d(), axisalignedbb) + 0.01) - (d1 = this.getMovement(axisalignedbb1, direction, axisalignedbb.func_191500_a(axisalignedbb1)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, p_190605_3_) + 0.01;
            MOVING_ENTITY.set(p_190605_2_);
            p_190605_1_.func_213315_a(MoverType.PISTON, new Vec3d(d0 * (double)direction.func_82601_c(), d0 * (double)direction.func_96559_d(), d0 * (double)direction.func_82599_e()));
            MOVING_ENTITY.set(null);
        }
    }

    private static double getDeltaX(AxisAlignedBB p_190611_0_, Direction facing, AxisAlignedBB p_190611_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190611_0_.field_72336_d - p_190611_2_.field_72340_a : p_190611_2_.field_72336_d - p_190611_0_.field_72340_a;
    }

    private static double getDeltaY(AxisAlignedBB p_190608_0_, Direction facing, AxisAlignedBB p_190608_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190608_0_.field_72337_e - p_190608_2_.field_72338_b : p_190608_2_.field_72337_e - p_190608_0_.field_72338_b;
    }

    private static double getDeltaZ(AxisAlignedBB p_190604_0_, Direction facing, AxisAlignedBB p_190604_2_) {
        return facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? p_190604_0_.field_72334_f - p_190604_2_.field_72339_c : p_190604_2_.field_72334_f - p_190604_0_.field_72339_c;
    }

    public BlockState getPistonState() {
        return this.pistonState;
    }

    public void clearPistonTileEntity() {
        System.out.println("rmeove");
        if (this.lastProgress < 1.0f && this.field_145850_b != null) {
            this.lastProgress = this.progress = 1.0f;
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_196603_bb) {
                BlockState blockstate = this.shouldHeadBeRendered ? Blocks.field_150350_a.func_176223_P() : Block.func_199770_b((BlockState)this.pistonState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        this.lastTicked = this.field_145850_b.func_82737_E();
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.pistonState != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == Blocks.field_196603_bb) {
                BlockState blockstate = Block.func_199770_b((BlockState)this.pistonState, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c);
                if (blockstate.func_196958_f()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, this.pistonState, 84);
                    Block.func_196263_a((BlockState)this.pistonState, (BlockState)blockstate, (IWorld)this.field_145850_b, (BlockPos)this.field_174879_c, (int)3);
                } else {
                    if (blockstate.func_196959_b((IProperty)BlockStateProperties.field_208198_y) && ((Boolean)blockstate.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
                        blockstate = (BlockState)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, blockstate, 67);
                    this.field_145850_b.func_190524_a(this.field_174879_c, blockstate.func_177230_c(), this.field_174879_c);
                }
            }
        } else {
            float f = this.progress + 0.5f;
            this.moveCollidedEntities(f);
            this.progress = f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.pistonState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("blockState"));
        this.pistonFacing = Direction.func_82600_a((int)compound.func_74762_e("facing"));
        this.lastProgress = this.progress = compound.func_74760_g("progress");
        this.extending = compound.func_74767_n("extending");
        this.shouldHeadBeRendered = compound.func_74767_n("source");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)this.pistonState));
        compound.func_74768_a("facing", this.pistonFacing.func_176745_a());
        compound.func_74776_a("progress", this.lastProgress);
        compound.func_74757_a("extending", this.extending);
        compound.func_74757_a("source", this.shouldHeadBeRendered);
        return compound;
    }

    public VoxelShape getCollisionShape(IBlockReader p_195508_1_, BlockPos p_195508_2_) {
        VoxelShape voxelshape = !this.extending && this.shouldHeadBeRendered ? ((BlockState)this.pistonState.func_206870_a((IProperty)CustomPistonBlock.EXTENDED, (Comparable)Boolean.valueOf(true))).func_196952_d(p_195508_1_, p_195508_2_) : VoxelShapes.func_197880_a();
        Direction direction = MOVING_ENTITY.get();
        if ((double)this.progress < 1.0 && direction == this.getMotionDirection()) {
            return voxelshape;
        }
        BlockState blockstate = this.shouldPistonHeadBeRendered() ? (BlockState)((BlockState)this.head.func_176223_P().func_206870_a((IProperty)CustomPistonHeadBlock.field_176387_N, (Comparable)this.pistonFacing)).func_206870_a((IProperty)CustomPistonHeadBlock.SHORT, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 4.0f)) : this.pistonState;
        float f = this.getExtendedProgress(this.progress);
        double d0 = (float)this.pistonFacing.func_82601_c() * f;
        double d1 = (float)this.pistonFacing.func_96559_d() * f;
        double d2 = (float)this.pistonFacing.func_82599_e() * f;
        return VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)blockstate.func_196952_d(p_195508_1_, p_195508_2_).func_197751_a(d0, d1, d2));
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

