/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.items.recipes;

import com.matez.wildnature.items.CookingItem;
import com.matez.wildnature.items.recipes.cooking.WNCookingRecipe;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class PotCrafting
extends SpecialRecipe {
    private boolean matching = true;

    public PotCrafting(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        this.matching = true;
        int i = 0;
        int j = 0;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack itemstack = inv.func_70301_a(k);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof CookingItem) {
                ++i;
            } else {
                ++j;
            }
            if (i > 1) {
                return false;
            }
            if (itemstack.func_77973_b() instanceof CookingItem) continue;
            Collection recipe = worldIn.func_199532_z().func_199510_b();
            ArrayList<Item> allMatchingItems = new ArrayList<Item>();
            for (IRecipe r : recipe) {
                if (!(r instanceof WNCookingRecipe)) continue;
                for (ItemStack s : ((WNCookingRecipe)r).ingredient.func_193365_a()) {
                    allMatchingItems.add(s.func_77973_b());
                }
            }
            if (allMatchingItems.contains(itemstack.func_77973_b())) continue;
            return false;
        }
        return i == 1 && j >= 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack pot = ItemStack.field_190927_a;
        ArrayList<ItemStack> newIngredients = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack1 = inv.func_70301_a(i);
            if (itemstack1.func_190926_b()) continue;
            Item item = itemstack1.func_77973_b();
            if (item instanceof CookingItem) {
                pot = itemstack1;
                continue;
            }
            newIngredients.add(itemstack1);
        }
        CompoundNBT nbt = pot.func_77946_l().func_196082_o();
        ArrayList<ItemStack> ingredients = Utilities.loadItems(nbt);
        ArrayList<SimpleItemStack> s = SimpleItemStack.sumLists(ingredients, newIngredients);
        ArrayList<ItemStack> resultIngredients = new ArrayList<ItemStack>();
        for (SimpleItemStack simpleItemStack : s) {
            resultIngredients.add(new ItemStack((IItemProvider)simpleItemStack.getItem(), simpleItemStack.getCount()));
        }
        ItemStack result = pot.func_77946_l();
        Utilities.saveItems(nbt, resultIngredients);
        result.func_77982_d(nbt);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Registry.field_218368_I.func_82594_a(new ResourceLocation("wildnature:pot_crafting"));
    }

    public static class SimpleItemStack {
        private Item item;
        private int count;

        public SimpleItemStack(Item item, int count) {
            this.item = item;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public Item getItem() {
            return this.item;
        }

        public static ArrayList<SimpleItemStack> sumLists(ArrayList<ItemStack> a1, ArrayList<ItemStack> a2) {
            ArrayList<SimpleItemStack> x1 = new ArrayList<SimpleItemStack>();
            for (ItemStack itemStack : a1) {
                x1.add(new SimpleItemStack(itemStack.func_77973_b(), itemStack.func_190916_E()));
            }
            ArrayList<SimpleItemStack> x2 = new ArrayList<SimpleItemStack>();
            for (ItemStack ingredient : a2) {
                x2.add(new SimpleItemStack(ingredient.func_77973_b(), ingredient.func_190916_E()));
            }
            ArrayList<SimpleItemStack> arrayList = new ArrayList<SimpleItemStack>();
            arrayList.addAll(x1);
            arrayList.addAll(x2);
            ArrayList<Item> rawItemStackList = new ArrayList<Item>();
            for (SimpleItemStack s : arrayList) {
                for (int a = 0; a < s.getCount(); ++a) {
                    rawItemStackList.add(s.getItem());
                }
            }
            ArrayList<SimpleItemStack> sortedList = new ArrayList<SimpleItemStack>();
            for (Item item : rawItemStackList) {
                boolean duplicate = false;
                for (SimpleItemStack simpleItemStack : sortedList) {
                    if (simpleItemStack.getItem() != item) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                int occurrences = Collections.frequency(rawItemStackList, item);
                sortedList.add(new SimpleItemStack(item, occurrences));
            }
            return sortedList;
        }
    }
}

