/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.items.recipes.cooking;

import com.matez.wildnature.items.recipes.PotCrafting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class WNAbstractCookingRecipe
implements IRecipe<IInventory> {
    protected final IRecipeType<?> type;
    protected final ResourceLocation id;
    public String group;
    public Ingredient ingredient;
    public ItemStack result;
    public float experience;
    public int cookTime;

    public WNAbstractCookingRecipe(IRecipeType<?> typeIn, ResourceLocation idIn, String groupIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookTimeIn) {
        this.type = typeIn;
        this.id = idIn;
        this.group = groupIn;
        this.ingredient = ingredientIn;
        this.result = resultIn;
        this.experience = experienceIn;
        this.cookTime = cookTimeIn;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.checkMatching(new ArrayList<ItemStack>((Collection<ItemStack>)((Inventory)inv).field_70482_c), this.ingredient, worldIn);
    }

    public boolean checkMatching(ArrayList<ItemStack> stacks, Ingredient i, World world) {
        boolean ok = true;
        int matching = 0;
        if (stacks.isEmpty()) {
            return false;
        }
        boolean d = false;
        for (ItemStack stack : stacks) {
            if (!this.checkForMatch(stack, i, stacks)) {
                ok = false;
                continue;
            }
            ++matching;
        }
        if (PotCrafting.SimpleItemStack.sumLists(new ArrayList<ItemStack>(Arrays.asList(i.field_193371_b)), new ArrayList<ItemStack>()).size() >= 9) {
            return false;
        }
        if (PotCrafting.SimpleItemStack.sumLists(new ArrayList<ItemStack>(Arrays.asList(i.field_193371_b)), new ArrayList<ItemStack>()).size() != matching) {
            return false;
        }
        return ok;
    }

    public static ArrayList<Item> convertItemStackListToItemList(ItemStack[] stacks) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack stack : stacks) {
            int count = stack.func_190916_E();
            for (int i = 0; i < count; ++i) {
                items.add(stack.func_77973_b());
            }
        }
        return items;
    }

    public boolean checkForMatch(@Nullable ItemStack itemStack, Ingredient i, ArrayList<ItemStack> stacks) {
        if (itemStack == null) {
            return false;
        }
        if (i.field_199807_b.length == 0) {
            return itemStack.func_190926_b();
        }
        this.determineMatchingStacks(i);
        boolean ok = true;
        if (i.field_193371_b.length == 0) {
            return false;
        }
        ArrayList<PotCrafting.SimpleItemStack> s = PotCrafting.SimpleItemStack.sumLists(new ArrayList<ItemStack>(Arrays.asList(i.field_193371_b)), new ArrayList<ItemStack>());
        ArrayList<ItemStack> resultIngredients = new ArrayList<ItemStack>();
        for (PotCrafting.SimpleItemStack simpleItemStack : s) {
            resultIngredients.add(new ItemStack((IItemProvider)simpleItemStack.getItem(), simpleItemStack.getCount()));
        }
        for (ItemStack itemstack : resultIngredients) {
            if (itemstack.func_77973_b() != itemStack.func_77973_b() || itemStack.func_190916_E() != itemstack.func_190916_E()) continue;
            return ok;
        }
        i.field_193371_b = resultIngredients.toArray(new ItemStack[resultIngredients.size()]);
        return false;
    }

    private void determineMatchingStacks(Ingredient i) {
        if (i.field_193371_b == null) {
            i.field_193371_b = (ItemStack[])Arrays.stream(i.field_199807_b).flatMap(p_209359_0_ -> p_209359_0_.func_199799_a().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public float getExperience() {
        return this.experience;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }
}

