/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.music;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;

public class AmbientMusic {
    public static ArrayList<BiomeMusic> biomeMusics = new ArrayList();

    public AmbientMusic() {
        System.out.println("Registering Ambient Music Module");
        System.out.println("Registered musics for " + biomeMusics.size() + " biomes.");
    }

    public static enum MusicPosition {
        CAVES,
        SURFACE,
        NONE;

    }

    public static enum DayTime {
        DAY,
        NIGHT,
        NONE;

    }

    public static class BiomeMusic {
        private Biome biome;
        private Biome.RainType rainType;
        private DayTime dayTime;
        private int repeatDelay = 0;
        private double volume = 0.0;
        private ArrayList<SoundEvent> soundEvents;

        public BiomeMusic(Biome biome, Biome.RainType type, DayTime dayTime, int repeatDelay, double volume, SoundEvent ... events) {
            this.biome = biome;
            this.rainType = type;
            this.dayTime = dayTime;
            this.repeatDelay = repeatDelay;
            this.volume = volume;
            this.soundEvents = new ArrayList<SoundEvent>(Arrays.asList(events));
            biomeMusics.add(this);
        }

        public double getVolume() {
            return this.volume;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public ArrayList<SoundEvent> getSoundEvents() {
            return this.soundEvents;
        }

        public Biome.RainType getRainType() {
            return this.rainType;
        }

        public int getRepeatDelay() {
            return this.repeatDelay;
        }

        public DayTime getDayTime() {
            return this.dayTime;
        }

        public boolean contains(ISound sound) {
            if (sound == null) {
                return false;
            }
            for (SoundEvent e : this.soundEvents) {
                if (e.func_187503_a() != sound.func_147650_b()) continue;
                return true;
            }
            return false;
        }

        public static void applySameAs(Biome biome, Biome as, Biome.RainType type, DayTime dayTime, int repeatDelay, double volume) {
            for (BiomeMusic m : biomeMusics) {
                Biome b = m.getBiome();
                if (b != biome) continue;
                new BiomeMusic(as, type, dayTime, repeatDelay, volume, (SoundEvent[])m.getSoundEvents().toArray());
            }
        }
    }
}

