/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.music;

import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.music.AmbientMusic;
import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AmbientSoundPlayer {
    private World world;
    private Minecraft client;
    private ISound currentMusic;
    private AmbientMusic.BiomeMusic currentBiomeMusic;
    private PlayerEntity entity;
    private Biome currentBiome;
    private Biome oldBiome;
    private AmbientMusic.DayTime currentDayTime = AmbientMusic.DayTime.NONE;
    private Biome.RainType currentRainType = Biome.RainType.NONE;
    private int tps = 20;
    private boolean isDay = true;
    private boolean isRaining = false;

    public AmbientSoundPlayer(Minecraft client) {
        System.out.println("Registering Ambient Sound Player");
        this.client = client;
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        this.world = event.player.func_130014_f_();
        this.entity = event.player;
        boolean bl = this.isDay = this.world.func_72820_D() < 13800L || this.world.func_72820_D() >= 22500L;
        if (this.client != null) {
            ArrayList<SoundEvent> soundEvents;
            AmbientMusic.BiomeMusic music;
            this.currentBiome = this.world.func_180494_b(this.entity.func_180425_c());
            this.isRaining = this.world.func_72896_J();
            this.currentDayTime = this.isDay ? AmbientMusic.DayTime.DAY : AmbientMusic.DayTime.NIGHT;
            this.currentRainType = this.isRaining ? Biome.RainType.RAIN : Biome.RainType.NONE;
            if (this.oldBiome == null) {
                this.oldBiome = this.currentBiome;
            } else if (this.currentBiome != this.oldBiome) {
                System.out.println("Play for: " + this.currentBiome.getRegistryName());
                music = this.getValidSound(this.currentBiome);
                if (music != null && (soundEvents = music.getSoundEvents()) != null) {
                    this.stopAndPlaySoundToPlayer(soundEvents.get(Utilities.rint(0, soundEvents.size() - 1)), music.getRepeatDelay(), music.getVolume());
                }
                this.oldBiome = this.currentBiome;
            }
            if (this.currentBiomeMusic != null && !this.client.func_147118_V().func_215294_c(this.currentMusic) && !this.currentBiomeMusic.contains(this.currentMusic)) {
                this.currentMusic = null;
                music = this.getValidSound(this.currentBiome);
                if (music != null && (soundEvents = music.getSoundEvents()) != null) {
                    this.stopAndPlaySoundToPlayer(soundEvents.get(Utilities.rint(0, soundEvents.size() - 1)), music.getRepeatDelay(), music.getVolume());
                }
            }
        }
    }

    public AmbientMusic.BiomeMusic getValidSound(Biome b) {
        AmbientMusic.BiomeMusic m = null;
        System.out.println("Searching music: day = " + this.isDay + " raining = " + this.isRaining);
        for (int i = 0; i < AmbientMusic.biomeMusics.size(); ++i) {
            if (AmbientMusic.biomeMusics.get(i).getBiome() != b) continue;
            AmbientMusic.BiomeMusic mm = AmbientMusic.biomeMusics.get(i);
            if (this.isDay && mm.getDayTime() == AmbientMusic.DayTime.NIGHT || !this.isDay && mm.getDayTime() == AmbientMusic.DayTime.DAY || this.isRaining && mm.getRainType() != Biome.RainType.NONE) continue;
            System.out.println("Found sound: " + AmbientMusic.biomeMusics.get(i).getSoundEvents().get(0).func_187503_a() + " " + AmbientMusic.biomeMusics.get(i).getBiome().getRegistryName());
            m = AmbientMusic.biomeMusics.get(i);
            break;
        }
        this.currentBiomeMusic = m;
        if (m != null) {
            this.currentRainType = this.currentBiomeMusic.getRainType();
            this.currentDayTime = this.currentBiomeMusic.getDayTime();
        } else {
            this.stop();
            this.currentRainType = null;
            this.currentDayTime = null;
        }
        return m;
    }

    public void stopAndPlaySoundToPlayer(SoundEvent event, int repeatDelay, double volume) {
        if (event != null) {
            System.out.println("playing: " + event.func_187503_a());
            this.play(event, repeatDelay, volume);
            System.out.println("is playing? " + this.client.func_147118_V().func_215294_c(this.currentMusic));
        }
    }

    public void play(SoundEvent event, int repeatDelay, double volume) {
        SimpleSound sound = AmbientSoundPlayer.ambient(event, (float)((Double)CommonConfig.ambientSoundsVolume.get() + 0.0), repeatDelay);
        System.out.println("PLAYING: " + sound.func_147650_b() + " " + this.currentBiomeMusic.getBiome().getRegistryName());
        this.client.func_147118_V().func_147682_a((ISound)sound);
        this.currentMusic = sound;
    }

    public void stop() {
        try {
            System.out.println("stopping: " + this.currentMusic.func_147650_b());
            this.client.func_147118_V().func_147683_b(this.currentMusic);
            this.currentMusic = null;
        }
        catch (Exception e) {
            System.out.println("cannot stop");
        }
    }

    public static SimpleSound ambient(SoundEvent soundIn, float volumeIn, int repeatDelay) {
        return new SimpleSound(soundIn.func_187503_a(), SoundCategory.AMBIENT, volumeIn, 1.0f, false, repeatDelay, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f, true);
    }
}

