/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.biomes.surface;

import com.matez.wildnature.other.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class CustomSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private ArrayList<BlockCfg> cfgs;

    public CustomSurfaceBuilder(BlockCfg ... cfg) {
        super(SurfaceBuilderConfig::func_215455_a);
        this.cfgs = new ArrayList<BlockCfg>(Arrays.asList(cfg));
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)this.getConfig(random));
    }

    private SurfaceBuilderConfig getConfig(Random rand) {
        ArrayList<SurfaceBuilderConfig> states = new ArrayList<SurfaceBuilderConfig>();
        for (int x = 0; x < this.cfgs.size(); ++x) {
            int a = this.cfgs.get(x).chance;
            for (int z = 0; z < a; ++z) {
                states.add(this.cfgs.get(x).config);
            }
        }
        if (states.size() != 0) {
            int block = Utilities.rint(0, states.size() - 1, rand);
            return (SurfaceBuilderConfig)states.get(block);
        }
        return field_215425_v;
    }

    public static class BlockCfg {
        private int chance;
        private SurfaceBuilderConfig config;

        public BlockCfg(SurfaceBuilderConfig config, int chance) {
            this.chance = chance;
            this.config = config;
        }

        public int getChance() {
            return this.chance;
        }

        public SurfaceBuilderConfig getConfig() {
            return this.config;
        }
    }
}

