/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.biomes.surface;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class PolderSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    int max = 0;

    public PolderSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> p_i51305_1_, int maxYToReplace) {
        super(p_i51305_1_);
        this.max = maxYToReplace;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        boolean i = false;
        int lowestHeight = 0;
        for (int height = seaLevel - 1; height > seaLevel - 1 - this.max; --height) {
            if (chunkIn.func_180495_p(new BlockPos(x, height, z)).func_204520_s().func_206886_c() != Fluids.field_204546_a) continue;
            chunkIn.func_177436_a(new BlockPos(x, height, z), Blocks.field_150350_a.func_176223_P(), false);
            lowestHeight = height;
        }
        this.buildPolderSurface(random, chunkIn, biomeIn, x, z, lowestHeight - 1, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), seaLevel);
    }

    private boolean isSameBiomeNear(IChunk chunk, Biome current, BlockPos pos) {
        return true;
    }

    protected void buildPolderSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, int sealevel) {
        BlockState blockstate = top;
        BlockState blockstate1 = middle;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = -1;
        int j = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int k = x & 0xF;
        int l = z & 0xF;
        boolean groundPlace = false;
        for (int i1 = startHeight; i1 >= 0; --i1) {
            blockpos$mutableblockpos.func_181079_c(k, i1, l);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (blockstate2.func_196958_f()) {
                i = -1;
                continue;
            }
            if (blockstate2.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (i == -1) {
                if (j <= 0) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = defaultBlock;
                } else if (i1 >= sealevel - 4 && i1 <= sealevel + 1) {
                    blockstate = top;
                    blockstate1 = middle;
                }
                if (i1 < sealevel && (blockstate == null || blockstate.func_196958_f())) {
                    blockstate = biomeIn.func_225486_c((BlockPos)blockpos$mutableblockpos.func_181079_c(x, i1, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    blockpos$mutableblockpos.func_181079_c(k, i1, l);
                }
                i = j;
                if (i1 >= sealevel - 1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos, blockstate, false);
                    continue;
                }
                if (groundPlace) {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos, blockstate1, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos, blockstate, false);
                groundPlace = true;
                continue;
            }
            if (i <= 0) continue;
            chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos, blockstate1, false);
            if (--i != 0 || blockstate1.func_177230_c() != Blocks.field_150354_m || j <= 1) continue;
            i = random.nextInt(4) + Math.max(0, i1 - 63);
            blockstate1 = blockstate1.func_177230_c() == Blocks.field_196611_F ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        }
    }

    public static boolean isAnotherBiomeNear(Biome myBiome, BlockPos pos, Chunk chunk, int radius) {
        boolean itIs = false;
        int i = radius;
        if (chunk.func_217309_c(pos.func_177965_g(i)) != myBiome) {
            itIs = true;
        }
        if (chunk.func_217309_c(pos.func_177985_f(i)) != myBiome) {
            itIs = true;
        }
        if (chunk.func_217309_c(pos.func_177964_d(i)) != myBiome) {
            itIs = true;
        }
        if (chunk.func_217309_c(pos.func_177970_e(i)) != myBiome) {
            itIs = true;
        }
        return itIs;
    }

    public static boolean isWaterNear(BlockPos pos, IChunk chunk, int radius) {
        boolean itIs = false;
        int i = radius;
        if (chunk.func_180495_p(pos.func_177965_g(i)).func_177230_c() == Blocks.field_150355_j) {
            itIs = true;
        }
        if (chunk.func_180495_p(pos.func_177985_f(i)).func_177230_c() == Blocks.field_150355_j) {
            itIs = true;
        }
        if (chunk.func_180495_p(pos.func_177964_d(i)).func_177230_c() == Blocks.field_150355_j) {
            itIs = true;
        }
        if (chunk.func_180495_p(pos.func_177970_e(i)).func_177230_c() == Blocks.field_150355_j) {
            itIs = true;
        }
        return false;
    }
}

