/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.biomes.surface.cracked;

import com.matez.wildnature.world.gen.biomes.biomes.surface.cracked.Vector;
import com.matez.wildnature.world.gen.biomes.biomes.surface.cracked.VoronoiPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class Crack {
    public static int WIDTH = 500;
    public static int HEIGHT = 500;
    public static int RECURSION_LEVELS = 3;
    public static int AMOUNT_OF_POINTS = 5;
    public static int ROTATION_RESOLUTION = 600;
    public static int ROTATION_SMOOTHNESS = 10;
    public static int BACKGROUND = -2045011;
    public static Random RAND;

    public Crack() {
        ArrayList<Vector> points = new ArrayList<Vector>();
        for (int x = 0; x < WIDTH; ++x) {
            for (int y = 0; y < HEIGHT; ++y) {
                points.add(new Vector(x, y));
            }
        }
        Crack.generateSoil(points, AMOUNT_OF_POINTS, RECURSION_LEVELS);
    }

    private static void generateSoil(ArrayList<Vector> drawPoints, int amountOfPoints, int recursionLevel) {
        ArrayList<VoronoiPoint> points = new ArrayList<VoronoiPoint>();
        for (int i = 0; i < amountOfPoints; ++i) {
            points.add(new VoronoiPoint(drawPoints.get(RAND.nextInt(drawPoints.size()))));
        }
        HashMap pointMaps = new HashMap();
        for (VoronoiPoint point : points) {
            pointMaps.put(point.hashCode(), new ArrayList());
        }
        System.out.println(pointMaps);
        System.out.println(points);
        for (Vector v : drawPoints) {
            VoronoiPoint closest = null;
            VoronoiPoint secondClosest = null;
            for (VoronoiPoint point : points) {
                double distance = point.getMultiplicativeDistanceTo(v);
                if (closest == null || distance < closest.getMultiplicativeDistanceTo(v)) {
                    secondClosest = closest;
                    closest = point;
                    continue;
                }
                if (secondClosest != null && !(distance < secondClosest.getMultiplicativeDistanceTo(v))) continue;
                secondClosest = point;
            }
            int col = 0;
            if (Math.abs(closest.getMultiplicativeDistanceTo(v) - secondClosest.getMultiplicativeDistanceTo(v)) < (double)(recursionLevel * 5 / RECURSION_LEVELS)) {
                col = 0x1000000 * (recursionLevel * 255 / RECURSION_LEVELS);
            } else {
                ((ArrayList)pointMaps.get(closest.hashCode())).add(v);
            }
            Crack.Block((int)v.getX(), (int)v.getY());
        }
    }

    public static int modInts(int a, int b) {
        return (int)Crack.mod(a, b);
    }

    public static double mod(double a, double b) {
        a %= b;
        while (a < 0.0) {
            a += b;
        }
        return a;
    }

    public static void Block(int x, int z) {
    }
}

