/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.biomes.surface.cracked;

import java.util.ArrayList;
import java.util.Random;

public class Vector {
    private static final float SMALL = 0.78740156f;
    private float x;
    private float y;

    public Vector(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public Vector(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Vector(double x, double y) {
        this.setX((float)x);
        this.setY((float)y);
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getLengthToSqrd(float x, float y) {
        return (this.x - x) * (this.x - x) + (this.y - y) * (this.y - y);
    }

    public float getLengthToSqrd(Vector v) {
        return this.getLengthToSqrd(v.x, v.y);
    }

    public float getLengthSqrd() {
        return this.getLengthToSqrd(0.0f, 0.0f);
    }

    public float getLengthTo(float x, float y) {
        return (float)Math.sqrt(this.getLengthToSqrd(x, y));
    }

    public float getLengthTo(Vector v) {
        return this.getLengthTo(v.x, v.y);
    }

    public float getLength() {
        return this.getLengthTo(0.0f, 0.0f);
    }

    public Vector setLength(float setLength) {
        float length = this.getLength();
        this.x *= setLength / length;
        this.y *= setLength / length;
        return this;
    }

    public float getFastLengthTo(float x, float y) {
        return this.getFastLengthTo(new Vector(x, y));
    }

    public float getFastLengthTo(Vector v) {
        float taxiLength = this.getTaxiCabLengthTo(v);
        float chebyDist = this.getChebyshevDistanceTo(v);
        return Float.min(taxiLength * 0.7f, chebyDist);
    }

    public float getFastLength() {
        return this.getLengthTo(0.0f, 0.0f);
    }

    public Vector setFastLength(float setLength) {
        float length = this.getFastLength();
        this.x *= setLength / length;
        this.y *= setLength / length;
        return this;
    }

    public float getTaxiCabLengthTo(float x, float y) {
        return Math.abs(this.x - x) + Math.abs(this.y - y);
    }

    public float getTaxiCabLengthTo(Vector v) {
        return this.getTaxiCabLengthTo(v.x, v.y);
    }

    public float getTaxiCabLength() {
        return this.getTaxiCabLengthTo(0.0f, 0.0f);
    }

    public Vector setTaxiCabLength(float setLength) {
        float length = this.getTaxiCabLength();
        this.x *= setLength / length;
        this.y *= setLength / length;
        return this;
    }

    public Vector absIfBoth() {
        if (this.x < 0.0f && this.y < 0.0f) {
            return new Vector(-this.x, -this.y);
        }
        return this;
    }

    public Vector abs() {
        return new Vector(this.x < 0.0f ? -this.x : this.x, this.y < 0.0f ? -this.y : this.y);
    }

    public float getChebyshevDistanceTo(float x, float y) {
        return Math.max(Math.abs(this.x - x), Math.abs(this.y - y));
    }

    public float getChebyshevDistanceTo(Vector v) {
        return this.getChebyshevDistanceTo(v.x, v.y);
    }

    public float getChebyshevDistance() {
        return this.getChebyshevDistanceTo(0.0f, 0.0f);
    }

    public Vector setChebyshevLength(float setLength) {
        float length = this.getChebyshevDistance();
        this.x *= setLength / length;
        this.y *= setLength / length;
        return this;
    }

    public Vector sub(Vector v) {
        return new Vector(this.x - v.getX(), this.y - v.getY());
    }

    public Vector add(Vector v) {
        return new Vector(this.x + v.getX(), this.y + v.getY());
    }

    public Vector mul(Vector v) {
        return new Vector(this.x * v.getX(), this.y * v.getY());
    }

    public Vector mul(float f) {
        return this.mul(new Vector(f, f));
    }

    public Vector div(Vector v) {
        return new Vector(this.x / v.getX(), this.y / v.getY());
    }

    public Vector div(float f) {
        return this.div(new Vector(f, f));
    }

    public Vector mod(Vector v) {
        return new Vector(this.x % v.getX(), this.y % v.getY());
    }

    public Vector mod(int a, int b) {
        return this.mod(new Vector(a, b));
    }

    public Vector mod(int a) {
        return this.mod(a, a);
    }

    public String toString() {
        return "Vector(" + this.getX() + ", " + this.getY() + ")";
    }

    public ArrayList<Vector> loop(Vector to, float length) {
        Vector delta = this.sub(to);
        float l = delta.getLength();
        ArrayList<Vector> loops = new ArrayList<Vector>();
        for (float i = length; i < l; i += length) {
            delta.setLength(i);
            loops.add(delta.add(to));
        }
        loops.add(this);
        return loops;
    }

    public boolean intersects(Vector pos, Vector size) {
        pos.sub(this);
        if (pos.getX() < this.getX()) {
            return false;
        }
        return !(pos.getY() < this.getY());
    }

    public Vector copy() {
        return new Vector(this.x, this.y);
    }

    public void distort(float d) {
        this.x = (float)((double)this.x + (Math.random() * (double)d - (double)(d / 2.0f)));
        this.y = (float)((double)this.y + (Math.random() * (double)d - (double)(d / 2.0f)));
    }

    public boolean equals(Object o) {
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            return this.getLengthToSquared(v) < 0.6200012f;
        }
        return false;
    }

    private float getLengthToSquared(Vector v) {
        return this.sub(v).getLengthSquared();
    }

    private float getLengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public boolean kindaEquals(Vector o, int i) {
        if (o.x + (float)i < this.x) {
            return false;
        }
        if (o.x - (float)i > this.x) {
            return false;
        }
        if (o.y + (float)i < this.y) {
            return false;
        }
        return !(o.y - (float)i > this.y);
    }

    public int getDirection() {
        return this.getDirectionInDegrees() / 45;
    }

    public int getDirectionInDegrees() {
        return (int)this.positize((float)Math.toDegrees(Math.atan2(this.x, -this.y)), 360.0f);
    }

    private float positize(float f, float base) {
        while (f < 0.0f) {
            f += base;
        }
        return f;
    }

    public Vector moveInDir(int d) {
        d %= 8;
        if ((d = (int)this.positize(d, 8.0f)) == 0) {
            return this.add(new Vector(0, -1));
        }
        if (d == 1) {
            return this.add(new Vector(1, -1));
        }
        if (d == 2) {
            return this.add(new Vector(1, 0));
        }
        if (d == 3) {
            return this.add(new Vector(1, 1));
        }
        if (d == 4) {
            return this.add(new Vector(0, 1));
        }
        if (d == 5) {
            return this.add(new Vector(-1, 1));
        }
        if (d == 6) {
            return this.add(new Vector(-1, 0));
        }
        if (d == 7) {
            return this.add(new Vector(-1, -1));
        }
        return this;
    }

    public float getRotationTo(Vector o) {
        float d;
        for (d = (float)Math.toDegrees(Math.atan2(this.y - o.y, -(this.x - o.x))); d < 0.0f; d += 360.0f) {
        }
        while (d > 360.0f) {
            d -= 360.0f;
        }
        return d;
    }

    public float getRotation() {
        return this.getRotationTo(new Vector(0, 0));
    }

    public Vector rotate(double n) {
        n = Math.toRadians(n);
        float rx = (float)((double)this.x * Math.cos(n) - (double)this.y * Math.sin(n));
        float ry = (float)((double)this.x * Math.sin(n) + (double)this.y * Math.cos(n));
        return new Vector(rx, ry);
    }

    public int hashCode() {
        int xx = (int)this.x ^ (int)(this.x * 2.1474836E9f);
        int yy = (int)this.y ^ (int)(this.y * 2.1474836E9f);
        return new Random(12665 * xx).nextInt() ^ new Random(5349 * yy).nextInt() + new Random(30513 * xx ^ 19972 * yy).nextInt();
    }

    public boolean isPositive() {
        return this.x >= 0.0f && this.y >= 0.0f;
    }

    public Vector clone() {
        return new Vector(this.x, this.y);
    }
}

