/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.biomes.surface.cracked;

import com.matez.wildnature.world.gen.biomes.biomes.surface.cracked.Crack;
import com.matez.wildnature.world.gen.biomes.biomes.surface.cracked.Vector;

public class VoronoiPoint {
    private Vector pos;
    private double[] distances;

    public VoronoiPoint(Vector pos) {
        this.pos = pos;
        this.distances = new double[Crack.ROTATION_RESOLUTION];
        for (int i = 0; i < this.distances.length; ++i) {
            this.distances[i] = (double)(Crack.RAND.nextFloat() / 2.0f) + 0.51;
        }
        for (int iter = 0; iter < Crack.ROTATION_SMOOTHNESS; ++iter) {
            for (int i = 0; i < this.distances.length; ++i) {
                this.distances[i] = (this.distances[Crack.modInts(i - Crack.RAND.nextInt(4) - 2, this.distances.length)] + this.distances[i] + this.distances[Crack.modInts(i + Crack.RAND.nextInt(4) - 2, this.distances.length)]) / 3.0;
            }
        }
    }

    public Vector getPos() {
        return this.pos;
    }

    public double getRotationFromAngle(double radians) {
        return this.distances[(int)(Crack.mod(Math.toDegrees(radians) / 360.0, 1.0) * (double)this.distances.length)];
    }

    public double getRotationFromVector(Vector vec) {
        return this.getRotationFromAngle(Math.atan2(this.pos.getY() - vec.getY(), -(this.pos.getX() - vec.getX())));
    }

    public double getMultiplicativeDistanceTo(Vector other) {
        return (double)this.pos.getLengthTo(other) * this.getRotationFromVector(other);
    }

    public String toString() {
        return "VoronoiPoint(pos=[" + this.pos.getX() + ", " + this.pos.getY() + "])";
    }

    public int hashCode() {
        return this.distances.hashCode() ^ this.pos.hashCode();
    }
}

