/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.layer;

import com.google.common.collect.ImmutableList;
import com.matez.wildnature.world.gen.biomes.layer.WNIslandLayer;
import com.matez.wildnature.world.gen.biomes.layer.WNLayerUtil;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;

public class WNBiomeLayer
implements IC0Transformer {
    private static final int BIRCH_FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150583_P);
    private static final int DESERT = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76769_d);
    private static final int MOUNTAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76770_e);
    private static final int FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76767_f);
    private static final int SNOWY_TUNDRA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76774_n);
    private static final int JUNGLE = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76782_w);
    private static final int BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150608_ab);
    private static final int WOODED_BADLANDS_PLATEAU = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150607_aa);
    private static final int MUSHROOM_FIELDS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76789_p);
    private static final int PLAINS = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76772_c);
    private static final int GIANT_TREE_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150578_U);
    private static final int DARK_FOREST = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150585_R);
    private static final int SAVANNA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150588_X);
    private static final int SWAMP = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76780_h);
    private static final int TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76768_g);
    private static final int SNOWY_TAIGA = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150584_S);
    private static final int EASTER_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.EasterIsland);
    private static final int TROPICAL_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TropicalIsland);
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final OverworldGenSettings settings;

    public WNBiomeLayer(WorldType p_i48641_1_, OverworldGenSettings p_i48641_2_) {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
        if (p_i48641_1_ == WorldType.field_77136_e) {
            this.biomes[desertIdx].clear();
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76767_f, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76770_e, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76780_h, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76768_g, 10));
            this.settings = null;
        } else {
            this.settings = p_i48641_2_;
        }
    }

    public int func_202726_a(INoiseRandom context, int value) {
        if (this.settings != null && this.settings.func_202199_l() >= 0) {
            return this.settings.func_202199_l();
        }
        int i = (value & 0xF00) >> 8;
        value &= 0xFFFFF0FF;
        boolean isLikeIsland = false;
        for (WNIslandLayer.Island island : WNIslandLayer.islands) {
            if (island.getBiome() != value) continue;
            isLikeIsland = true;
            break;
        }
        if (!WNLayerUtil.isOcean(value) && value != MUSHROOM_FIELDS && !isLikeIsland) {
            switch (value) {
                case 1: {
                    if (i > 0) {
                        return context.func_202696_a(3) == 0 ? BADLANDS_PLATEAU : WOODED_BADLANDS_PLATEAU;
                    }
                    return Registry.field_212624_m.func_148757_b((Object)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (INoiseRandom)context).biome);
                }
                case 2: {
                    if (i > 0) {
                        return JUNGLE;
                    }
                    return Registry.field_212624_m.func_148757_b((Object)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (INoiseRandom)context).biome);
                }
                case 3: {
                    if (i > 0) {
                        return GIANT_TREE_TAIGA;
                    }
                    return Registry.field_212624_m.func_148757_b((Object)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (INoiseRandom)context).biome);
                }
                case 4: {
                    return Registry.field_212624_m.func_148757_b((Object)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (INoiseRandom)context).biome);
                }
            }
            return 0;
        }
        return value;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

