/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.layer;

import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.world.gen.biomes.layer.WNLayerUtil;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomes;
import java.util.ArrayList;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraft.world.gen.layer.traits.IDimOffset1Transformer;

public enum WNIslandLayer implements IAreaTransformer1,
IDimOffset1Transformer
{
    INSTANCE;

    private static final int EASTER_ISLAND;
    private static final int TROPICAL_ISLAND;
    private static final int MADAGASCAR;
    private static final int CHRISTMAS_ISLAND;
    public static ArrayList<Island> islands;

    public static void applyIslands() {
        islands.add(new Island(EASTER_ISLAND, 70));
        islands.add(new Island(TROPICAL_ISLAND, 40));
        islands.add(new Island(MADAGASCAR, 30));
        islands.add(new Island(CHRISTMAS_ISLAND, 50));
    }

    public int func_215728_a(IExtendedNoiseRandom<?> context, IArea layer, int x, int z) {
        int side1 = layer.func_202678_a(x + 1, z);
        int side2 = layer.func_202678_a(x - 1, z);
        int side3 = layer.func_202678_a(x, z + 1);
        int side4 = layer.func_202678_a(x, z - 1);
        int side = layer.func_202678_a(x, z);
        if (WNLayerUtil.isOcean(side) && WNLayerUtil.isOcean(side1) && WNLayerUtil.isOcean(side2) && WNLayerUtil.isOcean(side3) && WNLayerUtil.isOcean(side4)) {
            for (Island island : islands) {
                if (context.func_202696_a(island.rarity) != 0 || CommonConfig.blacklistedBiomes.contains(Registry.field_212624_m.func_148745_a(island.getBiome()))) continue;
                return island.getBiome();
            }
        }
        for (Island island : islands) {
            if (!this.isSame(side, island.getBiome()) && !this.isSame(side1, island.getBiome()) && !this.isSame(side2, island.getBiome()) && !this.isSame(side3, island.getBiome()) && !this.isSame(side4, island.getBiome()) || context.func_202696_a(island.rarity) == 0 || CommonConfig.blacklistedBiomes.contains(Registry.field_212624_m.func_148745_a(island.getBiome()))) continue;
            return island.getBiome();
        }
        return side;
    }

    private boolean isSame(int biome, int island) {
        return biome == island;
    }

    static {
        EASTER_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.EasterIsland);
        TROPICAL_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.TropicalIsland);
        MADAGASCAR = Registry.field_212624_m.func_148757_b((Object)WNBiomes.Madagascar);
        CHRISTMAS_ISLAND = Registry.field_212624_m.func_148757_b((Object)WNBiomes.ChristmasIsland);
        islands = new ArrayList();
    }

    public static class Island {
        private int biome;
        private int rarity;

        public Island(int b, int rarity) {
            this.biome = b;
            this.rarity = rarity;
        }

        public int getBiome() {
            return this.biome;
        }

        public int getRarity() {
            return this.rarity;
        }
    }
}

