/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.setup;

import com.matez.wildnature.Main;
import com.matez.wildnature.other.BlockWeighList;
import com.matez.wildnature.other.TreeWeighList;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomeBuilder;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomes;
import com.matez.wildnature.world.gen.feature.PlantFeature;
import com.matez.wildnature.world.gen.feature.TreeFeature;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class WNBiome
extends Biome {
    public WNBiomeBuilder wnBiomeBuilder;
    public BlockWeighList plants = new BlockWeighList();
    public int plantRate = 1;
    public TreeWeighList trees = new TreeWeighList();
    public int treeRate = 6;
    public float treeExtraChance = 0.1f;
    public int treeExtra = 1;

    private static Biome.Builder analyseBuilder(Biome.Builder builder) {
        WNBiomeBuilder wnbuilder = (WNBiomeBuilder)builder;
        if (wnbuilder.getFog() == null) {
            wnbuilder.fog(new WNBiomeBuilder.Fog(1, -1, -1.0f));
        }
        if (wnbuilder.getTopography() == null) {
            wnbuilder.topography(wnbuilder.getUnknownTopography());
        }
        if (wnbuilder.getClimate() == null) {
            wnbuilder.climate(wnbuilder.getUnknownClimate());
        }
        return wnbuilder;
    }

    public static WNBiomeBuilder getWNBuilder(Biome.Builder builder) {
        WNBiomeBuilder wnbuilder = (WNBiomeBuilder)builder;
        if (wnbuilder.getFog() == null) {
            wnbuilder.fog(new WNBiomeBuilder.Fog(1, -1, -1.0f));
        }
        if (wnbuilder.getTopography() == null) {
            wnbuilder.topography(wnbuilder.getUnknownTopography());
        }
        if (wnbuilder.getClimate() == null) {
            wnbuilder.climate(wnbuilder.getUnknownClimate());
        }
        return wnbuilder;
    }

    public WNBiome(String name, WNBiomeBuilder biomeBuilder) {
        super(biomeBuilder.getBiomeBuilder());
        this.wnBiomeBuilder = biomeBuilder;
        this.setRegistryName(Main.RegistryEvents.location(name));
        WNBiomes.registerBiomes.add(this);
        WNBiomes.biomesString.add(this.getRegistryName().func_110623_a());
    }

    public void applyPlants() {
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new PlantFeature(NoFeatureConfig::func_214639_a, this.plants), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(this.plantRate)));
    }

    public void applyTrees() {
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new TreeFeature(NoFeatureConfig::func_214639_a, this.trees), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(this.treeRate, this.treeExtraChance, this.treeExtra)));
    }

    public int getCelsiusTemperature(float temp) {
        return (int)(temp * 100.0f) - 15;
    }

    public int customColor(double noise, double modifier, int color1, int color2) {
        return noise < modifier ? color1 : color2;
    }

    public int customColor3x(double noise, double modFrom, double modTo, int color1, int color2, int color3) {
        if (noise < modFrom) {
            return color1;
        }
        if (noise > modTo) {
            return color2;
        }
        return color3;
    }
}

