/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.setup;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class WNBiomeBuilder
extends Biome.Builder {
    @Nullable
    private ConfiguredSurfaceBuilder<?> surfaceBuilder;
    @Nullable
    private Biome.RainType precipitation;
    @Nullable
    private Biome.Category category;
    @Nullable
    private Topography topography;
    @Nullable
    private Climate climate;
    @Nullable
    private Float depth;
    @Nullable
    private Float scale;
    @Nullable
    private Float heightVariation;
    @Nullable
    private Float temperature;
    @Nullable
    private Float downfall;
    @Nullable
    private Integer waterColor;
    @Nullable
    private Integer waterFogColor;
    @Nullable
    private Fog fog;
    @Nullable
    private String parent;

    public Biome.Builder getBiomeBuilder() {
        return new Biome.Builder().func_205416_a(this.surfaceBuilder).func_205415_a(this.precipitation).func_205419_a(this.category).func_205421_a(this.depth.floatValue()).func_205420_b(this.scale.floatValue()).func_205414_c(this.temperature.floatValue()).func_205417_d(this.downfall.floatValue()).func_205412_a(this.waterColor.intValue()).func_205413_b(this.waterFogColor.intValue()).func_205418_a(this.parent);
    }

    public <SC extends ISurfaceBuilderConfig> WNBiomeBuilder surfaceBuilder(SurfaceBuilder<SC> p_222351_1_, SC p_222351_2_) {
        this.surfaceBuilder = new ConfiguredSurfaceBuilder(p_222351_1_, p_222351_2_);
        return this;
    }

    public WNBiomeBuilder surfaceBuilder(ConfiguredSurfaceBuilder<?> surfaceBuilderIn) {
        this.surfaceBuilder = surfaceBuilderIn;
        return this;
    }

    public WNBiomeBuilder precipitation(Biome.RainType precipitationIn) {
        this.precipitation = precipitationIn;
        return this;
    }

    public WNBiomeBuilder category(Biome.Category biomeCategory) {
        this.category = biomeCategory;
        return this;
    }

    public WNBiomeBuilder topography(Topography biometopography) {
        this.topography = biometopography;
        return this;
    }

    public WNBiomeBuilder climate(Climate biomeClimate) {
        this.climate = biomeClimate;
        return this;
    }

    public WNBiomeBuilder depth(float depthIn) {
        this.depth = Float.valueOf(depthIn);
        return this;
    }

    public WNBiomeBuilder scale(float scaleIn) {
        this.scale = Float.valueOf(scaleIn);
        return this;
    }

    public WNBiomeBuilder heightVariation(float heightVariation) {
        this.heightVariation = Float.valueOf(heightVariation);
        return this;
    }

    public WNBiomeBuilder temperature(float temperatureIn) {
        this.temperature = Float.valueOf(temperatureIn);
        return this;
    }

    public WNBiomeBuilder downfall(float downfallIn) {
        this.downfall = Float.valueOf(downfallIn);
        return this;
    }

    public WNBiomeBuilder waterColor(int waterColorIn) {
        this.waterColor = waterColorIn;
        return this;
    }

    public WNBiomeBuilder waterFogColor(int waterFogColorIn) {
        this.waterFogColor = waterFogColorIn;
        return this;
    }

    public WNBiomeBuilder fog(Fog fog) {
        this.fog = fog;
        return this;
    }

    public WNBiomeBuilder parent(@Nullable String parentIn) {
        this.parent = parentIn;
        return this;
    }

    public String toString() {
        return "WNBiomeBuilder{\nsurfaceBuilder=" + this.surfaceBuilder + ",\nprecipitation=" + this.precipitation + ",\nbiomeCategory=" + this.category + ",\ntopography=" + (Object)((Object)this.topography) + ",\nclimate=" + (Object)((Object)this.climate) + ",\ndepth=" + this.depth + ",\nscale=" + this.scale + ",\ntemperature=" + this.temperature + ",\ndownfall=" + this.downfall + ",\nwaterColor=" + this.waterColor + ",\nwaterFogColor=" + this.waterFogColor + ",\nparent='" + this.parent + '\'' + "\n" + '}';
    }

    @Nullable
    public Float getHeightVariation() {
        return this.heightVariation;
    }

    @Nullable
    public Float getScale() {
        return this.scale;
    }

    @Nullable
    public Float getDepth() {
        return this.depth;
    }

    @Nullable
    public Climate getClimate() {
        return this.climate;
    }

    @Nullable
    public Topography getTopography() {
        return this.topography;
    }

    @Nullable
    public Fog getFog() {
        return this.fog;
    }

    public Climate getUnknownClimate() {
        return Climate.CONTINENTAL_COOL;
    }

    public Topography getUnknownTopography() {
        return Topography.LOWLANDS;
    }

    public static enum Topography {
        NONE("none"),
        LOWLANDS("lowlands"),
        HIGHLANDS("highlands"),
        LOW_MOUNTAINS("low_mountains"),
        HIGH_MOUNTAINS("high_mountains"),
        LAKE_DISTRICT("lake_district"),
        SEA_DISTRICT("sea_district"),
        BASIN("basin");

        private static final Map<String, Topography> BY_NAME;
        private final String name;

        private Topography(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Topography.values()).collect(Collectors.toMap(Topography::getName, name -> name));
        }
    }

    public static enum Climate {
        NONE("none"),
        POLAR("polar"),
        SUBPOLAR("subpolar"),
        CONTINENTAL_COOL("cool_continental"),
        OCEANIC_COOL("cool_oceanic"),
        CONTINENTAL_WARM("warm_continental"),
        OCEANIC_WARM("warm_oceanic"),
        DRY_SUBTROPICAL("dry_subtropical"),
        MOIST_SUBTROPICAL("moist_subtropical"),
        DRY_TROPICAL("dry_tropical"),
        MOIST_TROPICAL("moist_tropical");

        private static final Map<String, Climate> BY_NAME;
        private final String name;

        private Climate(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Climate.values()).collect(Collectors.toMap(Climate::getName, name -> name));
        }
    }

    public static class Fog {
        private int fogStatus;
        private int color;
        private double density;
        private int defaultColor = 0xFFFFFF;
        private float defaultDensity = 0.1f;

        public Fog(int fogStatus, int color, float density) {
            this.fogStatus = fogStatus;
            this.color = color;
            this.density = density;
            if (color == -1) {
                this.color = this.defaultColor;
            }
            if (density == -1.0f) {
                this.density = this.defaultDensity;
            }
        }
    }
}

