/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.setup;

import com.matez.wildnature.Main;
import com.matez.wildnature.blocks.FloweringBushBase;
import com.matez.wildnature.blocks.RockBase;
import com.matez.wildnature.blocks.SaltOreBlock;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.lists.WNBlocks;
import com.matez.wildnature.other.BlockWeighList;
import com.matez.wildnature.other.TreeWeighList;
import com.matez.wildnature.world.gen.biomes.setup.WNBiome;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomes;
import com.matez.wildnature.world.gen.feature.CaveBushFeature;
import com.matez.wildnature.world.gen.feature.CaveStarFeature;
import com.matez.wildnature.world.gen.feature.CaveVineFeature;
import com.matez.wildnature.world.gen.feature.CobwebFeature;
import com.matez.wildnature.world.gen.feature.CrystalFeature;
import com.matez.wildnature.world.gen.feature.DoubleCaveBushFeature;
import com.matez.wildnature.world.gen.feature.DoubleGrassFeature;
import com.matez.wildnature.world.gen.feature.JellyshroomFeature;
import com.matez.wildnature.world.gen.feature.LavalilyFeature;
import com.matez.wildnature.world.gen.feature.PebbleFeature;
import com.matez.wildnature.world.gen.feature.ReedsFeature;
import com.matez.wildnature.world.gen.feature.RiverCaneFeature;
import com.matez.wildnature.world.gen.feature.ScatteredPlantFeature;
import com.matez.wildnature.world.gen.feature.ShellFeature;
import com.matez.wildnature.world.gen.feature.SinglePlantFeature;
import com.matez.wildnature.world.gen.feature.SlimeCaveBushFeature;
import com.matez.wildnature.world.gen.feature.StalagmiteFeature;
import com.matez.wildnature.world.gen.feature.TreeFeature;
import com.matez.wildnature.world.gen.feature.UnderwaterCaveBushFeature;
import com.matez.wildnature.world.gen.feature.WNCaveCarver;
import com.matez.wildnature.world.gen.feature.WNFruitFeature;
import com.matez.wildnature.world.gen.feature.WNMossFeature;
import com.matez.wildnature.world.gen.feature.WNOreFeature;
import com.matez.wildnature.world.gen.feature.WNOreFeatureConfig;
import com.matez.wildnature.world.gen.feature.WNVegeFeature;
import com.matez.wildnature.world.gen.feature.WNVinesFeature;
import com.matez.wildnature.world.gen.feature.WaterlilyFeature;
import com.matez.wildnature.world.gen.structures.nature.rocks.basalt_rock;
import com.matez.wildnature.world.gen.structures.nature.rocks.conglomerate_rock;
import com.matez.wildnature.world.gen.structures.nature.rocks.gneiss_rock;
import com.matez.wildnature.world.gen.structures.nature.rocks.slate_rock;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_birch1;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_birch2;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_ebony1;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_ebony2;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_ebony3;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_oak1;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_oak2;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_oak3;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_oak4;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_pointy_birch1;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_pointy_birch2;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_pointy_birch3;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_pointy_birch4;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_spruce1;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_spruce2;
import com.matez.wildnature.world.gen.structures.nature.woods.fallen.fallen_spruce3;
import com.matez.wildnature.world.gen.structures.nature.woods.glowing_cave_oak.GlowingCaveOakSpawner;
import com.matez.wildnature.world.gen.structures.nature.woods.glowshroom.GlowshroomSpawner;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.state.IProperty;
import net.minecraft.world.biome.BeachBiome;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.DoublePlantConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.GrassFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;

public class WNBiomeFeatures
extends DefaultBiomeFeatures {
    public static ArrayList<Biome> defaultPlantBlacklist = new ArrayList();
    public static ArrayList<Biome> lakeBiomes = new ArrayList();
    public static ArrayList<Biome> springBiomes = new ArrayList();

    public static void removeAllDefaultFlowers(Biome biomeIn) {
        defaultPlantBlacklist.add(biomeIn);
    }

    public static void addBerryBushes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new ScatteredPlantFeature(NoFeatureConfig::func_214639_a, (BlockState)Blocks.field_222434_lW.func_176223_P().func_206870_a((IProperty)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3))), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addGrass(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(9)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Main.getBlockByID("wildnature:medium_grass").func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(3)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Main.getBlockByID("wildnature:small_grass").func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addLotsOfGrass(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(14)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Main.getBlockByID("wildnature:medium_grass").func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(6)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Main.getBlockByID("wildnature:small_grass").func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(5)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new DoubleGrassFeature(DoublePlantConfig::func_214694_a), (IFeatureConfig)new DoublePlantConfig(Blocks.field_196804_gh.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(5)));
    }

    public static void addMushrooms(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Blocks.field_150338_P.func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Blocks.field_150337_Q.func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(4)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom1").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom2").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom4").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(4)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom5").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(4)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom6").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom7").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom8").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom9").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:psilocybin_mushroom").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(1)));
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:mushroom3").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:fuzzball").func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(1)));
    }

    public static void addLakes(Biome biomeIn) {
        lakeBiomes.add(biomeIn);
    }

    public static void addSprings(Biome p_222337_0_) {
        springBiomes.add(p_222337_0_);
    }

    public static void addGrass(Biome biomeIn, int rate) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(Blocks.field_150349_c.func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(rate)));
    }

    public static void addGrass(Biome biomeIn, int rate, BlockState grass) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(grass), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(rate)));
    }

    public static void addGrass(Biome biomeIn, int rate, BlockState grass, boolean isDouble) {
        if (isDouble) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new DoubleGrassFeature(DoublePlantConfig::func_214694_a), (IFeatureConfig)new DoublePlantConfig(grass), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(rate)));
        } else {
            WNBiomeFeatures.addGrass(biomeIn, rate, grass);
        }
    }

    public static void addPlant(Biome biomeIn, BlockState state, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).plants.add(state, frequency);
        }
    }

    public static void addDoublePlant(Biome biomeIn, BlockState state, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).plants.add(state, frequency);
        }
    }

    public static void addWaterlilies(Biome biome, Block waterlily, int count) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new WaterlilyFeature(NoFeatureConfig::func_214639_a, waterlily), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(count)));
    }

    public static void addTree(Biome biomeIn, AbstractTreeFeature tree, int frequency) {
        if (biomeIn instanceof WNBiome) {
            ((WNBiome)biomeIn).trees.add(tree, frequency);
        }
    }

    public static void addNewStoneVariants(Biome biomeIn) {
        int seaLevel = 40;
        int worldHeight = 255;
        ArrayList<Block> rocks = new ArrayList<Block>(Arrays.asList(Main.RegistryEvents.rockRegistry.rocks));
        for (int i = 0; i < rocks.size(); ++i) {
            Block b = Main.getBlockByID(rocks.get(i).getRegistryName().toString());
            RockBase r = null;
            if (!(b instanceof RockBase)) continue;
            r = (RockBase)b;
            if (b.getRegistryName().toString().equals("wildnature:hardened_sandstone") || b.getRegistryName().toString().equals("wildnature:red_hardened_sandstone")) continue;
            if (b.getRegistryName().toString().equals("wildnature:frozen_stone")) {
                if (biomeIn.func_150561_m() != Biome.TempCategory.COLD) continue;
                continue;
            }
            if (!((Boolean)CommonConfig.generateRocks.get()).booleanValue()) continue;
            boolean gen = true;
            if (!((Boolean)CommonConfig.genBasalt.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("basalt")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genConglomerate.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("conglomerate")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genGneiss.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("gneiss")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genLimestone.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("limestone")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genMarble.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("marble")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genPegmatite.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("pegmatite")) {
                gen = false;
            }
            if (!((Boolean)CommonConfig.genSlate.get()).booleanValue() && r.getRegistryName().func_110623_a().equals("slate")) {
                gen = false;
            }
            if (!gen) continue;
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, b.func_176223_P(), r.getSize()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(r.getCount(), r.getMinYByType(seaLevel), 0, r.getMaxYByType(seaLevel, worldHeight))));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150403_cj.func_176223_P(), (Integer)CommonConfig.rockSize.get() * 2), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.rockChance.get()).intValue(), 25, 0, seaLevel - seaLevel / 4)));
        }
        rocks = null;
    }

    public static void addCarvers(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new WNCaveCarver(ProbabilityConfig::func_214645_a, 256), (ICarverConfig)new ProbabilityConfig(0.14285715f)));
    }

    public static void addCaveVines(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE)) {
            if (biomeIn != WNBiomes.Polders) {
                biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveVineFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 10, 0, 35)));
                biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new WNVinesFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Blocks.field_150395_bd.func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 10, 0, 35)));
            }
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveVineFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 10, 0, 35)));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.MEDIUM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveVineFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 10, 0, 35)));
        }
    }

    public static void addCrystals(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CrystalFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 10, 0, 35)));
        }
    }

    public static void addCobweb(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CobwebFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(30, 10, 0, 35)));
        }
    }

    public static void addStalagmites(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new StalagmiteFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(100, 10, 0, 50)));
        }
    }

    public static void addPebbles(Biome biomeIn) {
        if (biomeIn != WNBiomes.Polders) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new PebbleFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(70, 10, 0, 50)));
        }
    }

    public static void addNewOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.TIN_ORE.func_176223_P(), 7), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.tinRarity.get()).intValue(), 40, 0, 64)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.COPPER_ORE.func_176223_P(), 6), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.copperRarity.get()).intValue(), 0, 0, 30)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, (BlockState)WNBlocks.SALT_ORE.func_176223_P().func_206870_a(SaltOreBlock.SALT_VARIANT, (Comparable)((Object)SaltOreBlock.SaltVariant.STONE)), 5), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.saltStoneRarity.get()).intValue(), 20, 0, 55)));
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.AMETHYST_ORE.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.amethystRarity.get()).intValue(), 10, 0, 28)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.MEDIUM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.SAPPHIRE_ORE.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.sapphireRarity.get()).intValue(), 10, 0, 28)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.MALACHITE_ORE.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.malachiteRarity.get()).intValue(), 10, 0, 28)));
        }
        if (biomeIn instanceof BeachBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)new WNOreFeature(WNOreFeatureConfig::deserialize), (IFeatureConfig)new WNOreFeatureConfig(WNOreFeatureConfig.FillerBlockType.SAND, WNBlocks.AMBER_ORE.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.amberRarity.get()).intValue(), 50, 0, 65)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)new WNOreFeature(WNOreFeatureConfig::deserialize), (IFeatureConfig)new WNOreFeatureConfig(WNOreFeatureConfig.FillerBlockType.SAND, (BlockState)WNBlocks.SALT_ORE.func_176223_P().func_206870_a(SaltOreBlock.SALT_VARIANT, (Comparable)((Object)SaltOreBlock.SaltVariant.SAND)), 7), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.saltSandRarity.get()).intValue(), 50, 0, 65)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.RUBY_ORE.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.rubyRarity.get()).intValue(), 0, 0, 15)));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, WNBlocks.SILVER_ORE.func_176223_P(), 6), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.silverRarity.get()).intValue(), 20, 0, 36)));
    }

    public static void addRockFormations(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new basalt_rock(NoFeatureConfig::func_214639_a, true), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 64, 0, 80)));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new conglomerate_rock(NoFeatureConfig::func_214639_a, true), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 64, 0, 80)));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new gneiss_rock(NoFeatureConfig::func_214639_a, true), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 64, 0, 80)));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new slate_rock(NoFeatureConfig::func_214639_a, true), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 64, 0, 80)));
    }

    public static void addRiverCane(Biome biomeIn) {
        if (biomeIn.func_76736_e() || BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.RIVER) || biomeIn == WNBiomes.River || biomeIn == WNBiomes.AmazonRiver || biomeIn == WNBiomes.NileRiver || biomeIn == WNBiomes.TropicalLake || biomeIn == WNBiomes.WarmLake || biomeIn == WNBiomes.MangroveForest) {
            biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new RiverCaneFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.riverCaneRarity.get()).intValue(), 55, 0, 65)));
        }
    }

    public static void addRiverPlants(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.RIVER) || biomeIn == WNBiomes.River || biomeIn == WNBiomes.AmazonRiver || biomeIn == WNBiomes.NileRiver || biomeIn == WNBiomes.TropicalLake || biomeIn == WNBiomes.WarmLake || biomeIn == WNBiomes.ColdLake) {
            biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)new ReedsFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.riverCaneRarity.get()).intValue(), 55, 0, 65)));
        }
    }

    public static void addFruits(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new WNFruitFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.fruitBushRarity.get()).intValue(), 64, 0, 100)));
    }

    public static void addVeggies(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new WNVegeFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.vegeCropRarity.get()).intValue(), 64, 0, 100)));
    }

    public static void addPoisonIves(Biome biomeIn) {
        BlockWeighList l = new BlockWeighList();
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            l.add((BlockState)Main.getBlockByID("wildnature:poison_ivy").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
            l.add((BlockState)Main.getBlockByID("wildnature:spidergrass").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM || biomeIn.func_150561_m() == Biome.TempCategory.MEDIUM) {
            l.add((BlockState)Main.getBlockByID("wildnature:grass_thistle").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 1);
        }
        if (biomeIn.func_150561_m() != Biome.TempCategory.COLD) {
            l.add((BlockState)Main.getBlockByID("wildnature:nettle").func_176223_P().func_206870_a((IProperty)FloweringBushBase.FLOWERING, (Comparable)Boolean.valueOf(true)), 2);
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new SinglePlantFeature(NoFeatureConfig::func_214639_a, l, 5), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(((Integer)CommonConfig.poisonIvyRarity.get()).intValue())));
    }

    public static void addSmallCacti(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.SANDY) && biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn != Biomes.field_76787_r && biomeIn != WNBiomes.TintedDesert && biomeIn != WNBiomes.TintedDesertHills || biomeIn == WNBiomes.WhiteBeach || biomeIn == WNBiomes.Oasis) {
            BlockWeighList l = new BlockWeighList();
            l.add(Main.getBlockByID("wildnature:small_cacti").func_176223_P(), 1);
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new SinglePlantFeature(NoFeatureConfig::func_214639_a, l, 0), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(((Integer)CommonConfig.smallCactiRarity.get()).intValue())));
        }
    }

    public static void addCavePlants(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:icycle").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 35, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:large_icycle").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 40, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:ice_grass").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(35, 30, 0, 45)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:ice_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(5, 30, 0, 45)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 10, 0, 45)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_blue").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_green").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_blue").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_green").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:sunshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 10, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new LavalilyFeature(NoFeatureConfig::func_214639_a, WNBlocks.MAGMA_PAD), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(5, 2, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveStarFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:cave_star").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 15, 0, 23)));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(11, 10, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new DoubleCaveBushFeature(BushConfig::func_214685_a, false), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:large_glowshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 10, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_blue").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:hanging_glowing_slimeshroom_green").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_blue").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new SlimeCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowing_slimeshroom_green").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:sunshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 10, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new LavalilyFeature(NoFeatureConfig::func_214639_a, WNBlocks.MAGMA_PAD), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 2, 0, 20)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:poison_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 10, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:sulfur_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 20, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:dragon_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 10, 0, 15)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:gravityshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 5, 0, 20)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveStarFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:cave_star").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 15, 0, 23)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:sulfur_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 20, 0, 50)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:dragon_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 10, 0, 15)));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new JellyshroomFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:jellyshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 2, 0, 15)));
        }
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:stone_grass").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(40, 10, 0, 50)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:stalagmite").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 10, 0, 50)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:stalactite").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 10, 0, 50)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new DoubleCaveBushFeature(BushConfig::func_214685_a, false), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:large_stalagmite").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 10, 0, 50)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new DoubleCaveBushFeature(BushConfig::func_214685_a, true), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:large_stalactite").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 10, 0, 50)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:roots").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 55, 0, 52)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new DoubleCaveBushFeature(BushConfig::func_214685_a, true), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:large_root").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 55, 0, 52)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:magma_shroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 5, 0, 16)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:glowing_shadowshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 3, 0, 10)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new CaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:cave_lily").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 5, 0, 20)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new UnderwaterCaveBushFeature(BushConfig::func_214685_a), (IFeatureConfig)new BushConfig(Main.getBlockByID("wildnature:tubeshroom").func_176223_P()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 2, 0, 12)));
    }

    public static void addGlowingCaveOaks(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, true), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 5, 0, 35)));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn.func_201856_r() != Biome.Category.DESERT && biomeIn.func_201856_r() != Biome.Category.MESA) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, false), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 5, 0, 35)));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new GlowingCaveOakSpawner(NoFeatureConfig::func_214639_a, false, false), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 5, 0, 35)));
        }
    }

    public static void addGlowshrooms(Biome biomeIn) {
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM && biomeIn.func_201856_r() != Biome.Category.DESERT && biomeIn.func_201856_r() != Biome.Category.MESA) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new GlowshroomSpawner(NoFeatureConfig::func_214639_a, false), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(7, 5, 0, 45)));
        } else if (biomeIn.func_150561_m() == Biome.TempCategory.OCEAN) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new GlowshroomSpawner(NoFeatureConfig::func_214639_a, false), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 5, 0, 35)));
        }
    }

    public static void addShells(Biome biomeIn) {
        if (biomeIn == Biomes.field_76787_r || biomeIn == WNBiomes.WhiteBeach) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new ShellFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.shellRarity.get()).intValue(), 50, 0, 69)));
        }
    }

    public static void addMoss(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new WNMossFeature(CountConfig::func_214687_a), (IFeatureConfig)new CountConfig(32), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarityDense.get()).intValue(), 64, 0, 180)));
        } else if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new WNMossFeature(CountConfig::func_214687_a), (IFeatureConfig)new CountConfig(12), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarity.get()).intValue(), 64, 0, 180)));
        }
        if (biomeIn.func_150561_m() == Biome.TempCategory.WARM) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)new WNMossFeature(CountConfig::func_214687_a), (IFeatureConfig)new CountConfig(64), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(((Integer)CommonConfig.mossRarityDense.get()).intValue(), 10, 0, 40)));
        }
    }

    public static void addFallenTrees(Biome biomeIn) {
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST)) {
            Main.LOGGER.info("Adding fallen trees for " + biomeIn.getRegistryName());
            boolean isDense = BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE);
            boolean isConiferous = BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.CONIFEROUS);
            Biome.Category category = biomeIn.func_201856_r();
            TreeWeighList trees = new TreeWeighList();
            if (biomeIn == WNBiomes.Madagascar || biomeIn == WNBiomes.DaintreeForest) {
                trees.add(new fallen_ebony1(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_ebony2(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_ebony3(NoFeatureConfig::func_214639_a, true), 1);
            } else if (biomeIn == WNBiomes.WeepingBirchForest || biomeIn == WNBiomes.BirchGrove || biomeIn == WNBiomes.BirchMarsh || biomeIn == WNBiomes.BirchScrubs || biomeIn == WNBiomes.SnowyBirchGrove) {
                trees.add(new fallen_birch1(NoFeatureConfig::func_214639_a, true), 2);
                trees.add(new fallen_birch2(NoFeatureConfig::func_214639_a, true), 2);
                trees.add(new fallen_pointy_birch1(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_pointy_birch2(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_pointy_birch3(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_pointy_birch4(NoFeatureConfig::func_214639_a, true), 1);
            } else if (category == Biome.Category.TAIGA) {
                trees.add(new fallen_spruce1(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_spruce2(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_spruce3(NoFeatureConfig::func_214639_a, true), 1);
            } else if (category == Biome.Category.PLAINS) {
                trees.add(new fallen_oak1(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_oak2(NoFeatureConfig::func_214639_a, true), 1);
                trees.add(new fallen_oak3(NoFeatureConfig::func_214639_a, true), 1);
            } else if (category == Biome.Category.FOREST) {
                if (isConiferous) {
                    trees.add(new fallen_spruce1(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_spruce2(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_spruce3(NoFeatureConfig::func_214639_a, true), 1);
                } else {
                    trees.add(new fallen_oak1(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_oak2(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_oak3(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_oak4(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_birch1(NoFeatureConfig::func_214639_a, true), 1);
                    trees.add(new fallen_birch2(NoFeatureConfig::func_214639_a, true), 1);
                }
            }
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new TreeFeature(NoFeatureConfig::func_214639_a, trees), (IFeatureConfig)new NoFeatureConfig(), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(isDense ? 1 : 0, isDense ? 0.02f : 0.3f, isDense ? 5 : 1)));
        }
    }

    public static void addDefaultFlowersForBiome(Biome biomeIn) {
        if (defaultPlantBlacklist.contains(biomeIn)) {
            return;
        }
        Biome.TempCategory category = biomeIn.func_150561_m();
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS)) {
            if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.DENSE)) {
                if (category == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_BLUE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PINK.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PURPLE.func_176223_P(), 1);
                } else {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_PINK.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_PURPLE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_WHITE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.ANEMONE.func_176223_P(), 2);
                if (category == Biome.TempCategory.MEDIUM) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_BLUE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_BLUE.func_176223_P(), 1);
                if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SNOWDROP.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BLUEBELL.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_PURPLE.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATH_WHITE.func_176223_P(), 2);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GRASS_FERNSPROUT.func_176223_P(), 3);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 4);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB_TALL.func_176223_P(), 4);
            } else {
                if (category == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PURPLE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEPATICA_VIOLET.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 1);
                } else {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_YELLOW.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PASQUE_WHITE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.ANEMONE.func_176223_P(), 1);
                if (category == Biome.TempCategory.MEDIUM) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.PRIMROSE_PINK.func_176223_P(), 2);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_PINK.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GRASS_FERNSPROUT.func_176223_P(), 3);
                if (biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SNOWDROP.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BLUEBELL.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_PURPLE.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_PINK.func_176223_P(), 2);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_WHITE.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.HEATHER_YELLOW.func_176223_P(), 1);
                    WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 1);
                }
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 2);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB_TALL.func_176223_P(), 2);
            }
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.WILD_ROSE.func_176223_P(), 1);
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.JUNGLE)) {
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CHAMOMILE_WHITE.func_176223_P(), 2);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CHAMOMILE_DOUBLE_WHITE.func_176223_P(), 1);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GOLDENROD.func_176223_P(), 3);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.TANSY.func_176223_P(), 1);
            if (category == Biome.TempCategory.MEDIUM) {
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.CATNIP.func_176223_P(), 2);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BUTTERCUP_YELLOW.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.FORGET_ME_NOT_WHITE.func_176223_P(), 1);
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.GIANT_HOGWEED.func_176223_P(), 2);
            }
            if (category == Biome.TempCategory.COLD) {
                WNBiomeFeatures.addPlant(biomeIn, WNBlocks.VIOLET_PURPLE.func_176223_P(), 2);
            }
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.BOXWOOD.func_176223_P(), 3);
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.SHRUB.func_176223_P(), 1);
        }
        if (BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.PLAINS) && BiomeDictionary.getTypes((Biome)biomeIn).contains(BiomeDictionary.Type.WET)) {
            WNBiomeFeatures.addPlant(biomeIn, WNBlocks.MISCANTHUS_GRASS.func_176223_P(), 2);
        }
    }
}

