/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.setup;

import com.matez.wildnature.Main;
import com.matez.wildnature.customizable.CommonConfig;
import com.matez.wildnature.world.gen.biomes.setup.WNBiomeFeatures;
import com.matez.wildnature.world.gen.feature.WNFruitFeature;
import com.matez.wildnature.world.gen.feature.WNVegeFeature;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;

public class WNGlobalBiomeFeatures {
    public static void setup() {
        WNFruitFeature.init();
        WNVegeFeature.init();
        Registry.field_212624_m.forEach(biome -> {
            WNBiomeFeatures.addMushrooms(biome);
            WNBiomeFeatures.addDefaultFlowersForBiome(biome);
            if (((Boolean)CommonConfig.generateVines.get()).booleanValue()) {
                WNBiomeFeatures.addCaveVines(biome);
            }
            if (((Boolean)CommonConfig.generateCrystals.get()).booleanValue()) {
                WNBiomeFeatures.addCrystals(biome);
            }
            if (((Boolean)CommonConfig.generateStalagmites.get()).booleanValue()) {
                WNBiomeFeatures.addStalagmites(biome);
            }
            if (((Boolean)CommonConfig.generatePebbles.get()).booleanValue()) {
                WNBiomeFeatures.addPebbles(biome);
            }
            if (((Boolean)CommonConfig.generateCobweb.get()).booleanValue()) {
                WNBiomeFeatures.addCobweb(biome);
            }
            if (((Boolean)CommonConfig.generateRockFormations.get()).booleanValue()) {
                WNBiomeFeatures.addRockFormations(biome);
            }
            if (((Boolean)CommonConfig.generateFruitBushes.get()).booleanValue()) {
                WNBiomeFeatures.addFruits(biome);
            }
            if (((Boolean)CommonConfig.generateVegeCrops.get()).booleanValue()) {
                WNBiomeFeatures.addVeggies(biome);
            }
            if (((Boolean)CommonConfig.generatePoisonIves.get()).booleanValue()) {
                WNBiomeFeatures.addPoisonIves(biome);
            }
            if (((Boolean)CommonConfig.generateOres.get()).booleanValue()) {
                WNBiomeFeatures.addNewOres(biome);
            }
            if (((Boolean)CommonConfig.generateUndergroundPlants.get()).booleanValue()) {
                WNBiomeFeatures.addCavePlants(biome);
            }
            if (((Boolean)CommonConfig.generateRiverCanes.get()).booleanValue()) {
                WNBiomeFeatures.addRiverCane(biome);
                WNBiomeFeatures.addRiverPlants(biome);
            }
            if (((Boolean)CommonConfig.generateSmallCacti.get()).booleanValue()) {
                WNBiomeFeatures.addSmallCacti(biome);
            }
            if (((Boolean)CommonConfig.replaceDefaultTrees.get()).booleanValue()) {
                WNGlobalBiomeFeatures.replaceDefaultFeatures(biome);
            }
            if (((Boolean)CommonConfig.generateShells.get()).booleanValue()) {
                WNBiomeFeatures.addShells(biome);
            }
            if (((Boolean)CommonConfig.generateMoss.get()).booleanValue()) {
                WNBiomeFeatures.addMoss(biome);
            }
            if (((Boolean)CommonConfig.generateGlowingCaveOaks.get()).booleanValue()) {
                WNBiomeFeatures.addGlowingCaveOaks(biome);
            }
            if (((Boolean)CommonConfig.generateBigGlowshrooms.get()).booleanValue()) {
                WNBiomeFeatures.addGlowshrooms(biome);
            }
            if (((Boolean)CommonConfig.generateFallenTrees.get()).booleanValue()) {
                WNBiomeFeatures.addFallenTrees(biome);
            }
            if (((Boolean)CommonConfig.generateUndergroundRivers.get()).booleanValue()) {
                // empty if block
            }
        });
        for (Biome biome2 : WNBiomeFeatures.lakeBiomes) {
            if (((Boolean)CommonConfig.waterLakeGeneration.get()).booleanValue()) {
                Main.LOGGER.info("adding water for " + biome2.getRegistryName());
                biome2.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)Feature.field_202289_ai, (IFeatureConfig)new LakesConfig(Blocks.field_150355_j.func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(4)));
            }
            if (!((Boolean)CommonConfig.lavaLakeGeneration.get()).booleanValue()) continue;
            Main.LOGGER.info("adding lava for " + biome2.getRegistryName());
            biome2.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)Feature.field_202289_ai, (IFeatureConfig)new LakesConfig(Blocks.field_150353_l.func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(80)));
        }
        for (Biome biome2 : WNBiomeFeatures.springBiomes) {
            if (((Boolean)CommonConfig.waterSpringGeneration.get()).booleanValue()) {
                biome2.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202295_ao, (IFeatureConfig)new LiquidsConfig(Fluids.field_204546_a.func_207188_f()), (Placement)Placement.field_215029_o, (IPlacementConfig)new CountRangeConfig(50, 8, 8, 256)));
            }
            if (!((Boolean)CommonConfig.lavaSpringGeneration.get()).booleanValue()) continue;
            biome2.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202295_ao, (IFeatureConfig)new LiquidsConfig(Fluids.field_204547_b.func_207188_f()), (Placement)Placement.field_215030_p, (IPlacementConfig)new CountRangeConfig(20, 8, 16, 256)));
        }
    }

    private static void replaceDefaultFeatures(Biome biome) {
        for (ConfiguredFeature feature : biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION)) {
            if (((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222737_a.getClass() != Feature.field_202340_r.getClass()) continue;
        }
    }

    private static void removeLakesAndSprings(Biome biome) {
        int index = 0;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (ConfiguredFeature feature : biome.func_203607_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS)) {
            if (((DecoratedFeatureConfig)feature.field_222738_b).field_214689_a.field_222737_a == Feature.field_202289_ai) {
                if (((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b instanceof LakesConfig) {
                    if (((LakesConfig)((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b).field_214713_a == Blocks.field_150355_j.func_176223_P() && ((Boolean)CommonConfig.waterLakeGeneration.get()).booleanValue()) {
                        toRemove.add(index);
                    }
                    if (((LakesConfig)((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b).field_214713_a == Blocks.field_150353_l.func_176223_P() && ((Boolean)CommonConfig.lavaLakeGeneration.get()).booleanValue()) {
                        toRemove.add(index);
                    }
                }
                if (((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b instanceof LiquidsConfig) {
                    if (((LiquidsConfig)((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b).field_214678_a == Fluids.field_204546_a.func_207188_f() && ((Boolean)CommonConfig.waterSpringGeneration.get()).booleanValue()) {
                        toRemove.add(index);
                    }
                    if (((LiquidsConfig)((DecoratedFeatureConfig)feature.field_222738_b).field_214690_b.field_215097_b).field_214678_a == Fluids.field_204547_b.func_207188_f() && ((Boolean)CommonConfig.lavaSpringGeneration.get()).booleanValue()) {
                        toRemove.add(index);
                    }
                }
            }
            ++index;
        }
        Iterator iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            int integer = (Integer)iterator.next();
            biome.func_203607_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS).remove(integer);
        }
    }
}

