/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.biomes.undergroundBiomes.setup;

import com.matez.wildnature.other.Utilities;
import com.matez.wildnature.world.gen.biomes.undergroundBiomes.setup.builders.URDefaultBiomeBuilder;
import com.matez.wildnature.world.gen.noise.sponge.module.source.Perlin;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class URBiome {
    public Biome.Category category;
    public Biome.TempCategory tempCategory;
    public String name;
    public int waterColor;
    public int waterFogColor;
    public int rarity;
    public float fogDensity;
    public Perlin elevationNoise = new Perlin();

    public URBiome(String name, @Nullable Biome.Category category, @Nullable Biome.TempCategory tempCategory, int rarity, float fogDensity, int waterColor, int waterFogColor) {
        this.name = name;
        this.category = category;
        this.tempCategory = tempCategory;
        this.rarity = rarity;
        this.fogDensity = fogDensity;
        this.waterColor = waterColor;
        this.waterFogColor = waterFogColor;
        this.elevationNoise.setFrequency(0.1);
        this.elevationNoise.setLacunarity(0.0);
        this.elevationNoise.setPersistence(0.0);
        this.elevationNoise.setOctaveCount(1);
    }

    public Biome.TempCategory getTempCategory() {
        return this.tempCategory;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public String getName() {
        return this.name;
    }

    public int getRarity() {
        return this.rarity;
    }

    public Biome.Category getCategory() {
        return this.category;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public BlockState getElevationBlock(long seed, Random rand, BlockPos pos) {
        return URDefaultBiomeBuilder.build(seed, rand, pos, this.elevationNoise);
    }

    public BlockState getUnderwaterBlock(long seed, Random rand, BlockPos pos) {
        return this.getElevationBlock(seed, rand, pos);
    }

    public void elevate(BlockPos pos, int a, IChunk chunkIn, Random random, long seed) {
        if (chunkIn.func_180495_p(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p())).func_177230_c() == Blocks.field_150348_b) {
            if (a > 10) {
                chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), this.getElevationBlock(seed, random, pos), false);
            } else if (a == 10) {
                if (Utilities.rint(0, 1) == 0) {
                    chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), this.getElevationBlock(seed, random, pos), false);
                } else {
                    chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), this.getUnderwaterBlock(seed, random, pos), false);
                }
            } else {
                chunkIn.func_177436_a(new BlockPos(pos.func_177958_n(), a, pos.func_177952_p()), this.getUnderwaterBlock(seed, random, pos), false);
            }
        }
    }

    public int getNoiseHeight(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight, int maxHeightIfCavern, double cavernWhenNoise, Random random, long seed, BlockPos pos) {
        return this.calculateHeightByCenter(noise, minNoise, maxNoise, minHeight, maxHeight, maxHeightIfCavern, cavernWhenNoise);
    }

    public int calculateHeightByCenter(double noise, double minNoise, double maxNoise, int minHeight, int maxHeight, int maxHeightIfCavern, double cavernWhenNoise) {
        double noiseCenter = (maxNoise - minNoise) / 2.0 + minNoise;
        double noisePercent = 0.0;
        noisePercent = noiseCenter > noise ? this.calculatePercent(noise, minNoise, noiseCenter) : (noiseCenter < noise ? (noise > cavernWhenNoise ? this.calculatePercent(noise, maxHeightIfCavern, noiseCenter) : this.calculatePercent(noise, maxHeight, noiseCenter)) : 1.0);
        int maxHeightCalc = maxHeight - minHeight;
        double height = (double)maxHeightCalc * noisePercent;
        return (int)Math.round(height) + minHeight;
    }

    private double calculatePercent(double noise, double minNoise, double maxNoise) {
        double maxNoiseCalc = maxNoise - minNoise;
        double noiseCalc = noise - minNoise;
        return noiseCalc / maxNoiseCalc;
    }
}

