/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.chunk;

import com.matez.wildnature.world.gen.noise.OpenSimplexNoise;
import com.matez.wildnature.world.gen.noise.SimplexOctavesGenerator;
import com.matez.wildnature.world.gen.noise.bukkit.SimplexOctaveGenerator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public abstract class SmoothNoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_222557_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_222557_0_[i * 24 * 24 + j * 24 + k] = (float)SmoothNoiseChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int verticalSmooth;
    private final int horizontalSmooth;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom randomSeed;
    private final SimplexOctaveGenerator simplex1;
    private final OpenSimplexNoise openSimplex;
    private final OpenSimplexNoise surfaceDepthNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;

    public SmoothNoiseChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, int horizontalNoiseGranularity, int verticalNoiseGranularity, int p_i49931_5_, T p_i49931_6_, boolean usePerlin) {
        super(worldIn, biomeProviderIn, p_i49931_6_);
        this.verticalNoiseGranularity = verticalNoiseGranularity;
        this.horizontalNoiseGranularity = horizontalNoiseGranularity;
        this.verticalSmooth = verticalNoiseGranularity;
        this.horizontalSmooth = horizontalNoiseGranularity;
        this.defaultBlock = p_i49931_6_.func_205532_l();
        this.defaultFluid = p_i49931_6_.func_205533_m();
        this.noiseSizeX = 16 / horizontalNoiseGranularity;
        this.noiseSizeY = p_i49931_5_ / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / horizontalNoiseGranularity;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.simplex1 = new SimplexOctaveGenerator((Random)this.randomSeed, 8);
        this.simplex1.setScale(0.001953125);
        this.openSimplex = new OpenSimplexNoise(worldIn.func_72905_C());
        this.surfaceDepthNoise = new OpenSimplexNoise(worldIn.func_72905_C());
    }

    private double linearInterpolate3d(double xm_ym_zm, double xp_ym_zm, double xm_yp_zm, double xp_yp_zm, double xm_ym_zp, double xp_ym_zp, double xm_yp_zp, double xp_yp_zp, double x, double y, double z) {
        return xm_ym_zm * (1.0 - x) * (1.0 - y) * (1.0 - z) + xp_ym_zm * x * (1.0 - y) * (1.0 - z) + xm_yp_zm * (1.0 - x) * y * (1.0 - z) + xp_yp_zm * x * y * (1.0 - z) + xm_ym_zp * (1.0 - x) * (1.0 - y) * z + xp_ym_zp * x * (1.0 - y) * z + xm_yp_zp * (1.0 - x) * y * z + xp_yp_zp * x * y * z;
    }

    private double useNoises(int chunkX, int chunkY, int chunkZ, double coordinateScale, double heightScale, double depthSize, double unk1) {
        double d0 = 0.0;
        double d1 = 0.0;
        double noiseY = 0.0;
        double modifier = 1.0;
        for (int i = 0; i < 16; ++i) {
            double d4 = SimplexOctavesGenerator.maintainPrecision((double)chunkX * coordinateScale * modifier);
            double d5 = SimplexOctavesGenerator.maintainPrecision(0.5 * (double)chunkY * heightScale * modifier);
            double d6 = SimplexOctavesGenerator.maintainPrecision((double)chunkZ * coordinateScale * modifier);
            if (i < 8) {
                // empty if block
            }
            modifier /= 8.0;
        }
        double lowerLimitScale = 512.0;
        double upperLimitScale = 512.0;
        double slide = 1.0;
        double result = MathHelper.func_151238_b((double)(d0 / lowerLimitScale), (double)(d1 / upperLimitScale), (double)(noiseY * slide));
        return result;
    }

    protected double[] func_222547_b(int p_222547_1_, int p_222547_2_, Biome b) {
        double[] adouble = new double[this.noiseSizeY + 1];
        this.func_222548_a(adouble, p_222547_1_, p_222547_2_, b);
        return adouble;
    }

    protected void func_222546_a(double[] adoub, int chunkX, int chunkZ, double coordinateScale, double heightScale, double depthSize, double unk1, int unk2, int unk3) {
        double[] adouble = this.func_222549_a(chunkX, chunkZ);
        double d0 = adouble[0];
        double d1 = adouble[1];
        double d2 = this.func_222551_g();
        double d3 = this.func_222553_h();
        for (int i = 0; i < this.getY(); ++i) {
            double d4 = this.useNoises(chunkX, i, chunkZ, coordinateScale, heightScale, depthSize, unk1);
            d4 -= this.func_222545_a(d0, d1, i);
            if ((double)i > d2) {
                d4 = MathHelper.func_151238_b((double)d4, (double)unk3, (double)(((double)i - d2) / (double)unk2));
            } else if ((double)i < d3) {
                d4 = MathHelper.func_151238_b((double)d4, (double)-30.0, (double)((d3 - (double)i) / (d3 - 1.0)));
            }
            adoub[i] = d4;
        }
    }

    protected abstract double[] func_222549_a(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected double func_222551_g() {
        return this.getY() - 4;
    }

    protected double func_222553_h() {
        return 0.0;
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type p_222529_3_, Biome b) {
        int horiz = this.horizontalSmooth;
        int i = Math.floorDiv(p_222529_1_, horiz);
        int j = Math.floorDiv(p_222529_2_, horiz);
        int k = Math.floorMod(p_222529_1_, horiz);
        int l = Math.floorMod(p_222529_2_, horiz);
        double d0 = (double)k / (double)horiz;
        double d1 = (double)l / (double)horiz;
        double[][] adouble = new double[][]{this.func_222547_b(i, j, b), this.func_222547_b(i, j + 1, b), this.func_222547_b(i + 1, j, b), this.func_222547_b(i + 1, j + 1, b)};
        int i1 = this.func_222530_f();
        for (int j1 = this.noiseSizeY - 1; j1 >= 0; --j1) {
            double d2 = adouble[0][j1];
            double d3 = adouble[1][j1];
            double d4 = adouble[2][j1];
            double d5 = adouble[3][j1];
            double d6 = adouble[0][j1 + 1];
            double d7 = adouble[1][j1 + 1];
            double d8 = adouble[2][j1 + 1];
            double d9 = adouble[3][j1 + 1];
            for (int k1 = this.verticalNoiseGranularity - 1; k1 >= 0; --k1) {
                double d10 = (double)k1 / (double)this.verticalNoiseGranularity;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int l1 = j1 * this.verticalNoiseGranularity + k1;
                if (!(d11 > 0.0) && l1 >= i1) continue;
                BlockState blockstate = d11 > 0.0 ? this.defaultBlock : this.defaultFluid;
                if (!p_222529_3_.func_222684_d().test(blockstate)) continue;
                return l1 + 1;
            }
        }
        return 0;
    }

    protected abstract void func_222548_a(double[] var1, int var2, int var3, Biome var4);

    public int getY() {
        return this.noiseSizeY + 1;
    }

    public void func_222535_c(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunkIn.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        double d0 = 0.0625;
        Biome[] abiome = chunkIn.func_201590_e();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d = 0.0625;
            }
        }
        this.makeBedrock(chunkIn, (Random)sharedseedrandom);
    }

    protected void makeBedrock(IChunk chunkIn, Random rand) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        GenerationSettings t = this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        int i = this.func_222530_f();
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= l - 12 || l1 <= i1 - 12 || k1 >= l + 15 + 12 || l1 >= i1 + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        double[][][] noiseMap = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int j5 = 0; j5 < this.noiseSizeZ + 1; ++j5) {
            noiseMap[0][j5] = new double[this.noiseSizeY + 1];
            this.func_222548_a(noiseMap[0][j5], j * this.noiseSizeX, k * this.noiseSizeZ + j5, null);
            noiseMap[1][j5] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunkIn;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int k5 = 0; k5 < this.noiseSizeX; ++k5) {
            for (int l5 = 0; l5 < this.noiseSizeZ + 1; ++l5) {
                this.func_222548_a(noiseMap[1][l5], j * this.noiseSizeX + k5 + 1, k * this.noiseSizeZ + l5, null);
            }
            for (int i6 = 0; i6 < this.noiseSizeZ; ++i6) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int j6 = this.noiseSizeY - 1; j6 >= 0; --j6) {
                    double d16 = noiseMap[0][i6][j6];
                    double d17 = noiseMap[0][i6 + 1][j6];
                    double d18 = noiseMap[1][i6][j6];
                    double d0 = noiseMap[1][i6 + 1][j6];
                    double d1 = noiseMap[0][i6][j6 + 1];
                    double d2 = noiseMap[0][i6 + 1][j6 + 1];
                    double d3 = noiseMap[1][i6][j6 + 1];
                    double d4 = noiseMap[1][i6 + 1][j6 + 1];
                    for (int i2 = this.verticalNoiseGranularity - 1; i2 >= 0; --i2) {
                        int j2 = j6 * this.verticalNoiseGranularity + i2;
                        int k2 = j2 & 0xF;
                        int l2 = j2 >> 4;
                        if (chunksection.func_222632_g() >> 4 != l2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(l2);
                            chunksection.func_222635_a();
                        }
                        double d5 = (double)i2 / (double)this.verticalNoiseGranularity;
                        double d6 = MathHelper.func_219803_d((double)d5, (double)d16, (double)d1);
                        double d7 = MathHelper.func_219803_d((double)d5, (double)d18, (double)d3);
                        double d8 = MathHelper.func_219803_d((double)d5, (double)d17, (double)d2);
                        double d9 = MathHelper.func_219803_d((double)d5, (double)d0, (double)d4);
                        for (int i3 = 0; i3 < this.horizontalNoiseGranularity; ++i3) {
                            int j3 = l + k5 * this.horizontalNoiseGranularity + i3;
                            int k3 = j3 & 0xF;
                            double d10 = (double)i3 / (double)this.horizontalNoiseGranularity;
                            double d11 = MathHelper.func_219803_d((double)d10, (double)d6, (double)d7);
                            double d12 = MathHelper.func_219803_d((double)d10, (double)d8, (double)d9);
                            for (int l3 = 0; l3 < this.horizontalNoiseGranularity; ++l3) {
                                int l4;
                                int k4;
                                int i4 = i1 + i6 * this.horizontalNoiseGranularity + l3;
                                int j4 = i4 & 0xF;
                                double d13 = (double)l3 / (double)this.horizontalNoiseGranularity;
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double d15 = MathHelper.func_151237_a((double)(d14 / 200.0), (double)-1.0, (double)1.0);
                                d15 = d15 / 2.0 - d15 * d15 * d15 / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    AbstractVillagePiece abstractvillagepiece1 = (AbstractVillagePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = abstractvillagepiece1.func_74874_b();
                                    k4 = Math.max(0, Math.max(mutableboundingbox.field_78897_a - j3, j3 - mutableboundingbox.field_78893_d));
                                    l4 = j2 - (mutableboundingbox.field_78895_b + abstractvillagepiece1.func_214830_d());
                                    int i5 = Math.max(0, Math.max(mutableboundingbox.field_78896_c - i4, i4 - mutableboundingbox.field_78892_f));
                                    d15 += SmoothNoiseChunkGenerator.func_222556_a(k4, l4, i5) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction1 = (JigsawJunction)objectlistiterator1.next();
                                    int k6 = j3 - jigsawjunction1.func_214895_a();
                                    k4 = j2 - jigsawjunction1.func_214896_b();
                                    l4 = i4 - jigsawjunction1.func_214893_c();
                                    d15 += SmoothNoiseChunkGenerator.func_222556_a(k6, k4, l4) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = d15 > 0.0 ? this.defaultBlock : (j2 < i ? this.defaultFluid : AIR);
                                if (blockstate == AIR) continue;
                                if (blockstate.func_185906_d() != 0) {
                                    blockpos$mutableblockpos.func_181079_c(j3, j2, i4);
                                    chunkprimer.func_201637_h((BlockPos)blockpos$mutableblockpos);
                                }
                                chunksection.func_177484_a(k3, k2, j4, blockstate, false);
                                heightmap.func_202270_a(k3, j2, j4, blockstate);
                                heightmap1.func_202270_a(k3, j2, j4, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = noiseMap[0];
            noiseMap[0] = noiseMap[1];
            noiseMap[1] = adouble1;
        }
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }
}

