/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.chunk;

import com.matez.wildnature.world.gen.biomes.setup.WNBiome;
import com.matez.wildnature.world.gen.biomes.setup.WNGenSettings;
import com.matez.wildnature.world.gen.chunk.WNSimplexChunkGenerator;
import com.matez.wildnature.world.gen.noise.bukkit.SimplexOctaveGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class WNChunkGeneratorEarth
extends WNSimplexChunkGenerator {
    private static final float[] biomeWeights = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_222575_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final SimplexOctaveGenerator depthNoise;
    private final boolean isAmplified;
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final CatSpawner catSpawner = new CatSpawner();
    private final VillageSiege field_225495_n = new VillageSiege();

    public WNChunkGeneratorEarth(IWorld worldIn, BiomeProvider provider, WNGenSettings settingsIn) {
        super(worldIn, provider, settingsIn);
        this.depthNoise = new SimplexOctaveGenerator(worldIn.func_72905_C(), 16);
        this.isAmplified = worldIn.func_72912_H().func_76067_t() == WorldType.field_151360_e;
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_212866_a_(i, j).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    protected void func_222548_a(double[] adouble, int chunkX, int chunkZ) {
        double coordinateScale = 684.412f;
        double heightScale = 1.0;
        double depthSize = 8.555149841308594;
        double unk1 = 4.277574920654297;
        int unk3 = -10;
        int unk2 = 3;
    }

    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        double d0 = 8.5;
        double d1 = ((double)p_222545_5_ - (8.5 + p_222545_1_ * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / p_222545_3_;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1;
    }

    @Override
    public double[] sampleDepthAndScale(int chunkX, int chunkZ) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int i = 2;
        float depth = this.field_222542_c.func_222366_b(chunkX, chunkZ).func_185355_j();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                Biome biome = this.field_222542_c.func_222366_b(chunkX + j, chunkZ + k);
                float biomeDepth = biome.func_185355_j();
                float biomeScale = biome.func_185360_m();
                float biomeHeightVariation = 0.0f;
                if (biome instanceof WNBiome && ((WNBiome)biome).wnBiomeBuilder.getHeightVariation() != null) {
                    biomeHeightVariation = ((WNBiome)biome).wnBiomeBuilder.getHeightVariation().floatValue();
                }
                if (this.isAmplified && biomeDepth > 0.0f) {
                    biomeDepth = 1.0f + biomeDepth * 2.0f;
                    biomeScale = 1.0f + biomeScale * 4.0f;
                }
                float f6 = biomeWeights[j + 2 + (k + 2) * 5] / (biomeDepth + 2.0f);
                if (biome.func_185355_j() > depth) {
                    f6 /= 2.0f;
                }
                f += biomeScale * f6;
                f1 += biomeDepth * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getDepthNoise(chunkX, chunkZ);
        adouble[1] = f;
        return adouble;
    }

    private double getDepthNoise(int p_222574_1_, int p_222574_2_) {
        this.depthNoise.setScale(0.0);
        double d0 = this.depthNoise.noise((double)(p_222574_1_ * 200), 10.0, (double)(p_222574_2_ * 200), 1.0, 0.0, true);
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        if (Feature.field_202334_l.func_202383_b(this.field_222540_a, pos)) {
            if (creatureType == EntityClassification.MONSTER) {
                return Feature.field_202334_l.func_202279_e();
            }
            if (creatureType == EntityClassification.CREATURE) {
                return Feature.field_202334_l.func_214469_f();
            }
        } else if (creatureType == EntityClassification.MONSTER) {
            if (Feature.field_214536_b.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_214536_b.func_202279_e();
            }
            if (Feature.field_202336_n.func_175796_a(this.field_222540_a, pos)) {
                return Feature.field_202336_n.func_202279_e();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.phantomSpawner.func_203232_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.field_225495_n.func_225477_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    @Override
    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return 63;
    }

    @Override
    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type p_222529_3_) {
        return 0;
    }
}

