/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.chunk;

import com.matez.wildnature.world.gen.biomes.setup.WNGenSettings;
import com.matez.wildnature.world.gen.chunk.landscape.ChunkLandscape;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class WNSimplexChunkGenerator
extends ChunkGenerator<WNGenSettings> {
    protected IChunk chunk = null;
    public static final float[] biomeData = (float[])Util.func_200696_a((Object)new float[25], data -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                data[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private WNGenSettings settings;
    private final OctavesNoiseGenerator surfaceDepthNoise;
    protected HashMap<Long, int[]> noiseCache = new HashMap();
    private SharedSeedRandom randomSeed;
    private boolean amplified = false;

    public WNSimplexChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, WNGenSettings generationSettingsIn) {
        super(worldIn, biomeProviderIn, (GenerationSettings)generationSettingsIn);
        this.settings = generationSettingsIn;
        this.randomSeed = new SharedSeedRandom(this.field_222541_b);
        this.surfaceDepthNoise = new OctavesNoiseGenerator((Random)this.randomSeed, 4);
    }

    public void func_222535_c(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = chunkIn.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        double noise = 0.0625;
        Biome[] abiome = chunkIn.func_201590_e();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int x = k + i1;
                int z = l + j1;
                int startHeight = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)x * 0.0625, (double)z * 0.0625, 0.0625, (double)i1 * 0.0625);
                abiome[j1 * 16 + i1].func_206854_a((Random)sharedseedrandom, chunkIn, x, z, startHeight, d1, ((WNGenSettings)this.func_201496_a_()).func_205532_l(), ((WNGenSettings)this.func_201496_a_()).func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
            }
        }
        this.makeBedrock(chunkIn, (Random)sharedseedrandom);
    }

    protected void makeBedrock(IChunk chunkIn, Random rand) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        WNGenSettings t = (WNGenSettings)this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutableblockpos.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public int func_205470_d() {
        return this.func_222530_f() + 1;
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        this.chunk = chunkIn;
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int x = chunkpos.field_77276_a;
        int z = chunkpos.field_77275_b;
        int l = x << 4;
        int i1 = z << 4;
        for (Structure structure : Feature.field_214488_aQ) {
            String s = structure.func_143025_a();
            LongIterator longiterator = chunkIn.func_201578_b(s).iterator();
            while (longiterator.hasNext()) {
                long j1 = longiterator.nextLong();
                ChunkPos chunkpos1 = new ChunkPos(j1);
                IChunk ichunk = worldIn.func_212866_a_(chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                StructureStart structurestart = ichunk.func_201585_a(s);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(chunkpos, 12) || !(structurepiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece;
                    JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                    if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                        objectlist.add((Object)abstractvillagepiece);
                    }
                    for (JigsawJunction jigsawjunction : abstractvillagepiece.func_214829_e()) {
                        int k1 = jigsawjunction.func_214895_a();
                        int l1 = jigsawjunction.func_214893_c();
                        if (k1 <= l - 12 || l1 <= i1 - 12 || k1 >= l + 15 + 12 || l1 >= i1 + 15 + 12) continue;
                        objectlist1.add((Object)jigsawjunction);
                    }
                }
            }
        }
        this.generateTerrain(chunkIn, this.getHeightsInChunk(chunkpos));
    }

    public void generateTerrain(IChunk chunk, int[] noise) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = noise[x * 16 + z];
                double depth = this.sampleDepthAndScale(chunk.func_76632_l().field_77276_a * 16 + x, chunk.func_76632_l().field_77275_b * 16 + z)[0];
                double scale = this.sampleDepthAndScale(chunk.func_76632_l().field_77276_a * 16 + x, chunk.func_76632_l().field_77275_b * 16 + z)[1];
                for (int y = 0; y < 256; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Biome b = chunk.func_217309_c(pos);
                    if ((double)y > (double)height * 0.75 + (double)height * 0.3 * scale + depth * 15.0) {
                        if (y >= this.func_222530_f()) continue;
                        chunk.func_177436_a(pos, this.settings.func_205533_m(), false);
                        continue;
                    }
                    chunk.func_177436_a(pos, this.settings.func_205532_l(), false);
                }
            }
        }
    }

    public double[] sampleDepthAndScale(int x, int z) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int i = 2;
        float depth = this.field_222542_c.func_222366_b(x, z).func_185355_j();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                Biome biome = this.field_222542_c.func_222366_b(x + j, z + k);
                float biomeDepth = biome.func_185355_j();
                float biomeScale = biome.func_185360_m();
                if (this.amplified && biomeDepth > 0.0f) {
                    biomeDepth = 1.0f + biomeDepth * 2.0f;
                    biomeScale = 1.0f + biomeScale * 4.0f;
                }
                float f6 = biomeData[j + 2 + (k + 2) * 5] / (biomeDepth + 2.0f);
                if (biome.func_185355_j() > depth) {
                    f6 /= 2.0f;
                }
                f += biomeScale * f6;
                f1 += biomeDepth * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.func_222574_c(x, z);
        adouble[1] = f;
        return adouble;
    }

    private double func_222574_c(int p_222574_1_, int p_222574_2_) {
        double d0 = this.surfaceDepthNoise.func_215462_a((double)(p_222574_1_ * 200), 10.0, (double)(p_222574_2_ * 200), 1.0, 0.0, true) / 8000.0;
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    protected int[] getHeightsInChunk(ChunkPos pos) {
        int i;
        int[] res = this.noiseCache.get(pos.func_201841_a());
        if (res != null) {
            return res;
        }
        int[] vals = new int[256];
        int threads = 2;
        CompletableFuture[] futures = new CompletableFuture[threads];
        for (i = 0; i < threads; ++i) {
            int position = i;
            futures[i] = CompletableFuture.runAsync(() -> this.useNoise(vals, pos, position * 16 / threads, 16 / threads));
        }
        for (i = 0; i < futures.length; ++i) {
            futures[i].join();
        }
        this.noiseCache.put(pos.func_201841_a(), vals);
        return vals;
    }

    public void useNoise(int[] noise, ChunkPos pos, int start, int size) {
        for (int x = start; x < start + size; ++x) {
            for (int z = 0; z < 16; ++z) {
                noise[x * 16 + z] = this.getTerrainHeight(pos.field_77276_a * 16 + x, pos.field_77275_b * 16 + z);
            }
        }
    }

    public int getTerrainHeight(int x, int z) {
        Biome biome = this.field_222542_c.func_222366_b(x, z);
        ChunkLandscape landscape = ChunkLandscape.getOrCreate(x, z, this.field_222541_b, this.func_222530_f(), biome, this.chunk);
        return (int)landscape.generateHeightmap();
    }

    public int func_222529_a(int x, int z, Heightmap.Type p_222529_3_) {
        return this.getTerrainHeight(x, z);
    }
}

