/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.chunk.landscape;

import com.matez.wildnature.world.gen.noise.OctaveNoiseSampler;
import com.matez.wildnature.world.gen.noise.OpenSimplexNoise;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class ChunkLandscape {
    public static HashMap<String, Class<? extends ChunkLandscape>> landscapeCache = new HashMap();
    protected int x;
    protected int z;
    protected IChunk chunk;
    protected Biome biome;
    protected Random random;
    protected float depth;
    protected float scale;
    protected int octaves = 11;
    protected OctaveNoiseSampler<OpenSimplexNoise> heightNoise;
    protected OctaveNoiseSampler<OpenSimplexNoise> scaleNoise;

    public ChunkLandscape(int x, int z, long seed, Biome biome, IChunk chunkIn) {
        this.x = x;
        this.z = z;
        this.biome = biome;
        this.chunk = chunkIn;
        this.depth = biome.func_185355_j();
        this.scale = biome.func_185360_m();
        this.random = new Random(seed);
        double amplitude = Math.pow(2.0, this.octaves);
        this.heightNoise = new OctaveNoiseSampler<OpenSimplexNoise>(OpenSimplexNoise.class, this.random, this.octaves, 0.75 * amplitude, amplitude, amplitude);
        this.scaleNoise = new OctaveNoiseSampler<OpenSimplexNoise>(OpenSimplexNoise.class, this.random, 2, Math.pow(2.0, 10.0), 0.2, 0.09);
    }

    public static void addLandscape(Biome biome, Class<? extends ChunkLandscape> landscape) {
        landscapeCache.put(biome.getRegistryName().func_110623_a(), landscape);
    }

    private double sigmoid(double noise) {
        return 256.0 / (Math.exp(2.6666667461395264 - noise / 48.0) + 1.0);
    }

    public double generateHeightmap() {
        int xLow = this.x >> 2 << 2;
        int zLow = this.z >> 2 << 2;
        int xUpper = xLow + 4;
        int zUpper = zLow + 4;
        double xProgress = (double)(this.x - xLow) * 0.25;
        double zProgress = (double)(this.z - zLow) * 0.25;
        xProgress = xProgress * xProgress * (3.0 - xProgress * 2.0);
        zProgress = zProgress * zProgress * (3.0 - zProgress * 2.0);
        double[] samples = new double[]{this.sampleArea(xLow, zLow), this.sampleArea(xUpper, zLow), this.sampleArea(xLow, zUpper), this.sampleArea(xUpper, zUpper)};
        double sample = MathHelper.func_219803_d((double)zProgress, (double)MathHelper.func_219803_d((double)xProgress, (double)samples[0], (double)samples[1]), (double)MathHelper.func_219803_d((double)xProgress, (double)samples[2], (double)samples[3]));
        return this.sigmoid(sample);
    }

    private double sampleArea(int x, int z) {
        double noise = this.sampleNoise(x, z);
        noise += this.sampleNoise(x + 4, z);
        noise += this.sampleNoise(x - 4, z);
        noise += this.sampleNoise(x, z + 4);
        noise += this.sampleNoise(x, z - 4);
        noise *= 0.2;
        return noise += 100.0;
    }

    private double sampleNoise(int x, int z) {
        double frequency = this.scaleNoise.sample(x, z);
        double noise = this.heightNoise.sampleCustom(x, z, 1.0, frequency, frequency, this.octaves);
        return noise;
    }

    public ChunkLandscape applyValues(int x, int z, Long seed, Biome biome, IChunk chunkIn) {
        this.x = x;
        this.z = z;
        this.random.setSeed(seed);
        this.biome = biome;
        this.chunk = chunkIn;
        return this;
    }

    public static ChunkLandscape getOrCreate(int x, int z, long seed, int sealevel, Biome biome, IChunk chunkIn) {
        Class<? extends ChunkLandscape> landscape = landscapeCache.get(biome.getRegistryName().func_110623_a());
        if (landscape != null) {
            try {
                return landscape.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE, Biome.class, IChunk.class).newInstance(x, z, seed, biome, chunkIn);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new ChunkLandscape(x, z, seed, biome, chunkIn);
    }
}

