/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.noise;

import com.matez.wildnature.world.gen.noise.NoiseSource;
import com.matez.wildnature.world.gen.noise.Xorshift;
import java.util.concurrent.ThreadLocalRandom;

public final class CellularNoise
implements NoiseSource {
    private final Xorshift randomFactory;

    private static int floor(double n) {
        return n > 0.0 ? (int)n : (int)n - 1;
    }

    private static double frac(double n) {
        return n >= 0.0 ? n - (double)((int)n) : CellularNoise.frac(-n);
    }

    public static CellularNoise getInstance() {
        return new CellularNoise(ThreadLocalRandom.current().nextLong());
    }

    public static CellularNoise getInstance(long seed) {
        return new CellularNoise(seed);
    }

    private static double minimumDistance(Xorshift.Instance r, Point origin) {
        double dnz2;
        double dpz2;
        double dny2;
        double dpy2;
        double dnx2;
        double dpx2;
        Point p = new Point(origin.x + 1.0E-7, origin.y + 1.0E-7, origin.z + 1.0E-7);
        int x = CellularNoise.floor(p.x);
        int y = CellularNoise.floor(p.y);
        int z = CellularNoise.floor(p.z);
        double s = Double.MAX_VALUE;
        s = CellularNoise.processVoxel(r, p, s, x, y, z);
        double d = dpx2 = p.x >= 0.0 ? CellularNoise.square(1.0 - CellularNoise.frac(p.x)) : CellularNoise.square(CellularNoise.frac(p.x));
        if (dpx2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x + 1, y, z);
        }
        double d2 = dnx2 = p.x >= 0.0 ? CellularNoise.square(CellularNoise.frac(p.x)) : CellularNoise.square(1.0 - CellularNoise.frac(p.x));
        if (dnx2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x - 1, y, z);
        }
        double d3 = dpy2 = p.y >= 0.0 ? CellularNoise.square(1.0 - CellularNoise.frac(p.y)) : CellularNoise.square(CellularNoise.frac(p.y));
        if (dpy2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x, y + 1, z);
        }
        double d4 = dny2 = p.y >= 0.0 ? CellularNoise.square(CellularNoise.frac(p.y)) : CellularNoise.square(1.0 - CellularNoise.frac(p.y));
        if (dny2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x, y - 1, z);
        }
        double d5 = dpz2 = p.z >= 0.0 ? CellularNoise.square(1.0 - CellularNoise.frac(p.z)) : CellularNoise.square(CellularNoise.frac(p.z));
        if (dpz2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x, y, z + 1);
        }
        double d6 = dnz2 = p.z >= 0.0 ? CellularNoise.square(CellularNoise.frac(p.z)) : CellularNoise.square(1.0 - CellularNoise.frac(p.z));
        if (dnz2 < s) {
            s = CellularNoise.processVoxel(r, p, s, x, y, z - 1);
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) <= 1) continue;
                    double vd2 = 0.0;
                    if (i < 0) {
                        vd2 += dnx2;
                    } else if (i > 0) {
                        vd2 += dpx2;
                    }
                    if (j < 0) {
                        vd2 += dny2;
                    } else if (j > 0) {
                        vd2 += dpy2;
                    }
                    if (k < 0) {
                        vd2 += dnz2;
                    } else if (k > 0) {
                        vd2 += dpz2;
                    }
                    if (!(vd2 < s)) continue;
                    s = CellularNoise.processVoxel(r, p, s, x + i, y + j, z + k);
                }
            }
        }
        return Math.sqrt(s);
    }

    private static double processVoxel(Xorshift.Instance r, Point p, double s, int x, int y, int z) {
        r.setSeed(x, y, z);
        Point created = new Point((double)x + r.nextDouble(), (double)y + r.nextDouble(), (double)z + r.nextDouble());
        double distance = p.distanceSquared(created);
        if (distance < s) {
            return distance;
        }
        return s;
    }

    private static double square(double n) {
        return n * n;
    }

    private CellularNoise(long seed) {
        this.randomFactory = Xorshift.create(seed);
    }

    @Override
    public double coherentNoise(double x, double y, double z) {
        return this.noise(x, y, z);
    }

    public double noise(double x, double y, double z) {
        return CellularNoise.minimumDistance(this.randomFactory.getInstance(), new Point(x, y, z));
    }

    private static final class Point {
        private final double x;
        private final double y;
        private final double z;

        private Point(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double distanceSquared(Point other) {
            double x2 = this.x - other.x;
            double y2 = this.y - other.y;
            double z2 = this.z - other.z;
            return x2 * x2 + y2 * y2 + z2 * z2;
        }
    }
}

