/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.noise;

public class SuperSimplexNoise {
    private static final int PSIZE = 2048;
    private static final int PMASK = 2047;
    private short[] perm = new short[2048];
    private Grad2[] permGrad2 = new Grad2[2048];
    private Grad3[] permGrad3 = new Grad3[2048];
    private static final LatticePoint2D[] LOOKUP_2D;
    private static final LatticePoint3D[] LOOKUP_3D;
    public static final double N2 = 0.05382168030817933;
    public static final double N3 = 0.2781926117527186;
    private static final Grad2[] GRADIENTS_2D;
    private static final Grad3[] GRADIENTS_3D;

    public SuperSimplexNoise(long seed) {
        int i;
        short[] source = new short[2048];
        for (i = 0; i < 2048; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 2047; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.permGrad2[i] = GRADIENTS_2D[this.perm[i]];
            this.permGrad3[i] = GRADIENTS_3D[this.perm[i]];
            source[r] = source[i];
        }
    }

    public double noise2(double x, double y) {
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        return this.noise2_Base(xs, ys);
    }

    public double noise2_XBeforeY(double x, double y) {
        double xx = x * 0.7071067811865476;
        double yy = y * 1.224744871380249;
        return this.noise2_Base(yy + xx, yy - xx);
    }

    private double noise2_Base(double xs, double ys) {
        double value = 0.0;
        int xsb = SuperSimplexNoise.fastFloor(xs);
        int ysb = SuperSimplexNoise.fastFloor(ys);
        double xsi = xs - (double)xsb;
        double ysi = ys - (double)ysb;
        int a = (int)(xsi + ysi);
        int index = a << 2 | (int)(xsi - ysi / 2.0 + 1.0 - (double)a / 2.0) << 3 | (int)(ysi - xsi / 2.0 + 1.0 - (double)a / 2.0) << 4;
        double ssi = (xsi + ysi) * -0.211324865405187;
        double xi = xsi + ssi;
        double yi = ysi + ssi;
        for (int i = 0; i < 4; ++i) {
            LatticePoint2D c = LOOKUP_2D[index + i];
            double dx = xi + c.dx;
            double dy = yi + c.dy;
            double attn = 0.6666666666666666 - dx * dx - dy * dy;
            if (attn <= 0.0) continue;
            int pxm = xsb + c.xsv & 0x7FF;
            int pym = ysb + c.ysv & 0x7FF;
            Grad2 grad = this.permGrad2[this.perm[pxm] ^ pym];
            double extrapolation = grad.dx * dx + grad.dy * dy;
            attn *= attn;
            value += attn * attn * extrapolation;
        }
        return value;
    }

    public double noise3_Classic(double x, double y, double z) {
        double r = 0.6666666666666666 * (x + y + z);
        double xr = r - x;
        double yr = r - y;
        double zr = r - z;
        return this.noise3_BCC(xr, yr, zr);
    }

    public double noise3_XYBeforeZ(double x, double y, double z) {
        double xy = x + y;
        double s2 = xy * -0.211324865405187;
        double zz = z * 0.577350269189626;
        double xr = x + s2 - zz;
        double yr = y + s2 - zz;
        double zr = xy * 0.577350269189626 + zz;
        return this.noise3_BCC(xr, yr, zr);
    }

    public double noise3_XZBeforeY(double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.577350269189626;
        double xr = x + s2 - yy;
        double zr = z + s2 - yy;
        double yr = xz * 0.577350269189626 + yy;
        return this.noise3_BCC(xr, yr, zr);
    }

    private double noise3_BCC(double xr, double yr, double zr) {
        int xrb = SuperSimplexNoise.fastFloor(xr);
        int yrb = SuperSimplexNoise.fastFloor(yr);
        int zrb = SuperSimplexNoise.fastFloor(zr);
        double xri = xr - (double)xrb;
        double yri = yr - (double)yrb;
        double zri = zr - (double)zrb;
        int xht = (int)(xri + 0.5);
        int yht = (int)(yri + 0.5);
        int zht = (int)(zri + 0.5);
        int index = xht << 0 | yht << 1 | zht << 2;
        double value = 0.0;
        LatticePoint3D c = LOOKUP_3D[index];
        while (c != null) {
            double dxr = xri + c.dxr;
            double dyr = yri + c.dyr;
            double dzr = zri + c.dzr;
            double attn = 0.75 - dxr * dxr - dyr * dyr - dzr * dzr;
            if (attn < 0.0) {
                c = c.nextOnFailure;
                continue;
            }
            int pxm = xrb + c.xrv & 0x7FF;
            int pym = yrb + c.yrv & 0x7FF;
            int pzm = zrb + c.zrv & 0x7FF;
            Grad3 grad = this.permGrad3[this.perm[this.perm[pxm] ^ pym] ^ pzm];
            double extrapolation = grad.dx * dxr + grad.dy * dyr + grad.dz * dzr;
            attn *= attn;
            value += attn * attn * extrapolation;
            c = c.nextOnSuccess;
        }
        return value;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    static {
        int i;
        int i2;
        int j1;
        int i1;
        int i3;
        LOOKUP_2D = new LatticePoint2D[32];
        LOOKUP_3D = new LatticePoint3D[8];
        for (i3 = 0; i3 < 8; ++i3) {
            int j2;
            int i22;
            if ((i3 & 1) == 0) {
                if ((i3 & 2) == 0) {
                    i1 = -1;
                    j1 = 0;
                } else {
                    i1 = 1;
                    j1 = 0;
                }
                if ((i3 & 4) == 0) {
                    i22 = 0;
                    j2 = -1;
                } else {
                    i22 = 0;
                    j2 = 1;
                }
            } else {
                if ((i3 & 2) != 0) {
                    i1 = 2;
                    j1 = 1;
                } else {
                    i1 = 0;
                    j1 = 1;
                }
                if ((i3 & 4) != 0) {
                    i22 = 1;
                    j2 = 2;
                } else {
                    i22 = 1;
                    j2 = 0;
                }
            }
            SuperSimplexNoise.LOOKUP_2D[i3 * 4 + 0] = new LatticePoint2D(0, 0);
            SuperSimplexNoise.LOOKUP_2D[i3 * 4 + 1] = new LatticePoint2D(1, 1);
            SuperSimplexNoise.LOOKUP_2D[i3 * 4 + 2] = new LatticePoint2D(i1, j1);
            SuperSimplexNoise.LOOKUP_2D[i3 * 4 + 3] = new LatticePoint2D(i22, j2);
        }
        for (i3 = 0; i3 < 8; ++i3) {
            i1 = i3 >> 0 & 1;
            j1 = i3 >> 1 & 1;
            int k1 = i3 >> 2 & 1;
            int i23 = i1 ^ 1;
            int j2 = j1 ^ 1;
            int k2 = k1 ^ 1;
            LatticePoint3D c0 = new LatticePoint3D(i1, j1, k1, 0);
            LatticePoint3D c1 = new LatticePoint3D(i1 + i23, j1 + j2, k1 + k2, 1);
            LatticePoint3D c2 = new LatticePoint3D(i1 ^ 1, j1, k1, 0);
            LatticePoint3D c3 = new LatticePoint3D(i1, j1 ^ 1, k1 ^ 1, 0);
            LatticePoint3D c4 = new LatticePoint3D(i1 + (i23 ^ 1), j1 + j2, k1 + k2, 1);
            LatticePoint3D c5 = new LatticePoint3D(i1 + i23, j1 + (j2 ^ 1), k1 + (k2 ^ 1), 1);
            LatticePoint3D c6 = new LatticePoint3D(i1, j1 ^ 1, k1, 0);
            LatticePoint3D c7 = new LatticePoint3D(i1 ^ 1, j1, k1 ^ 1, 0);
            LatticePoint3D c8 = new LatticePoint3D(i1 + i23, j1 + (j2 ^ 1), k1 + k2, 1);
            LatticePoint3D c9 = new LatticePoint3D(i1 + (i23 ^ 1), j1 + j2, k1 + (k2 ^ 1), 1);
            LatticePoint3D cA = new LatticePoint3D(i1, j1, k1 ^ 1, 0);
            LatticePoint3D cB = new LatticePoint3D(i1 ^ 1, j1 ^ 1, k1, 0);
            LatticePoint3D cC = new LatticePoint3D(i1 + i23, j1 + j2, k1 + (k2 ^ 1), 1);
            LatticePoint3D cD = new LatticePoint3D(i1 + (i23 ^ 1), j1 + (j2 ^ 1), k1 + k2, 1);
            c0.nextOnFailure = c0.nextOnSuccess = c1;
            c1.nextOnFailure = c1.nextOnSuccess = c2;
            c2.nextOnFailure = c3;
            c2.nextOnSuccess = c5;
            c3.nextOnFailure = c4;
            c3.nextOnSuccess = c4;
            c4.nextOnFailure = c5;
            c4.nextOnSuccess = c6;
            c5.nextOnFailure = c5.nextOnSuccess = c6;
            c6.nextOnFailure = c7;
            c6.nextOnSuccess = c9;
            c7.nextOnFailure = c8;
            c7.nextOnSuccess = c8;
            c8.nextOnFailure = c9;
            c8.nextOnSuccess = cA;
            c9.nextOnFailure = c9.nextOnSuccess = cA;
            cA.nextOnFailure = cB;
            cA.nextOnSuccess = cD;
            cB.nextOnFailure = cC;
            cB.nextOnSuccess = cC;
            cC.nextOnFailure = cD;
            cC.nextOnSuccess = null;
            cD.nextOnSuccess = null;
            cD.nextOnFailure = null;
            SuperSimplexNoise.LOOKUP_3D[i3] = c0;
        }
        GRADIENTS_2D = new Grad2[2048];
        Grad2[] grad2 = new Grad2[]{new Grad2(0.0, 1.0), new Grad2(0.5, 0.8660254037844387), new Grad2(0.8660254037844387, 0.5), new Grad2(1.0, 0.0), new Grad2(0.8660254037844387, -0.5), new Grad2(0.5, -0.8660254037844387), new Grad2(0.0, -1.0), new Grad2(-0.5, -0.8660254037844387), new Grad2(-0.8660254037844387, -0.5), new Grad2(-1.0, 0.0), new Grad2(-0.8660254037844387, 0.5), new Grad2(-0.5, 0.8660254037844387)};
        Grad2[] grad2XBeforeY = new Grad2[grad2.length];
        for (i2 = 0; i2 < grad2.length; ++i2) {
            grad2[i2].dx /= 0.05382168030817933;
            grad2[i2].dy /= 0.05382168030817933;
        }
        for (i2 = 0; i2 < 2048; ++i2) {
            SuperSimplexNoise.GRADIENTS_2D[i2] = grad2[i2 % grad2.length];
        }
        GRADIENTS_3D = new Grad3[2048];
        Grad3[] grad3 = new Grad3[]{new Grad3(-2.22474487139, -2.22474487139, -1.0), new Grad3(-2.22474487139, -2.22474487139, 1.0), new Grad3(-3.0862664687972017, -1.1721513422464978, 0.0), new Grad3(-1.1721513422464978, -3.0862664687972017, 0.0), new Grad3(-2.22474487139, -1.0, -2.22474487139), new Grad3(-2.22474487139, 1.0, -2.22474487139), new Grad3(-1.1721513422464978, 0.0, -3.0862664687972017), new Grad3(-3.0862664687972017, 0.0, -1.1721513422464978), new Grad3(-2.22474487139, -1.0, 2.22474487139), new Grad3(-2.22474487139, 1.0, 2.22474487139), new Grad3(-3.0862664687972017, 0.0, 1.1721513422464978), new Grad3(-1.1721513422464978, 0.0, 3.0862664687972017), new Grad3(-2.22474487139, 2.22474487139, -1.0), new Grad3(-2.22474487139, 2.22474487139, 1.0), new Grad3(-1.1721513422464978, 3.0862664687972017, 0.0), new Grad3(-3.0862664687972017, 1.1721513422464978, 0.0), new Grad3(-1.0, -2.22474487139, -2.22474487139), new Grad3(1.0, -2.22474487139, -2.22474487139), new Grad3(0.0, -3.0862664687972017, -1.1721513422464978), new Grad3(0.0, -1.1721513422464978, -3.0862664687972017), new Grad3(-1.0, -2.22474487139, 2.22474487139), new Grad3(1.0, -2.22474487139, 2.22474487139), new Grad3(0.0, -1.1721513422464978, 3.0862664687972017), new Grad3(0.0, -3.0862664687972017, 1.1721513422464978), new Grad3(-1.0, 2.22474487139, -2.22474487139), new Grad3(1.0, 2.22474487139, -2.22474487139), new Grad3(0.0, 1.1721513422464978, -3.0862664687972017), new Grad3(0.0, 3.0862664687972017, -1.1721513422464978), new Grad3(-1.0, 2.22474487139, 2.22474487139), new Grad3(1.0, 2.22474487139, 2.22474487139), new Grad3(0.0, 3.0862664687972017, 1.1721513422464978), new Grad3(0.0, 1.1721513422464978, 3.0862664687972017), new Grad3(2.22474487139, -2.22474487139, -1.0), new Grad3(2.22474487139, -2.22474487139, 1.0), new Grad3(1.1721513422464978, -3.0862664687972017, 0.0), new Grad3(3.0862664687972017, -1.1721513422464978, 0.0), new Grad3(2.22474487139, -1.0, -2.22474487139), new Grad3(2.22474487139, 1.0, -2.22474487139), new Grad3(3.0862664687972017, 0.0, -1.1721513422464978), new Grad3(1.1721513422464978, 0.0, -3.0862664687972017), new Grad3(2.22474487139, -1.0, 2.22474487139), new Grad3(2.22474487139, 1.0, 2.22474487139), new Grad3(1.1721513422464978, 0.0, 3.0862664687972017), new Grad3(3.0862664687972017, 0.0, 1.1721513422464978), new Grad3(2.22474487139, 2.22474487139, -1.0), new Grad3(2.22474487139, 2.22474487139, 1.0), new Grad3(3.0862664687972017, 1.1721513422464978, 0.0), new Grad3(1.1721513422464978, 3.0862664687972017, 0.0)};
        for (i = 0; i < grad3.length; ++i) {
            grad3[i].dx /= 0.2781926117527186;
            grad3[i].dy /= 0.2781926117527186;
            grad3[i].dz /= 0.2781926117527186;
        }
        for (i = 0; i < 2048; ++i) {
            SuperSimplexNoise.GRADIENTS_3D[i] = grad3[i % grad3.length];
        }
    }

    public static class Grad3 {
        double dx;
        double dy;
        double dz;

        public Grad3(double dx, double dy, double dz) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }
    }

    public static class Grad2 {
        double dx;
        double dy;

        public Grad2(double dx, double dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }

    private static class LatticePoint3D {
        public double dxr;
        public double dyr;
        public double dzr;
        public int xrv;
        public int yrv;
        public int zrv;
        LatticePoint3D nextOnFailure;
        LatticePoint3D nextOnSuccess;

        public LatticePoint3D(int xrv, int yrv, int zrv, int lattice) {
            this.dxr = (double)(-xrv) + (double)lattice * 0.5;
            this.dyr = (double)(-yrv) + (double)lattice * 0.5;
            this.dzr = (double)(-zrv) + (double)lattice * 0.5;
            this.xrv = xrv + lattice * 1024;
            this.yrv = yrv + lattice * 1024;
            this.zrv = zrv + lattice * 1024;
        }
    }

    private static class LatticePoint2D {
        int xsv;
        int ysv;
        double dx;
        double dy;

        public LatticePoint2D(int xsv, int ysv) {
            this.xsv = xsv;
            this.ysv = ysv;
            double ssv = (double)(xsv + ysv) * -0.211324865405187;
            this.dx = (double)(-xsv) - ssv;
            this.dy = (double)(-ysv) - ssv;
        }
    }
}

