/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.noise.bukkit;

import com.matez.wildnature.world.gen.noise.bukkit.NoiseGenerator;
import com.matez.wildnature.world.gen.noise.bukkit.OctaveGenerator;
import com.matez.wildnature.world.gen.noise.bukkit.SimplexNoiseGenerator;
import java.util.Random;
import net.minecraft.world.World;

public class SimplexOctaveGenerator
extends OctaveGenerator {
    private double wScale = 1.0;

    public SimplexOctaveGenerator(World world, int octaves) {
        this(new Random(world.func_72905_C()), octaves);
    }

    public SimplexOctaveGenerator(long seed, int octaves) {
        this(new Random(seed), octaves);
    }

    public SimplexOctaveGenerator(Random rand, int octaves) {
        super(SimplexOctaveGenerator.createOctaves(rand, octaves));
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
        this.setWScale(scale);
    }

    public double getWScale() {
        return this.wScale;
    }

    public void setWScale(double scale) {
        this.wScale = scale;
    }

    public double noise(double x, double y, double z, double w, double frequency, double amplitude) {
        return this.noise(x, y, z, w, frequency, amplitude, false);
    }

    public double noise(double x, double y, double z, double w, double frequency, double amplitude, boolean normalized) {
        double result = 0.0;
        double amp = 1.0;
        double freq = 1.0;
        double max = 0.0;
        x *= this.xScale;
        y *= this.yScale;
        z *= this.zScale;
        w *= this.wScale;
        for (NoiseGenerator octave : this.octaves) {
            result += ((SimplexNoiseGenerator)octave).noise(x * freq, y * freq, z * freq, w * freq) * amp;
            max += amp;
            freq *= frequency;
            amp *= amplitude;
        }
        if (normalized) {
            result /= max;
        }
        return result;
    }

    private static NoiseGenerator[] createOctaves(Random rand, int octaves) {
        NoiseGenerator[] result = new NoiseGenerator[octaves];
        for (int i = 0; i < octaves; ++i) {
            result[i] = new SimplexNoiseGenerator(rand);
        }
        return result;
    }
}

