/*
 * Decompiled with CFR 0.152.
 */
package com.matez.wildnature.world.gen.noise.sponge.module.combiner;

import com.matez.wildnature.world.gen.noise.sponge.Utils;
import com.matez.wildnature.world.gen.noise.sponge.exception.NoModuleException;
import com.matez.wildnature.world.gen.noise.sponge.module.Module;

public class Select
extends Module {
    public static final double DEFAULT_SELECT_EDGE_FALLOFF = 0.0;
    public static final double DEFAULT_SELECT_LOWER_BOUND = -1.0;
    public static final double DEFAULT_SELECT_UPPER_BOUND = 1.0;
    private double edgeFalloff = 0.0;
    private double lowerBound = -1.0;
    private double upperBound = 1.0;

    public Select() {
        super(3);
    }

    public Module getControlModule() {
        if (this.sourceModule == null || this.sourceModule[2] == null) {
            throw new NoModuleException();
        }
        return this.sourceModule[2];
    }

    public void setControlModule(Module m) {
        if (m == null) {
            throw new IllegalArgumentException("the module cannot be null");
        }
        this.sourceModule[2] = m;
    }

    public double getEdgeFalloff() {
        return this.edgeFalloff;
    }

    public void setEdgeFalloff(double edgeFalloff) {
        double boundSize = this.upperBound - this.lowerBound;
        this.edgeFalloff = edgeFalloff > boundSize / 2.0 ? boundSize / 2.0 : edgeFalloff;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setBounds(double upper, double lower) {
        if (lower > upper) {
            throw new IllegalArgumentException("lower must be less than upper");
        }
        this.lowerBound = lower;
        this.upperBound = upper;
        this.setEdgeFalloff(this.edgeFalloff);
    }

    @Override
    public int getSourceModuleCount() {
        return 3;
    }

    @Override
    public double getValue(double x, double y, double z) {
        if (this.sourceModule[0] == null) {
            throw new NoModuleException();
        }
        if (this.sourceModule[1] == null) {
            throw new NoModuleException();
        }
        if (this.sourceModule[2] == null) {
            throw new NoModuleException();
        }
        double controlValue = this.sourceModule[2].getValue(x, y, z);
        if (this.edgeFalloff > 0.0) {
            if (controlValue < this.lowerBound - this.edgeFalloff) {
                return this.sourceModule[0].getValue(x, y, z);
            }
            if (controlValue < this.lowerBound + this.edgeFalloff) {
                double lowerCurve = this.lowerBound - this.edgeFalloff;
                double upperCurve = this.lowerBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceModule[0].getValue(x, y, z), this.sourceModule[1].getValue(x, y, z), alpha);
            }
            if (controlValue < this.upperBound - this.edgeFalloff) {
                return this.sourceModule[1].getValue(x, y, z);
            }
            if (controlValue < this.upperBound + this.edgeFalloff) {
                double lowerCurve = this.upperBound - this.edgeFalloff;
                double upperCurve = this.upperBound + this.edgeFalloff;
                double alpha = Utils.sCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Utils.linearInterp(this.sourceModule[1].getValue(x, y, z), this.sourceModule[0].getValue(x, y, z), alpha);
            }
            return this.sourceModule[0].getValue(x, y, z);
        }
        if (controlValue < this.lowerBound || controlValue > this.upperBound) {
            return this.sourceModule[0].getValue(x, y, z);
        }
        return this.sourceModule[1].getValue(x, y, z);
    }
}

